"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcLink = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Define a new VPC Link
 * Specifies an API Gateway VPC link for a HTTP API to access resources in an Amazon Virtual Private Cloud (VPC).
 */
class VpcLink extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.subnets = new Array();
        this.securityGroups = new Array();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_VpcLinkProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcLink);
            }
            throw error;
        }
        this.vpc = props.vpc;
        const cfnResource = new aws_apigatewayv2_1.CfnVpcLink(this, 'Resource', {
            name: props.vpcLinkName || aws_cdk_lib_1.Lazy.string({ produce: () => aws_cdk_lib_1.Names.uniqueId(this) }),
            subnetIds: aws_cdk_lib_1.Lazy.list({ produce: () => this.renderSubnets() }),
            securityGroupIds: aws_cdk_lib_1.Lazy.list({ produce: () => this.renderSecurityGroups() }),
        });
        this.vpcLinkId = cfnResource.ref;
        const { subnets } = props.vpc.selectSubnets(props.subnets ?? { subnetType: ec2.SubnetType.PRIVATE_WITH_EGRESS });
        this.addSubnets(...subnets);
        if (props.securityGroups) {
            this.addSecurityGroups(...props.securityGroups);
        }
    }
    /**
     * Import a VPC Link by specifying its attributes.
     */
    static fromVpcLinkAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_VpcLinkAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromVpcLinkAttributes);
            }
            throw error;
        }
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.vpcLinkId = attrs.vpcLinkId;
                this.vpc = attrs.vpc;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds the provided subnets to the vpc link
     *
     * @param subnets
     */
    addSubnets(...subnets) {
        this.subnets.push(...subnets);
    }
    /**
     * Adds the provided security groups to the vpc link
     *
     * @param groups
     */
    addSecurityGroups(...groups) {
        this.securityGroups.push(...groups);
    }
    renderSubnets() {
        return this.subnets.map(subnet => subnet.subnetId);
    }
    renderSecurityGroups() {
        return this.securityGroups.map(sg => sg.securityGroupId);
    }
}
exports.VpcLink = VpcLink;
_a = JSII_RTTI_SYMBOL_1;
VpcLink[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.VpcLink", version: "2.42.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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