/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.serialization;

import java.io.Serializable;
import org.ergoplatform.validation.SigmaValidationSettings;
import org.ergoplatform.validation.ValidationException;
import org.ergoplatform.validation.ValidationRules$CheckDeserializedScriptIsSigmaProp$;
import org.ergoplatform.validation.ValidationRules$CheckHeaderSizeBit$;
import org.ergoplatform.validation.ValidationRules$CheckPositionLimit$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.IterableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scalan.util.Extensions$;
import scalan.util.Extensions$LongOps$;
import sigmastate.SSigmaProp$;
import sigmastate.SType;
import sigmastate.Values;
import sigmastate.Values$Constant$;
import sigmastate.Values$ErgoTree$;
import sigmastate.lang.DeserializationSigmaBuilder$;
import sigmastate.lang.Terms$;
import sigmastate.lang.Terms$ValueOps$;
import sigmastate.lang.exceptions.InputSizeLimitExceeded;
import sigmastate.lang.exceptions.SerializerException;
import sigmastate.serialization.ConstantSerializer;
import sigmastate.serialization.ConstantStore;
import sigmastate.serialization.ConstantStore$;
import sigmastate.serialization.ErgoTreeSerializer$;
import sigmastate.serialization.SigmaSerializer$;
import sigmastate.serialization.ValueSerializer$;
import sigmastate.utils.SigmaByteReader;
import sigmastate.utils.SigmaByteWriter;
import sigmastate.utxo.ComplexityTable$;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005BQ\u0001\n\u0001\u0005\n\u0015BQa\u0010\u0001\u0005\n\u0001CQ\u0001\u0013\u0001\u0005\u0002%CQa\u0013\u0001\u0005\u00021CQa\u0013\u0001\u0005\u0002=Caa\u0013\u0001\u0005\u0002YQ\u0006\"\u00022\u0001\t\u0013\u0019\u0007bB6\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007a\u0002\u0001\u000b\u0011B7\t\u000bE\u0004A\u0011\u0002:\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005mqaBA()!\u0005\u0011\u0011\u000b\u0004\u0007'QA\t!a\u0015\t\r\u0001zA\u0011AA+\u0011%\t9f\u0004b\u0001\n\u0003\tI\u0006C\u0004\u0002\\=\u0001\u000b\u0011\u0002\u0012\u0003%\u0015\u0013xm\u001c+sK\u0016\u001cVM]5bY&TXM\u001d\u0006\u0003+Y\tQb]3sS\u0006d\u0017N_1uS>t'\"A\f\u0002\u0015MLw-\\1ti\u0006$Xm\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002)\u0005y1/\u001a:jC2L'0\u001a%fC\u0012,'\u000fF\u0002'S]\u0002\"aG\u0014\n\u0005!b\"\u0001B+oSRDQA\u000b\u0002A\u0002-\n\u0001\"\u001a:h_R\u0013X-\u001a\t\u0003YQr!!\f\u001a\u000f\u00059\nT\"A\u0018\u000b\u0005AB\u0012A\u0002\u001fs_>$h(C\u0001\u0018\u0013\t\u0019d#\u0001\u0004WC2,Xm]\u0005\u0003kY\u0012\u0001\"\u0012:h_R\u0013X-\u001a\u0006\u0003gYAQ\u0001\u000f\u0002A\u0002e\n\u0011a\u001e\t\u0003uuj\u0011a\u000f\u0006\u0003yY\tQ!\u001e;jYNL!AP\u001e\u0003\u001fMKw-\\1CsR,wK]5uKJ\fAc]3sS\u0006d\u0017N_3XSRDw.\u001e;TSj,GCA!H!\rY\"\tR\u0005\u0003\u0007r\u0011Q!\u0011:sCf\u0004\"aG#\n\u0005\u0019c\"\u0001\u0002\"zi\u0016DQAK\u0002A\u0002-\n\u0011c]3sS\u0006d\u0017N_3Fe\u001e|GK]3f)\t\t%\nC\u0003+\t\u0001\u00071&A\neKN,'/[1mSj,WI]4p)J,W\r\u0006\u0002,\u001b\")a*\u0002a\u0001\u0003\u0006)!-\u001f;fgR\u00191\u0006U+\t\u000bE3\u0001\u0019\u0001*\u0002\u0003I\u0004\"AO*\n\u0005Q[$aD*jO6\f')\u001f;f%\u0016\fG-\u001a:\t\u000bY3\u0001\u0019A,\u0002!5\f\u0007\u0010\u0016:fKNK'0\u001a\"zi\u0016\u001c\bCA\u000eY\u0013\tIFDA\u0002J]R$BaK.];\")\u0011k\u0002a\u0001%\")ak\u0002a\u0001/\")al\u0002a\u0001?\u0006I1\r[3dWRK\b/\u001a\t\u00037\u0001L!!\u0019\u000f\u0003\u000f\t{w\u000e\\3b]\u0006AB-Z:fe&\fG.\u001b>f\u0011\u0016\fG-\u001a:B]\u0012\u001c\u0016N_3\u0015\u0005\u0011T\u0007\u0003B\u000ef\t\u001eL!A\u001a\u000f\u0003\rQ+\b\u000f\\33!\rY\u0002nV\u0005\u0003Sr\u0011aa\u00149uS>t\u0007\"B)\t\u0001\u0004\u0011\u0016AE2p]N$\u0018M\u001c;TKJL\u0017\r\\5{KJ,\u0012!\u001c\t\u0003G9L!a\u001c\u000b\u0003%\r{gn\u001d;b]R\u001cVM]5bY&TXM]\u0001\u0014G>t7\u000f^1oiN+'/[1mSj,'\u000fI\u0001\u0015I\u0016\u001cXM]5bY&TXmQ8ogR\fg\u000e^:\u0015\u000bM\f9!a\u0003\u0011\u0007QLHP\u0004\u0002vo:\u0011aF^\u0005\u0002;%\u0011\u0001\u0010H\u0001\ba\u0006\u001c7.Y4f\u0013\tQ8P\u0001\u0006J]\u0012,\u00070\u001a3TKFT!\u0001\u001f\u000f\u0011\u00071jx0\u0003\u0002\u007fm\tA1i\u001c8ti\u0006tG\u000f\u0005\u0003\u0002\u0002\u0005\rQ\"\u0001\f\n\u0007\u0005\u0015aCA\u0003T)f\u0004X\r\u0003\u0004\u0002\n-\u0001\r\u0001R\u0001\u0007Q\u0016\fG-\u001a:\t\u000bE[\u0001\u0019\u0001*\u0002=\u0011,7/\u001a:jC2L'0\u001a%fC\u0012,'oV5uQR\u0013X-\u001a\"zi\u0016\u001cH\u0003BA\t\u0003/\u0001raGA\n\t\u001e\u001c\u0018)C\u0002\u0002\u0016q\u0011a\u0001V;qY\u0016$\u0004\"B)\r\u0001\u0004\u0011\u0016aE:vEN$\u0018\u000e^;uK\u000e{gn\u001d;b]R\u001cH\u0003CA\u000f\u0003s\ti$a\u0011\u0015\t\u0005}\u0011\u0011\u0005\t\u00057\u0015\fu\u000bC\u0004\u0002$5\u0001\u001d!!\n\u0002\u0005Y\u001c\b\u0003BA\u0014\u0003ki!!!\u000b\u000b\t\u0005-\u0012QF\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'\u0002BA\u0018\u0003c\tA\"\u001a:h_Bd\u0017\r\u001e4pe6T!!a\r\u0002\u0007=\u0014x-\u0003\u0003\u00028\u0005%\"aF*jO6\fg+\u00197jI\u0006$\u0018n\u001c8TKR$\u0018N\\4t\u0011\u0019\tY$\u0004a\u0001\u0003\u0006Y1o\u0019:jaR\u0014\u0015\u0010^3t\u0011\u001d\ty$\u0004a\u0001\u0003\u0003\n\u0011\u0002]8tSRLwN\\:\u0011\u0007m\u0011u\u000bC\u0004\u0002F5\u0001\r!a\u0012\u0002\u000f9,wOV1mgB!1DQA%!\u0011a\u00131J@\n\u0007\u00055cGA\u0003WC2,X-\u0001\nFe\u001e|GK]3f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bCA\u0012\u0010'\ty!\u0004\u0006\u0002\u0002R\u0005\tB)\u001a4bk2$8+\u001a:jC2L'0\u001a:\u0016\u0003\t\n!\u0003R3gCVdGoU3sS\u0006d\u0017N_3sA\u0001")
public class ErgoTreeSerializer {
    private final ConstantSerializer constantSerializer = new ConstantSerializer(DeserializationSigmaBuilder$.MODULE$);

    public static ErgoTreeSerializer DefaultSerializer() {
        return ErgoTreeSerializer$.MODULE$.DefaultSerializer();
    }

    private void serializeHeader(Values.ErgoTree ergoTree, SigmaByteWriter w) {
        w.put(ergoTree.header());
        if (ergoTree.isConstantSegregation()) {
            ConstantSerializer constantSerializer = new ConstantSerializer(DeserializationSigmaBuilder$.MODULE$);
            IndexedSeq<Values.Constant<SType>> constants = ergoTree.constants();
            int nConstants = constants.length();
            w.putUInt(nConstants);
            for (int index$macro$1 = 0; index$macro$1 < nConstants; ++index$macro$1) {
                Values.Constant c = (Values.Constant)constants.apply(index$macro$1);
                constantSerializer.serialize(c, w);
            }
        }
    }

    private byte[] serializeWithoutSize(Values.ErgoTree ergoTree) {
        SigmaByteWriter w = SigmaSerializer$.MODULE$.startWriter();
        this.serializeHeader(ergoTree, w);
        Predef$.MODULE$.assert(ergoTree.isRightParsed(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Right parsed ErgoTree expected: ").append(ergoTree).toString());
        ValueSerializer$.MODULE$.serialize(ergoTree.root().right().get(), w);
        return w.toBytes();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] serializeErgoTree(Values.ErgoTree ergoTree) {
        void var3_12;
        byte[] byArray;
        Left left;
        Values.UnparsedErgoTree unparsedErgoTree;
        Either<Values.UnparsedErgoTree, Values.Value<SSigmaProp$>> either2 = ergoTree.root();
        if (either2 instanceof Left && (unparsedErgoTree = (Values.UnparsedErgoTree)(left = (Left)either2).value()) != null) {
            WrappedArray<Object> bytes = unparsedErgoTree.bytes();
            byArray = (byte[])bytes.array();
        } else {
            byte[] byArray2;
            byte[] bytes = this.serializeWithoutSize(ergoTree);
            if (ergoTree.hasSize()) {
                SigmaByteWriter w = SigmaSerializer$.MODULE$.startWriter();
                byte header = bytes[0];
                int contentLength = bytes.length - 1;
                byte[] contentBytes = new byte[contentLength];
                Array$.MODULE$.copy(bytes, 1, contentBytes, 0, contentLength);
                w.put(header);
                w.putUInt(contentLength);
                w.putBytes(contentBytes);
                byArray2 = w.toBytes();
            } else {
                byArray2 = bytes;
            }
            byArray = byArray2;
        }
        byte[] res = byArray;
        return var3_12;
    }

    public Values.ErgoTree deserializeErgoTree(byte[] bytes) {
        SigmaByteReader r = SigmaSerializer$.MODULE$.startReader(bytes, SigmaSerializer$.MODULE$.startReader$default$2());
        return this.deserializeErgoTree(r, SigmaSerializer$.MODULE$.MaxPropositionSize());
    }

    public Values.ErgoTree deserializeErgoTree(SigmaByteReader r, int maxTreeSizeBytes) {
        return this.deserializeErgoTree(r, maxTreeSizeBytes, true);
    }

    public Values.ErgoTree deserializeErgoTree(SigmaByteReader r, int maxTreeSizeBytes, boolean checkType) {
        Values.ErgoTree ergoTree;
        int startPos = r.position();
        int previousPositionLimit = r.positionLimit();
        int previousComplexity = r.complexity();
        r.positionLimit_$eq(r.position() + maxTreeSizeBytes);
        r.complexity_$eq(0);
        Tuple2<Object, Option<Object>> tuple2 = this.deserializeHeaderAndSize(r);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte h = BoxesRunTime.unboxToByte(tuple2._1());
        Option<Object> sizeOpt = tuple2._2();
        Tuple2<Byte, Option<Object>> tuple22 = new Tuple2<Byte, Option<Object>>(BoxesRunTime.boxToByte(h), sizeOpt);
        Tuple2<Byte, Option<Object>> tuple23 = tuple22;
        byte h2 = BoxesRunTime.unboxToByte(tuple23._1());
        Option<Object> sizeOpt2 = tuple23._2();
        int bodyPos = r.position();
        try {
            try {
                try {
                    IndexedSeq<Values.Constant<SType>> cs = this.deserializeConstants(h2, r);
                    ConstantStore previousConstantStore = r.constantStore();
                    r.constantStore_$eq(new ConstantStore(cs));
                    boolean wasDeserialize_saved = r.wasDeserialize();
                    r.wasDeserialize_$eq(false);
                    Object root = ValueSerializer$.MODULE$.deserialize(r);
                    boolean hasDeserialize = r.wasDeserialize();
                    r.wasDeserialize_$eq(wasDeserialize_saved);
                    if (checkType) {
                        ValidationRules$CheckDeserializedScriptIsSigmaProp$.MODULE$.apply((Values.Value<SType>)root);
                    }
                    r.constantStore_$eq(previousConstantStore);
                    int complexity = r.complexity();
                    int treeSize = r.position() - startPos;
                    r.position_$eq(startPos);
                    byte[] propositionBytes = r.getBytes(treeSize);
                    ergoTree = new Values.ErgoTree(h2, cs, package$.MODULE$.Right().apply(Terms$ValueOps$.MODULE$.asSigmaProp$extension(Terms$.MODULE$.ValueOps((Values.Value<SType>)root))), complexity, propositionBytes, new Some<Object>(BoxesRunTime.boxToBoolean(hasDeserialize)));
                }
                catch (InputSizeLimitExceeded e) {
                    throw new ValidationException("Data size check failed", ValidationRules$CheckPositionLimit$.MODULE$, Nil$.MODULE$, new Some<Throwable>(e));
                }
            }
            catch (ValidationException ve) {
                Option<Object> option = sizeOpt2;
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new SerializerException("Cannot handle ValidationException, ErgoTree serialized without size bit.", None$.MODULE$, new Some<Throwable>(ve));
                    }
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                int treeSize = BoxesRunTime.unboxToInt(some.value());
                int numBytes = bodyPos - startPos + treeSize;
                r.position_$eq(startPos);
                byte[] bytes = r.getBytes(numBytes);
                int complexity = BoxesRunTime.unboxToInt(ComplexityTable$.MODULE$.OpCodeComplexity().apply(BoxesRunTime.boxToByte(Values$Constant$.MODULE$.opCode())));
                Values.ErgoTree ergoTree2 = new Values.ErgoTree(Values$ErgoTree$.MODULE$.DefaultHeader(), Values$ErgoTree$.MODULE$.EmptyConstants(), package$.MODULE$.Left().apply(new Values.UnparsedErgoTree(Predef$.MODULE$.wrapByteArray(bytes), ve)), complexity, bytes, None$.MODULE$);
                ergoTree = ergoTree2;
            }
        }
        finally {
            r.positionLimit_$eq(previousPositionLimit);
            r.complexity_$eq(previousComplexity);
        }
        Values.ErgoTree tree = ergoTree;
        return tree;
    }

    private Tuple2<Object, Option<Object>> deserializeHeaderAndSize(SigmaByteReader r) {
        Option option;
        byte header = r.getByte();
        ValidationRules$CheckHeaderSizeBit$.MODULE$.apply(header);
        if (Values$ErgoTree$.MODULE$.hasSize(header)) {
            int size = Extensions$LongOps$.MODULE$.toIntExact$extension(Extensions$.MODULE$.LongOps(r.getUInt()));
            option = new Some<Integer>(BoxesRunTime.boxToInteger(size));
        } else {
            option = None$.MODULE$;
        }
        None$ sizeOpt = option;
        return new Tuple2<Object, Option<Object>>(BoxesRunTime.boxToByte(header), sizeOpt);
    }

    private ConstantSerializer constantSerializer() {
        return this.constantSerializer;
    }

    /*
     * WARNING - void declaration
     */
    private IndexedSeq<Values.Constant<SType>> deserializeConstants(byte header, SigmaByteReader r) {
        void var3_6;
        IndexedSeq<Values.Constant<SType>> indexedSeq;
        if (Values$ErgoTree$.MODULE$.isConstantSegregation(header)) {
            int nConsts = (int)r.getUInt();
            if (nConsts > 0) {
                Values.Constant[] res = (Values.Constant[])ValueSerializer$.MODULE$.newArray(nConsts, ClassTag$.MODULE$.apply(Values.Constant.class));
                for (int index$macro$1 = 0; index$macro$1 < nConsts; ++index$macro$1) {
                    res[index$macro$1] = this.constantSerializer().deserialize(r);
                }
                indexedSeq = Predef$.MODULE$.wrapRefArray((Object[])res);
            } else {
                indexedSeq = Values$Constant$.MODULE$.EmptySeq();
            }
        } else {
            indexedSeq = Values$Constant$.MODULE$.EmptySeq();
        }
        IndexedSeq<Values.Constant<SType>> constants = indexedSeq;
        return var3_6;
    }

    public Tuple4<Object, Option<Object>, IndexedSeq<Values.Constant<SType>>, byte[]> deserializeHeaderWithTreeBytes(SigmaByteReader r) {
        Tuple2<Object, Option<Object>> tuple2 = this.deserializeHeaderAndSize(r);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte header = BoxesRunTime.unboxToByte(tuple2._1());
        Option<Object> sizeOpt = tuple2._2();
        Tuple2<Byte, Option<Object>> tuple22 = new Tuple2<Byte, Option<Object>>(BoxesRunTime.boxToByte(header), sizeOpt);
        Tuple2<Byte, Option<Object>> tuple23 = tuple22;
        byte header2 = BoxesRunTime.unboxToByte(tuple23._1());
        Option<Object> sizeOpt2 = tuple23._2();
        IndexedSeq<Values.Constant<SType>> constants = this.deserializeConstants(header2, r);
        byte[] treeBytes = r.getBytes(r.remaining());
        return new Tuple4<Object, Option<Object>, IndexedSeq<Values.Constant<SType>>, byte[]>(BoxesRunTime.boxToByte(header2), sizeOpt2, constants, treeBytes);
    }

    public Tuple2<byte[], Object> substituteConstants(byte[] scriptBytes, int[] positions, Values.Value<SType>[] newVals, SigmaValidationSettings vs) {
        Predef$.MODULE$.require(positions.length == newVals.length, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(84).append("expected positions and newVals to have the same length, got: positions: ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(positions)).toSeq()).append(",\n newVals: ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])newVals)).toSeq()).toString());
        SigmaByteReader r = SigmaSerializer$.MODULE$.startReader(scriptBytes, SigmaSerializer$.MODULE$.startReader$default$2());
        Tuple4<Object, Option<Object>, IndexedSeq<Values.Constant<SType>>, byte[]> tuple4 = this.deserializeHeaderWithTreeBytes(r);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        byte header = BoxesRunTime.unboxToByte(tuple4._1());
        IndexedSeq<Values.Constant<SType>> constants = tuple4._3();
        byte[] treeBytes = tuple4._4();
        Tuple3<Byte, IndexedSeq<Values.Constant<SType>>, byte[]> tuple3 = new Tuple3<Byte, IndexedSeq<Values.Constant<SType>>, byte[]>(BoxesRunTime.boxToByte(header), constants, treeBytes);
        Tuple3<Byte, IndexedSeq<Values.Constant<SType>>, byte[]> tuple32 = tuple3;
        byte header2 = BoxesRunTime.unboxToByte(tuple32._1());
        IndexedSeq<Values.Constant<SType>> constants2 = tuple32._2();
        byte[] treeBytes2 = tuple32._3();
        SigmaByteWriter w = SigmaSerializer$.MODULE$.startWriter();
        w.put(header2);
        w.putUInt(constants2.length());
        ConstantSerializer constantSerializer = new ConstantSerializer(DeserializationSigmaBuilder$.MODULE$);
        ((IterableLike)constants2.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            ErgoTreeSerializer.$anonfun$substituteConstants$2(positions, newVals, constantSerializer, w, x0$1);
            return BoxedUnit.UNIT;
        });
        w.putBytes(treeBytes2);
        return new Tuple2<byte[], Object>(w.toBytes(), BoxesRunTime.boxToInteger(constants2.length()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$substituteConstants$2(int[] positions$1, Values.Value[] newVals$1, ConstantSerializer constantSerializer$1, SigmaByteWriter w$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Values.Constant c = (Values.Constant)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(positions$1)).contains(BoxesRunTime.boxToInteger(i))) {
                Values.Value newVal = newVals$1[new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(positions$1)).indexOf(BoxesRunTime.boxToInteger(i))];
                ConstantStore constantStore = new ConstantStore(ConstantStore$.MODULE$.$lessinit$greater$default$1());
                SigmaByteWriter valW = SigmaSerializer$.MODULE$.startWriter(constantStore);
                valW.putValue(newVal);
                IndexedSeq<Values.Constant<SType>> newConsts = constantStore.getAll();
                Predef$.MODULE$.assert(newConsts.length() == 1);
                Values.Constant newConst = (Values.Constant)newConsts.head();
                Object s = c.tpe();
                Object s2 = newConst.tpe();
                Predef$.MODULE$.assert(!(s != null ? !s.equals(s2) : s2 != null), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(49).append("expected new constant to have the same ").append(c.tpe()).append(" tpe, got ").append(newConst.tpe()).toString());
                constantSerializer$1.serialize(newConst, w$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Values.Constant c = (Values.Constant)tuple2._1();
        constantSerializer$1.serialize(c, w$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

