/*
 * Decompiled with CFR 0.152.
 */
package scorex.crypto.authds.avltree.batch;

import com.google.common.primitives.Ints;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import scorex.crypto.authds.avltree.batch.AuthenticatedTreeOps;
import scorex.crypto.authds.avltree.batch.BatchAVLVerifier$;
import scorex.crypto.authds.avltree.batch.BatchProofConstants;
import scorex.crypto.authds.avltree.batch.InternalNode;
import scorex.crypto.authds.avltree.batch.InternalVerifierNode;
import scorex.crypto.authds.avltree.batch.LabelOnlyNode;
import scorex.crypto.authds.avltree.batch.Leaf;
import scorex.crypto.authds.avltree.batch.Node;
import scorex.crypto.authds.avltree.batch.Operation;
import scorex.crypto.authds.avltree.batch.ProverNodes;
import scorex.crypto.authds.avltree.batch.ToStringHelper;
import scorex.crypto.authds.avltree.batch.VerifierLeaf;
import scorex.crypto.authds.avltree.batch.VerifierNodes;
import scorex.crypto.authds.package$ADKey$;
import scorex.crypto.authds.package$ADValue$;
import scorex.crypto.authds.package$Balance$;
import scorex.crypto.hash.Blake2b256$;
import scorex.crypto.hash.CryptographicHash;
import scorex.util.ScorexEncoding;
import scorex.util.encode.BytesEncoder;
import scorex.utils.ByteArray$;
import supertagged.package$Tagger$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001B\u00181\u0001mB\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\t[\u0002\u0011\t\u0011)A\u0005]\"A\u0011\u000f\u0001BC\u0002\u0013\u0005#\u000f\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003t\u0011!9\bA!b\u0001\n\u0003B\b\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011B=\t\u0011u\u0004!\u0011!Q\u0001\neD\u0001B \u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\n\u007f\u0002\u0011\t\u0011)A\u0006\u0003\u0003Aq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u0002(\u0001!\t\"!\u000b\t\u0013\u0005\u0015\u0003A1A\u0005B\u0005\u001d\u0003\u0002CA(\u0001\u0001\u0006I!!\u0013\t\u0011\u0005E\u0003A1A\u0005\u0012IDq!a\u0015\u0001A\u0003%1\u000fC\u0004\u0002V\u0001!\t!a\u0016\t\u0011\u0005m\u0003\u00011A\u0005\nID\u0011\"!\u0018\u0001\u0001\u0004%I!a\u0018\t\u000f\u0005\u0015\u0004\u0001)Q\u0005g\"A\u0011q\r\u0001A\u0002\u0013%!\u000fC\u0005\u0002j\u0001\u0001\r\u0011\"\u0003\u0002l!9\u0011q\u000e\u0001!B\u0013\u0019\b\u0002CA9\u0001\u0001\u0007I\u0011\u0002:\t\u0013\u0005M\u0004\u00011A\u0005\n\u0005U\u0004bBA=\u0001\u0001\u0006Ka\u001d\u0005\b\u0003w\u0002A\u0011CA?\u0011\u001d\t\u0019\n\u0001C\t\u0003+Ca!!)\u0001\t#\u0011\bbBAR\u0001\u0011E\u0011Q\u0015\u0005\t\u0003w\u0003\u0001\u0019!C\te\"I\u0011Q\u0018\u0001A\u0002\u0013E\u0011q\u0018\u0005\b\u0003\u0007\u0004\u0001\u0015)\u0003t\u0011)\t)\r\u0001EC\u0002\u0013%\u0011q\u0019\u0005\n\u0003#\u0004\u0001\u0019!C\u0005\u0003\u000fD\u0011\"a5\u0001\u0001\u0004%I!!6\t\u0011\u0005e\u0007\u0001)Q\u0005\u0003\u0013Dq!a7\u0001\t\u0003\ti\u000eC\u0004\u0002x\u0002!\t%!?\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e!9!\u0011\u0005\u0001\u0005\u0002\t\rr!\u0003B\u0014a\u0005\u0005\t\u0012\u0001B\u0015\r!y\u0003'!A\t\u0002\t-\u0002bBA\tU\u0011\u0005!Q\u0006\u0005\n\u0005_Q\u0013\u0013!C\u0001\u0005cA\u0011Ba\u0015+#\u0003%\tA!\u0016\t\u0013\t\u0005$&%A\u0005\u0002\t\r$\u0001\u0005\"bi\u000eD\u0017I\u0016'WKJLg-[3s\u0015\t\t$'A\u0003cCR\u001c\u0007N\u0003\u00024i\u00059\u0011M\u001e7ue\u0016,'BA\u001b7\u0003\u0019\tW\u000f\u001e5eg*\u0011q\u0007O\u0001\u0007GJL\b\u000f^8\u000b\u0003e\naa]2pe\u0016D8\u0001A\u000b\u0005y%\u000b\u0019a\u0005\u0003\u0001{\r\u000b\u0007C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$AB!osJ+g\rE\u0002E\u000b\u001ek\u0011\u0001M\u0005\u0003\rB\u0012A#Q;uQ\u0016tG/[2bi\u0016$GK]3f\u001fB\u001c\bC\u0001%J\u0019\u0001!QA\u0013\u0001C\u0002-\u0013\u0011\u0001R\t\u0003\u0019>\u0003\"AP'\n\u00059{$a\u0002(pi\"Lgn\u001a\t\u0003!zs!!U.\u000f\u0005IKfBA*Y\u001d\t!v+D\u0001V\u0015\t1&(\u0001\u0004=e>|GOP\u0005\u0002s%\u0011q\u0007O\u0005\u00035Z\nA\u0001[1tQ&\u0011A,X\u0001\ba\u0006\u001c7.Y4f\u0015\tQf'\u0003\u0002`A\n1A)[4fgRT!\u0001X/\u0011\u0005\u0011\u0013\u0017BA21\u00059!vn\u0015;sS:<\u0007*\u001a7qKJ\fab\u001d;beRLgn\u001a#jO\u0016\u001cH\u000f\u0005\u0002gU:\u0011q-\u001b\b\u0003%\"L!!\u000e\u001c\n\u0005q#\u0014BA6m\u0005!\tE\tR5hKN$(B\u0001/5\u0003\u0015\u0001(o\\8g!\t1w.\u0003\u0002qY\n\t2+\u001a:jC2L'0\u001a3BIB\u0013xn\u001c4\u0002\u0013-,\u0017\u0010T3oORDW#A:\u0011\u0005y\"\u0018BA;@\u0005\rIe\u000e^\u0001\u000bW\u0016LH*\u001a8hi\"\u0004\u0013A\u0004<bYV,G*\u001a8hi\"|\u0005\u000f^\u000b\u0002sB\u0019aH_:\n\u0005m|$AB(qi&|g.A\bwC2,X\rT3oORDw\n\u001d;!\u0003Ai\u0017\r\u001f(v[>\u0003XM]1uS>t7/\u0001\u0006nCb$U\r\\3uKN\f!\u0001\u001b4\u0011\u0007!\u000b\u0019\u0001B\u0004\u0002\u0006\u0001\u0011\r!a\u0002\u0003\u0005!3\u0015c\u0001'\u0002\nA)\u00111BA\u0007\u000f6\tQ,C\u0002\u0002\u0010u\u0013\u0011c\u0011:zaR|wM]1qQ&\u001c\u0007*Y:i\u0003\u0019a\u0014N\\5u}Qq\u0011QCA\u000e\u0003;\ty\"!\t\u0002$\u0005\u0015B\u0003BA\f\u00033\u0001R\u0001\u0012\u0001H\u0003\u0003A\u0001b \u0006\u0011\u0002\u0003\u000f\u0011\u0011\u0001\u0005\u0006I*\u0001\r!\u001a\u0005\u0006[*\u0001\rA\u001c\u0005\u0006c*\u0001\ra\u001d\u0005\u0006o*\u0001\r!\u001f\u0005\b{*\u0001\n\u00111\u0001z\u0011\u001dq(\u0002%AA\u0002e\f\u0001\u0002\\8h\u000bJ\u0014xN\u001d\u000b\u0005\u0003W\t\t\u0004E\u0002?\u0003[I1!a\f@\u0005\u0011)f.\u001b;\t\u000f\u0005M2\u00021\u0001\u00026\u0005\tA\u000f\u0005\u0003\u00028\u0005}b\u0002BA\u001d\u0003{q1\u0001VA\u001e\u0013\u0005\u0001\u0015B\u0001/@\u0013\u0011\t\t%a\u0011\u0003\u0013QC'o\\<bE2,'B\u0001/@\u0003M\u0019w\u000e\u001c7fGR\u001c\u0005.\u00198hK\u0012tu\u000eZ3t+\t\tI\u0005E\u0002?\u0003\u0017J1!!\u0014@\u0005\u001d\u0011un\u001c7fC:\fAcY8mY\u0016\u001cGo\u00115b]\u001e,GMT8eKN\u0004\u0013a\u00037bE\u0016dG*\u001a8hi\"\fA\u0002\\1cK2dUM\\4uQ\u0002\na\u0001Z5hKN$XCAA-!\rq$0Z\u0001\u0010I&\u0014Xm\u0019;j_:\u001c\u0018J\u001c3fq\u0006\u0019B-\u001b:fGRLwN\\:J]\u0012,\u0007p\u0018\u0013fcR!\u00111FA1\u0011!\t\u0019GEA\u0001\u0002\u0004\u0019\u0018a\u0001=%c\u0005\u0001B-\u001b:fGRLwN\\:J]\u0012,\u0007\u0010I\u0001\u000eY\u0006\u001cHOU5hQR\u001cF/\u001a9\u0002#1\f7\u000f\u001e*jO\"$8\u000b^3q?\u0012*\u0017\u000f\u0006\u0003\u0002,\u00055\u0004\u0002CA2+\u0005\u0005\t\u0019A:\u0002\u001d1\f7\u000f\u001e*jO\"$8\u000b^3qA\u0005Y!/\u001a9mCfLe\u000eZ3y\u0003=\u0011X\r\u001d7bs&sG-\u001a=`I\u0015\fH\u0003BA\u0016\u0003oB\u0001\"a\u0019\u0019\u0003\u0003\u0005\ra]\u0001\re\u0016\u0004H.Y=J]\u0012,\u0007\u0010I\u0001\u0014]\u0016DH\u000fR5sK\u000e$\u0018n\u001c8Jg2+g\r\u001e\u000b\u0007\u0003\u0013\ny(!#\t\u000f\u0005\u0005%\u00041\u0001\u0002\u0004\u0006\u00191.Z=\u0011\u0007\u0019\f))C\u0002\u0002\b2\u0014Q!\u0011#LKfDq!a#\u001b\u0001\u0004\ti)A\u0001s!\u0011!\u0015qR$\n\u0007\u0005E\u0005G\u0001\u0007J]R,'O\\1m\u001d>$W-\u0001\blKfl\u0015\r^2iKNdU-\u00194\u0015\r\u0005%\u0013qSAM\u0011\u001d\t\ti\u0007a\u0001\u0003\u0007Cq!a#\u001c\u0001\u0004\tY\n\u0005\u0003E\u0003;;\u0015bAAPa\t!A*Z1g\u0003A\u0011X\r\u001d7bs\u000e{W\u000e]1sSN|g.A\u0004bI\u0012tu\u000eZ3\u0015\u0011\u0005\u001d\u0016QVAX\u0003c\u0003B\u0001RAU\u000f&\u0019\u00111\u0016\u0019\u0003)%sG/\u001a:oC24VM]5gS\u0016\u0014hj\u001c3f\u0011\u001d\tY)\ba\u0001\u00037Cq!!!\u001e\u0001\u0004\t\u0019\tC\u0004\u00024v\u0001\r!!.\u0002\u0003Y\u00042AZA\\\u0013\r\tI\f\u001c\u0002\b\u0003\u00123\u0016\r\\;f\u00039\u0011xn\u001c;O_\u0012,\u0007*Z5hQR\f!C]8pi:{G-\u001a%fS\u001eDGo\u0018\u0013fcR!\u00111FAa\u0011!\t\u0019gHA\u0001\u0002\u0004\u0019\u0018a\u0004:p_Rtu\u000eZ3IK&<\u0007\u000e\u001e\u0011\u0002#I,7m\u001c8tiJ,8\r^3e)J,W-\u0006\u0002\u0002JB!aH_Af!\u0011!\u0015QZ$\n\u0007\u0005=\u0007GA\u0007WKJLg-[3s\u001d>$Wm]\u0001\bi>\u0004hj\u001c3f\u0003-!x\u000e\u001d(pI\u0016|F%Z9\u0015\t\u0005-\u0012q\u001b\u0005\n\u0003G\u001a\u0013\u0011!a\u0001\u0003\u0013\f\u0001\u0002^8q\u001d>$W\rI\u0001\u0014a\u0016\u0014hm\u001c:n\u001f:,w\n]3sCRLwN\u001c\u000b\u0005\u0003?\fi\u000f\u0005\u0004\u0002b\u0006\u001d\u00181^\u0007\u0003\u0003GT1!!:@\u0003\u0011)H/\u001b7\n\t\u0005%\u00181\u001d\u0002\u0004)JL\b\u0003\u0002 {\u0003kCq!a<&\u0001\u0004\t\t0A\u0005pa\u0016\u0014\u0018\r^5p]B\u0019A)a=\n\u0007\u0005U\bGA\u0005Pa\u0016\u0014\u0018\r^5p]\u0006AAo\\*ue&tw\r\u0006\u0002\u0002|B!\u0011Q B\u0003\u001d\u0011\tyP!\u0001\u0011\u0005Q{\u0014b\u0001B\u0002\u007f\u00051\u0001K]3eK\u001aLAAa\u0002\u0003\n\t11\u000b\u001e:j]\u001eT1Aa\u0001@\u00031)\u0007\u0010\u001e:bGRtu\u000eZ3t)\u0011\u0011yAa\u0006\u0011\tyR(\u0011\u0003\t\u0007\u0003o\u0011\u0019\"a3\n\t\tU\u00111\t\u0002\u0004'\u0016\f\bb\u0002B\rO\u0001\u0007!1D\u0001\nKb$(/Y2u_J\u0004rA\u0010B\u000f\u0003\u0017\fI%C\u0002\u0003 }\u0012\u0011BR;oGRLwN\\\u0019\u0002!\u0015DHO]1di\u001aK'o\u001d;O_\u0012,G\u0003BAe\u0005KAqA!\u0007)\u0001\u0004\u0011Y\"\u0001\tCCR\u001c\u0007.\u0011,M-\u0016\u0014\u0018NZ5feB\u0011AIK\n\u0003Uu\"\"A!\u000b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\u0019\u0011\u0019D!\u0013\u0003LU\u0011!Q\u0007\u0016\u0004s\n]2F\u0001B\u001d!\u0011\u0011YD!\u0012\u000e\u0005\tu\"\u0002\u0002B \u0005\u0003\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\rs(\u0001\u0006b]:|G/\u0019;j_:LAAa\u0012\u0003>\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b)c#\u0019A&\u0005\u000f\u0005\u0015AF1\u0001\u0003NE\u0019AJa\u0014\u0011\r\u0005-\u0011Q\u0002B)!\rA%\u0011J\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\r\tM\"q\u000bB-\t\u0015QUF1\u0001L\t\u001d\t)!\fb\u0001\u00057\n2\u0001\u0014B/!\u0019\tY!!\u0004\u0003`A\u0019\u0001Ja\u0016\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\u0019\u0011)Ga\u001f\u0003~Qq!q\rB8\u0005c\u0012\u0019H!\u001e\u0003x\te$\u0006\u0002B5\u0005oqA!a\u0003\u0003l%\u0019!QN/\u0002\u0015\tc\u0017m[33EJ*d\u0007C\u0003e]\u0001\u0007Q\rC\u0003n]\u0001\u0007a\u000eC\u0003r]\u0001\u00071\u000fC\u0003x]\u0001\u0007\u0011\u0010C\u0003~]\u0001\u0007\u0011\u0010C\u0003\u007f]\u0001\u0007\u0011\u0010B\u0003K]\t\u00071\nB\u0004\u0002\u00069\u0012\rAa \u0012\u00071\u0013\t\t\u0005\u0004\u0002\f\u00055!1\u0011\t\u0004\u0011\nm\u0004")
public class BatchAVLVerifier<D extends byte[], HF extends CryptographicHash<D>>
implements AuthenticatedTreeOps<D> {
    private Option<VerifierNodes<D>> reconstructedTree;
    private final byte[] startingDigest;
    private final byte[] proof;
    private final int keyLength;
    private final Option<Object> valueLengthOpt;
    private final Option<Object> maxNumOperations;
    private final Option<Object> maxDeletes;
    private final HF hf;
    private final boolean collectChangedNodes;
    private final int labelLength;
    private int directionsIndex;
    private int lastRightStep;
    private int replayIndex;
    private int rootNodeHeight;
    private Option<VerifierNodes<D>> topNode;
    private final ArrayBuffer<ProverNodes<D>> changedNodesBuffer;
    private final ArrayBuffer<ProverNodes<D>> changedNodesBufferToCheck;
    private final byte[] PositiveInfinityKey;
    private final byte[] NegativeInfinityKey;
    private final BytesEncoder encoder;
    private final byte LeafInPackagedProof;
    private final byte LabelInPackagedProof;
    private final byte EndOfTreeInPackagedProof;
    private volatile boolean bitmap$0;

    public static <D extends byte[], HF extends CryptographicHash<D>> Blake2b256$ $lessinit$greater$default$7(byte[] byArray, byte[] byArray2, int n, Option<Object> option, Option<Object> option2, Option<Object> option3) {
        return BatchAVLVerifier$.MODULE$.$lessinit$greater$default$7(byArray, byArray2, n, option, option2, option3);
    }

    public static <D extends byte[], HF extends CryptographicHash<D>> Option<Object> $lessinit$greater$default$6() {
        return BatchAVLVerifier$.MODULE$.$lessinit$greater$default$6();
    }

    public static <D extends byte[], HF extends CryptographicHash<D>> Option<Object> $lessinit$greater$default$5() {
        return BatchAVLVerifier$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public void onNodeVisit(Node<D> n, Operation operation, boolean isRotate) {
        AuthenticatedTreeOps.onNodeVisit$(this, n, operation, isRotate);
    }

    @Override
    public boolean onNodeVisit$default$3() {
        return AuthenticatedTreeOps.onNodeVisit$default$3$(this);
    }

    @Override
    public byte[] digest(Node<D> rootNode) {
        return AuthenticatedTreeOps.digest$(this, rootNode);
    }

    @Override
    public Try<Tuple2<Node<D>, Option<byte[]>>> returnResultOfOneOperation(Operation operation, Node<D> rootNode) {
        return AuthenticatedTreeOps.returnResultOfOneOperation$(this, operation, rootNode);
    }

    @Override
    public String arrayToString(byte[] a) {
        return ToStringHelper.arrayToString$(this, a);
    }

    @Override
    public ArrayBuffer<ProverNodes<D>> changedNodesBuffer() {
        return this.changedNodesBuffer;
    }

    @Override
    public ArrayBuffer<ProverNodes<D>> changedNodesBufferToCheck() {
        return this.changedNodesBufferToCheck;
    }

    @Override
    public byte[] PositiveInfinityKey() {
        return this.PositiveInfinityKey;
    }

    @Override
    public byte[] NegativeInfinityKey() {
        return this.NegativeInfinityKey;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$changedNodesBuffer_$eq(ArrayBuffer<ProverNodes<D>> x$1) {
        this.changedNodesBuffer = x$1;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$changedNodesBufferToCheck_$eq(ArrayBuffer<ProverNodes<D>> x$1) {
        this.changedNodesBufferToCheck = x$1;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$PositiveInfinityKey_$eq(byte[] x$1) {
        this.PositiveInfinityKey = x$1;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$NegativeInfinityKey_$eq(byte[] x$1) {
        this.NegativeInfinityKey = x$1;
    }

    @Override
    public BytesEncoder encoder() {
        return this.encoder;
    }

    @Override
    public void scorex$util$ScorexEncoding$_setter_$encoder_$eq(BytesEncoder x$1) {
        this.encoder = x$1;
    }

    @Override
    public byte LeafInPackagedProof() {
        return this.LeafInPackagedProof;
    }

    @Override
    public byte LabelInPackagedProof() {
        return this.LabelInPackagedProof;
    }

    @Override
    public byte EndOfTreeInPackagedProof() {
        return this.EndOfTreeInPackagedProof;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LeafInPackagedProof_$eq(byte x$1) {
        this.LeafInPackagedProof = x$1;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LabelInPackagedProof_$eq(byte x$1) {
        this.LabelInPackagedProof = x$1;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$EndOfTreeInPackagedProof_$eq(byte x$1) {
        this.EndOfTreeInPackagedProof = x$1;
    }

    @Override
    public int keyLength() {
        return this.keyLength;
    }

    @Override
    public Option<Object> valueLengthOpt() {
        return this.valueLengthOpt;
    }

    public void logError(Throwable t) {
        t.printStackTrace();
    }

    @Override
    public boolean collectChangedNodes() {
        return this.collectChangedNodes;
    }

    public int labelLength() {
        return this.labelLength;
    }

    public Option<byte[]> digest() {
        return this.topNode().map((Function1<VerifierNodes, byte[]> & Serializable & scala.Serializable)x$1 -> this.digest((Node)x$1));
    }

    private int directionsIndex() {
        return this.directionsIndex;
    }

    private void directionsIndex_$eq(int x$1) {
        this.directionsIndex = x$1;
    }

    private int lastRightStep() {
        return this.lastRightStep;
    }

    private void lastRightStep_$eq(int x$1) {
        this.lastRightStep = x$1;
    }

    private int replayIndex() {
        return this.replayIndex;
    }

    private void replayIndex_$eq(int x$1) {
        this.replayIndex = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean nextDirectionIsLeft(byte[] key, InternalNode<D> r) {
        void var3_3;
        boolean bl;
        if ((byte)(this.proof[this.directionsIndex() >> 3] & (byte)(1 << (this.directionsIndex() & 7))) != 0) {
            bl = true;
        } else {
            this.lastRightStep_$eq(this.directionsIndex());
            bl = false;
        }
        boolean ret = bl;
        this.directionsIndex_$eq(this.directionsIndex() + 1);
        return (boolean)var3_3;
    }

    @Override
    public boolean keyMatchesLeaf(byte[] key, Leaf<D> r) {
        boolean bl;
        int c = ByteArray$.MODULE$.compare(key, r.key());
        Predef$.MODULE$.require(c >= 0);
        if (c == 0) {
            bl = true;
        } else {
            Predef$.MODULE$.require(ByteArray$.MODULE$.compare(key, r.nextLeafKey()) < 0);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int replayComparison() {
        void var1_1;
        int ret = this.replayIndex() == this.lastRightStep() ? 0 : ((byte)(this.proof[this.replayIndex() >> 3] & (byte)(1 << (this.replayIndex() & 7))) == 0 && this.replayIndex() < this.lastRightStep() ? 1 : -1);
        this.replayIndex_$eq(this.replayIndex() + 1);
        return (int)var1_1;
    }

    @Override
    public InternalVerifierNode<D> addNode(Leaf<D> r, byte[] key, byte[] v) {
        byte[] n = r.nextLeafKey();
        byte[] x$1 = key;
        byte[] x$2 = r.getNew$default$1();
        byte[] x$3 = r.getNew$default$2();
        return new InternalVerifierNode<D>(r.getNew(x$2, x$3, x$1), new VerifierLeaf(key, v, n, this.hf), BoxesRunTime.unboxToByte(package$Balance$.MODULE$.$at$at(BoxesRunTime.boxToByte((byte)0), package$Tagger$.MODULE$.baseRaw())), this.hf);
    }

    @Override
    public int rootNodeHeight() {
        return this.rootNodeHeight;
    }

    @Override
    public void rootNodeHeight_$eq(int x$1) {
        this.rootNodeHeight = x$1;
    }

    private Option<VerifierNodes<D>> reconstructedTree$lzycompute() {
        BatchAVLVerifier batchAVLVerifier = this;
        synchronized (batchAVLVerifier) {
            if (!this.bitmap$0) {
                this.reconstructedTree = (Option)Try$.MODULE$.apply((Function0<Some> & Serializable & scala.Serializable)() -> {
                    int n;
                    Predef$.MODULE$.require(this.labelLength() > 0);
                    Predef$.MODULE$.require(this.keyLength() > 0);
                    this.valueLengthOpt().foreach((JFunction1$mcVI$sp & scala.Serializable)vl -> Predef$.MODULE$.require(vl >= 0));
                    Predef$.MODULE$.require($this.startingDigest.length == this.labelLength() + 1);
                    this.rootNodeHeight_$eq(BoxesRunTime.unboxToByte(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.startingDigest)).last()) & 0xFF);
                    if ($this.maxNumOperations.isDefined()) {
                        int logNumOps = 0;
                        int temp = 1;
                        int realNumOperations = BoxesRunTime.unboxToInt($this.maxNumOperations.getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> 0));
                        while (temp < realNumOperations) {
                            temp *= 2;
                            ++logNumOps;
                        }
                        temp = 1 + package$.MODULE$.max(this.rootNodeHeight(), logNumOps);
                        int hnew = temp + temp / 2;
                        int realMaxDeletes = BoxesRunTime.unboxToInt($this.maxDeletes.getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> realNumOperations));
                        n = (realNumOperations + realMaxDeletes) * (2 * this.rootNodeHeight() + 1) + realMaxDeletes * hnew + 1;
                    } else {
                        n = 0;
                    }
                    int maxNodes = n;
                    int numNodes = 0;
                    List<?> s = List$.MODULE$.empty();
                    IntRef i = IntRef.create(0);
                    Option previousLeaf = None$.MODULE$;
                    while ($this.proof[i.elem] != this.EndOfTreeInPackagedProof()) {
                        BoxedUnit boxedUnit;
                        byte n2 = $this.proof[i.elem];
                        ++i.elem;
                        Predef$.MODULE$.require($this.maxNumOperations.isEmpty() || ++numNodes <= maxNodes, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Proof too long");
                        byte by = n2;
                        if (this.LabelInPackagedProof() == by) {
                            byte[] label = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.proof)).slice(i.elem, i.elem + this.labelLength());
                            i.elem += this.labelLength();
                            LabelOnlyNode<byte[]> labelOnlyNode = new LabelOnlyNode<byte[]>(label);
                            s = s.$plus$colon(labelOnlyNode, List$.MODULE$.canBuildFrom());
                            previousLeaf = None$.MODULE$;
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (this.LeafInPackagedProof() == by) {
                            VerifierLeaf leaf;
                            byte[] byArray;
                            if (previousLeaf.nonEmpty()) {
                                byArray = (byte[])package$ADKey$.MODULE$.$at$at(((Leaf)((Option)previousLeaf).get()).nextLeafKey(), package$Tagger$.MODULE$.baseTagged());
                            } else {
                                int start = i.elem;
                                i.elem += this.keyLength();
                                byArray = (byte[])package$ADKey$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.proof)).slice(start, i.elem), package$Tagger$.MODULE$.baseRaw());
                            }
                            byte[] key = byArray;
                            byte[] nextLeafKey = (byte[])package$ADKey$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.proof)).slice(i.elem, i.elem + this.keyLength()), package$Tagger$.MODULE$.baseRaw());
                            i.elem += this.keyLength();
                            int valueLength = BoxesRunTime.unboxToInt(this.valueLengthOpt().getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> {
                                void var2_2;
                                int vl = Ints.fromByteArray((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.proof)).slice(i$1.elem, i$1.elem + 4));
                                i$1.elem += 4;
                                return (int)var2_2;
                            }));
                            byte[] value = (byte[])package$ADValue$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.proof)).slice(i.elem, i.elem + valueLength), package$Tagger$.MODULE$.baseRaw());
                            i.elem += valueLength;
                            VerifierLeaf verifierLeaf = leaf = new VerifierLeaf(key, value, nextLeafKey, $this.hf);
                            s = s.$plus$colon(verifierLeaf, List$.MODULE$.canBuildFrom());
                            previousLeaf = new Some(leaf);
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        VerifierNodes right = (VerifierNodes)s.head();
                        s = (List)s.tail();
                        VerifierNodes left = (VerifierNodes)s.head();
                        s = (List)s.tail();
                        InternalVerifierNode internalVerifierNode = new InternalVerifierNode(left, right, BoxesRunTime.unboxToByte(package$Balance$.MODULE$.$at$at(BoxesRunTime.boxToByte(n2), package$Tagger$.MODULE$.baseRaw())), $this.hf);
                        s = s.$plus$colon(internalVerifierNode, List$.MODULE$.canBuildFrom());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Predef$.MODULE$.require(s.size() == 1);
                    VerifierNodes root = (VerifierNodes)s.head();
                    Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.startingDigest)).startsWith(Predef$.MODULE$.wrapByteArray((byte[])root.label())));
                    this.directionsIndex_$eq((i.elem + 1) * 8);
                    return new Some<VerifierNodes>(root);
                }).recoverWith(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BatchAVLVerifier $outer;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        this.$outer.logError(A1);
                        Failure<T> failure = new Failure<T>(A1);
                        return (B1)failure;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0<None$> & Serializable & scala.Serializable)() -> None$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.reconstructedTree;
    }

    private Option<VerifierNodes<D>> reconstructedTree() {
        return !this.bitmap$0 ? this.reconstructedTree$lzycompute() : this.reconstructedTree;
    }

    private Option<VerifierNodes<D>> topNode() {
        return this.topNode;
    }

    private void topNode_$eq(Option<VerifierNodes<D>> x$1) {
        this.topNode = x$1;
    }

    public Try<Option<byte[]>> performOneOperation(Operation operation) {
        return Try$.MODULE$.apply((Function0<Option> & Serializable & scala.Serializable)() -> {
            this.replayIndex_$eq(this.directionsIndex());
            Try operationResult = this.returnResultOfOneOperation(operation, this.topNode().get());
            this.topNode_$eq((Option)operationResult.map((Function1<Tuple2, Some> & Serializable & scala.Serializable)s -> new Some<VerifierNodes>((VerifierNodes)s._1())).getOrElse((Function0<None$> & Serializable & scala.Serializable)() -> None$.MODULE$));
            return operationResult.get()._2();
        });
    }

    public String toString() {
        String string;
        Option<VerifierNodes<D>> option = this.topNode();
        if (None$.MODULE$.equals(option)) {
            string = "None";
        } else if (option instanceof Some) {
            Some some = (Some)option;
            VerifierNodes t = (VerifierNodes)some.value();
            string = this.stringTreeHelper$1(t, 0);
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public Option<Seq<VerifierNodes<D>>> extractNodes(Function1<VerifierNodes<D>, Object> extractor) {
        return this.topNode().map((Function1<VerifierNodes, Seq> & Serializable & scala.Serializable)t -> BatchAVLVerifier.treeTraverser$1(t, Nil$.MODULE$, extractor));
    }

    public Option<VerifierNodes<D>> extractFirstNode(Function1<VerifierNodes<D>, Object> extractor) {
        return this.topNode().flatMap((Function1<VerifierNodes, Option> & Serializable & scala.Serializable)t -> BatchAVLVerifier.treeTraverser$2(t, extractor));
    }

    private final String stringTreeHelper$1(VerifierNodes rNode, int depth) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(0).append(((TraversableOnce)Seq$.MODULE$.fill(depth + 2, (Function0<String> & Serializable & scala.Serializable)() -> " ")).mkString());
        VerifierNodes verifierNodes = rNode;
        if (verifierNodes instanceof VerifierLeaf) {
            VerifierLeaf verifierLeaf = (VerifierLeaf)verifierNodes;
            string = new StringBuilder(47).append("At leaf label = ").append(this.arrayToString((byte[])verifierLeaf.label())).append(" key = ").append(this.arrayToString(verifierLeaf.key())).append(" nextLeafKey = ").append(this.arrayToString(verifierLeaf.nextLeafKey())).append("value = ").append(verifierLeaf.value()).append("\n").toString();
        } else if (verifierNodes instanceof InternalVerifierNode) {
            InternalVerifierNode internalVerifierNode = (InternalVerifierNode)verifierNodes;
            string = new StringBuilder(34).append("Internal node label = ").append(this.arrayToString((byte[])internalVerifierNode.label())).append(" balance = ").append(internalVerifierNode.balance()).append("\n").append(this.stringTreeHelper$1((VerifierNodes)internalVerifierNode.left(), depth + 1)).append(this.stringTreeHelper$1((VerifierNodes)internalVerifierNode.right(), depth + 1)).toString();
        } else if (verifierNodes instanceof LabelOnlyNode) {
            LabelOnlyNode labelOnlyNode = (LabelOnlyNode)verifierNodes;
            string = new StringBuilder(25).append("Label-only node label = ").append(this.arrayToString((byte[])labelOnlyNode.label())).append("\n").toString();
        } else {
            throw new MatchError(verifierNodes);
        }
        return stringBuilder.append((Object)string).toString();
    }

    private static final Seq treeTraverser$1(VerifierNodes rNode, Seq collected, Function1 extractor$1) {
        Seq seq;
        VerifierNodes verifierNodes = rNode;
        if (verifierNodes instanceof VerifierLeaf) {
            Seq seq2;
            VerifierLeaf verifierLeaf = (VerifierLeaf)verifierNodes;
            if (BoxesRunTime.unboxToBoolean(extractor$1.apply(verifierLeaf))) {
                VerifierLeaf verifierLeaf2 = verifierLeaf;
                seq2 = collected.$plus$colon(verifierLeaf2, Seq$.MODULE$.canBuildFrom());
            } else {
                seq2 = collected;
            }
            seq = seq2;
        } else if (verifierNodes instanceof LabelOnlyNode) {
            Seq seq3;
            LabelOnlyNode labelOnlyNode = (LabelOnlyNode)verifierNodes;
            if (BoxesRunTime.unboxToBoolean(extractor$1.apply(labelOnlyNode))) {
                LabelOnlyNode labelOnlyNode2 = labelOnlyNode;
                seq3 = collected.$plus$colon(labelOnlyNode2, Seq$.MODULE$.canBuildFrom());
            } else {
                seq3 = collected;
            }
            seq = seq3;
        } else if (verifierNodes instanceof InternalVerifierNode) {
            InternalVerifierNode internalVerifierNode = (InternalVerifierNode)verifierNodes;
            seq = ((TraversableLike)collected.$plus$plus(BatchAVLVerifier.treeTraverser$1((VerifierNodes)internalVerifierNode.right(), Nil$.MODULE$, extractor$1), Seq$.MODULE$.canBuildFrom())).$plus$plus(BatchAVLVerifier.treeTraverser$1((VerifierNodes)internalVerifierNode.left(), Nil$.MODULE$, extractor$1), Seq$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError(verifierNodes);
        }
        return seq;
    }

    private static final Option treeTraverser$2(VerifierNodes rNode, Function1 extractor$2) {
        Option<VerifierNodes<Object>> option;
        VerifierNodes verifierNodes = rNode;
        if (verifierNodes instanceof VerifierLeaf) {
            VerifierLeaf verifierLeaf = (VerifierLeaf)verifierNodes;
            option = new Some<VerifierLeaf>(verifierLeaf).filter(extractor$2);
        } else if (verifierNodes instanceof LabelOnlyNode) {
            LabelOnlyNode labelOnlyNode = (LabelOnlyNode)verifierNodes;
            option = new Some<LabelOnlyNode>(labelOnlyNode).filter(extractor$2);
        } else if (verifierNodes instanceof InternalVerifierNode) {
            InternalVerifierNode internalVerifierNode = (InternalVerifierNode)verifierNodes;
            option = BatchAVLVerifier.treeTraverser$2((VerifierNodes)internalVerifierNode.left(), extractor$2).orElse((Function0<Option> & Serializable & scala.Serializable)() -> BatchAVLVerifier.treeTraverser$2((VerifierNodes)internalVerifierNode.right(), extractor$2));
        } else {
            throw new MatchError(verifierNodes);
        }
        return option;
    }

    public BatchAVLVerifier(byte[] startingDigest, byte[] proof, int keyLength, Option<Object> valueLengthOpt, Option<Object> maxNumOperations, Option<Object> maxDeletes, HF hf) {
        this.startingDigest = startingDigest;
        this.proof = proof;
        this.keyLength = keyLength;
        this.valueLengthOpt = valueLengthOpt;
        this.maxNumOperations = maxNumOperations;
        this.maxDeletes = maxDeletes;
        this.hf = hf;
        BatchProofConstants.$init$(this);
        ScorexEncoding.$init$(this);
        ToStringHelper.$init$(this);
        AuthenticatedTreeOps.$init$(this);
        this.collectChangedNodes = false;
        this.labelLength = hf.DigestSize();
        this.directionsIndex = 0;
        this.lastRightStep = 0;
        this.replayIndex = 0;
        this.rootNodeHeight = 0;
        this.topNode = this.reconstructedTree();
    }
}

