/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.secrets;

import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;
import org.ergoplatform.wallet.Constants$;
import org.ergoplatform.wallet.crypto.HmacSHA512$;
import org.ergoplatform.wallet.secrets.DerivationPath;
import org.ergoplatform.wallet.secrets.DerivationPath$;
import org.ergoplatform.wallet.secrets.ExtendedPublicKey;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey;
import org.ergoplatform.wallet.secrets.Index$;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import sigmastate.interpreter.CryptoConstants$;

public final class ExtendedSecretKey$ {
    public static ExtendedSecretKey$ MODULE$;

    static {
        new ExtendedSecretKey$();
    }

    public ExtendedSecretKey deriveChildSecretKey(ExtendedSecretKey parentKey, int idx) {
        BigInteger childKey;
        byte[] childChainCode;
        while (true) {
            byte[] byArray;
            if (Index$.MODULE$.isHardened(idx)) {
                byte by = 0;
                byArray = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(parentKey.keyBytes())).$plus$colon(BoxesRunTime.boxToByte(by), ClassTag$.MODULE$.Byte());
            } else {
                byArray = parentKey.privateInput().publicImage().value().getEncoded(true);
            }
            byte[] keyCoded = byArray;
            Tuple2<byte[], byte[]> tuple2 = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(HmacSHA512$.MODULE$.hash(parentKey.chainCode(), (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(keyCoded)).$plus$plus(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(Index$.MODULE$.serializeIndex(idx))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))))).splitAt(Constants$.MODULE$.SecretKeyLength());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            byte[] childKeyProto = tuple2._1();
            byte[] childChainCode2 = tuple2._2();
            Tuple2<byte[], byte[]> tuple22 = new Tuple2<byte[], byte[]>(childKeyProto, childChainCode2);
            Tuple2<byte[], byte[]> tuple23 = tuple22;
            byte[] childKeyProto2 = tuple23._1();
            childChainCode = tuple23._2();
            BigInteger childKeyProtoDecoded = BigIntegers.fromUnsignedByteArray(childKeyProto2);
            childKey = childKeyProtoDecoded.add(BigIntegers.fromUnsignedByteArray(parentKey.keyBytes())).mod(CryptoConstants$.MODULE$.groupOrder());
            if (childKeyProtoDecoded.compareTo(CryptoConstants$.MODULE$.groupOrder()) < 0 && !childKey.equals(BigInteger.ZERO)) break;
            ++idx;
        }
        return new ExtendedSecretKey(BigIntegers.asUnsignedByteArray(childKey), childChainCode, parentKey.path().extended(idx));
    }

    public ExtendedPublicKey deriveChildPublicKey(ExtendedSecretKey parentKey, int idx) {
        ExtendedSecretKey derivedSecret = this.deriveChildSecretKey(parentKey, idx);
        byte[] derivedPk = derivedSecret.privateInput().publicImage().value().getEncoded(true);
        boolean x$1 = true;
        Seq<Object> x$2 = derivedSecret.path().copy$default$1();
        DerivationPath derivedPath = derivedSecret.path().copy(x$2, x$1);
        return new ExtendedPublicKey(derivedPk, derivedSecret.chainCode(), derivedPath);
    }

    public ExtendedSecretKey deriveMasterKey(byte[] seed) {
        Tuple2<byte[], byte[]> tuple2 = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(HmacSHA512$.MODULE$.hash(Constants$.MODULE$.BitcoinSeed(), seed))).splitAt(Constants$.MODULE$.SecretKeyLength());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte[] masterKey = tuple2._1();
        byte[] chainCode = tuple2._2();
        Tuple2<byte[], byte[]> tuple22 = new Tuple2<byte[], byte[]>(masterKey, chainCode);
        Tuple2<byte[], byte[]> tuple23 = tuple22;
        byte[] masterKey2 = tuple23._1();
        byte[] chainCode2 = tuple23._2();
        return new ExtendedSecretKey(masterKey2, chainCode2, DerivationPath$.MODULE$.MasterPath());
    }

    private ExtendedSecretKey$() {
        MODULE$ = this;
    }
}

