/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.restapi.client.MerkleProof;

@Schema(description="Proof that a block corresponding to given header without PoW contains some transactions")
public class ProofOfUpcomingTransactions {
    @SerializedName(value="msgPreimage")
    private String msgPreimage = null;
    @SerializedName(value="txProofs")
    private List<MerkleProof> txProofs = new ArrayList<MerkleProof>();

    public ProofOfUpcomingTransactions msgPreimage(String string) {
        this.msgPreimage = string;
        return this;
    }

    @Schema(example="0112e03c6d39d32509855be7cee9b62ff921f7a0cf6883e232474bd5b54d816dd056f846980d34c3b23098bdcf41222f8cdee5219224aa67750055926c3a2310a483accc4f9153e7a760615ea972ac67911cff111f8c17f563d6147205f58f85133ae695d1d4157e4aecdbbb29952cfa42b75129db55bddfce3bc53b8fd5b5465f10d8be8ddda62ed3b86afb0497ff2d381ed884bdae5287d20667def224a28d2b6e3ebfc78709780702c70bd8df0e000000", required=true, description="Base16-encoded serialized header without Proof-of-Work")
    public String getMsgPreimage() {
        return this.msgPreimage;
    }

    public void setMsgPreimage(String string) {
        this.msgPreimage = string;
    }

    public ProofOfUpcomingTransactions txProofs(List<MerkleProof> list) {
        this.txProofs = list;
        return this;
    }

    public ProofOfUpcomingTransactions addTxProofsItem(MerkleProof merkleProof) {
        this.txProofs.add(merkleProof);
        return this;
    }

    @Schema(required=true, description="Merkle proofs of transactions included into blocks (not necessarily all the block transactions)")
    public List<MerkleProof> getTxProofs() {
        return this.txProofs;
    }

    public void setTxProofs(List<MerkleProof> list) {
        this.txProofs = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProofOfUpcomingTransactions proofOfUpcomingTransactions = (ProofOfUpcomingTransactions)object;
        return Objects.equals(this.msgPreimage, proofOfUpcomingTransactions.msgPreimage) && Objects.equals(this.txProofs, proofOfUpcomingTransactions.txProofs);
    }

    public int hashCode() {
        return Objects.hash(this.msgPreimage, this.txProofs);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class ProofOfUpcomingTransactions {\n");
        stringBuilder.append("    msgPreimage: ").append(this.toIndentedString(this.msgPreimage)).append("\n");
        stringBuilder.append("    txProofs: ").append(this.toIndentedString(this.txProofs)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

