/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.explorer.client.model.DataInputInfo;
import org.ergoplatform.explorer.client.model.InputInfo;
import org.ergoplatform.explorer.client.model.OutputInfo;

public class TransactionInfo {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="blockId")
    private String blockId = null;
    @SerializedName(value="inclusionHeight")
    private Integer inclusionHeight = null;
    @SerializedName(value="timestamp")
    private Long timestamp = null;
    @SerializedName(value="index")
    private Integer index = null;
    @SerializedName(value="numConfirmations")
    private Integer numConfirmations = null;
    @SerializedName(value="inputs")
    private List<InputInfo> inputs = null;
    @SerializedName(value="dataInputs")
    private List<DataInputInfo> dataInputs = null;
    @SerializedName(value="outputs")
    private List<OutputInfo> outputs = null;
    @SerializedName(value="size")
    private Integer size = null;

    public TransactionInfo id(String string) {
        this.id = string;
        return this;
    }

    @Schema(required=true, description="Transaction ID")
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public TransactionInfo blockId(String string) {
        this.blockId = string;
        return this;
    }

    @Schema(required=true, description="ID of the corresponding header")
    public String getBlockId() {
        return this.blockId;
    }

    public void setBlockId(String string) {
        this.blockId = string;
    }

    public TransactionInfo inclusionHeight(Integer n) {
        this.inclusionHeight = n;
        return this;
    }

    @Schema(required=true, description="Height of the block the transaction was included in")
    public Integer getInclusionHeight() {
        return this.inclusionHeight;
    }

    public void setInclusionHeight(Integer n) {
        this.inclusionHeight = n;
    }

    public TransactionInfo timestamp(Long l) {
        this.timestamp = l;
        return this;
    }

    @Schema(required=true, description="Timestamp the transaction got into the network")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long l) {
        this.timestamp = l;
    }

    public TransactionInfo index(Integer n) {
        this.index = n;
        return this;
    }

    @Schema(required=true, description="Index of a transaction inside a block")
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer n) {
        this.index = n;
    }

    public TransactionInfo numConfirmations(Integer n) {
        this.numConfirmations = n;
        return this;
    }

    @Schema(required=true, description="Number of transaction confirmations")
    public Integer getNumConfirmations() {
        return this.numConfirmations;
    }

    public void setNumConfirmations(Integer n) {
        this.numConfirmations = n;
    }

    public TransactionInfo inputs(List<InputInfo> list) {
        this.inputs = list;
        return this;
    }

    public TransactionInfo addInputsItem(InputInfo inputInfo) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<InputInfo>();
        }
        this.inputs.add(inputInfo);
        return this;
    }

    @Schema(description="")
    public List<InputInfo> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<InputInfo> list) {
        this.inputs = list;
    }

    public TransactionInfo dataInputs(List<DataInputInfo> list) {
        this.dataInputs = list;
        return this;
    }

    public TransactionInfo addDataInputsItem(DataInputInfo dataInputInfo) {
        if (this.dataInputs == null) {
            this.dataInputs = new ArrayList<DataInputInfo>();
        }
        this.dataInputs.add(dataInputInfo);
        return this;
    }

    @Schema(description="")
    public List<DataInputInfo> getDataInputs() {
        return this.dataInputs;
    }

    public void setDataInputs(List<DataInputInfo> list) {
        this.dataInputs = list;
    }

    public TransactionInfo outputs(List<OutputInfo> list) {
        this.outputs = list;
        return this;
    }

    public TransactionInfo addOutputsItem(OutputInfo outputInfo) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<OutputInfo>();
        }
        this.outputs.add(outputInfo);
        return this;
    }

    @Schema(description="")
    public List<OutputInfo> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<OutputInfo> list) {
        this.outputs = list;
    }

    public TransactionInfo size(Integer n) {
        this.size = n;
        return this;
    }

    @Schema(required=true, description="Transaction size in bytes")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer n) {
        this.size = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TransactionInfo transactionInfo = (TransactionInfo)object;
        return Objects.equals(this.id, transactionInfo.id) && Objects.equals(this.blockId, transactionInfo.blockId) && Objects.equals(this.inclusionHeight, transactionInfo.inclusionHeight) && Objects.equals(this.timestamp, transactionInfo.timestamp) && Objects.equals(this.index, transactionInfo.index) && Objects.equals(this.numConfirmations, transactionInfo.numConfirmations) && Objects.equals(this.inputs, transactionInfo.inputs) && Objects.equals(this.dataInputs, transactionInfo.dataInputs) && Objects.equals(this.outputs, transactionInfo.outputs) && Objects.equals(this.size, transactionInfo.size);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.blockId, this.inclusionHeight, this.timestamp, this.index, this.numConfirmations, this.inputs, this.dataInputs, this.outputs, this.size);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class TransactionInfo {\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    blockId: ").append(this.toIndentedString(this.blockId)).append("\n");
        stringBuilder.append("    inclusionHeight: ").append(this.toIndentedString(this.inclusionHeight)).append("\n");
        stringBuilder.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        stringBuilder.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        stringBuilder.append("    numConfirmations: ").append(this.toIndentedString(this.numConfirmations)).append("\n");
        stringBuilder.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        stringBuilder.append("    dataInputs: ").append(this.toIndentedString(this.dataInputs)).append("\n");
        stringBuilder.append("    outputs: ").append(this.toIndentedString(this.outputs)).append("\n");
        stringBuilder.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

