/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ergoplatform.appkit.ErgoType;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.JavaHelpers;
import scala.NotImplementedError;
import scorex.util.encode.Base16;
import sigmastate.SType;
import sigmastate.Values;

public class ErgoTreeTemplate {
    private final Values.ErgoTree _tree;
    private final byte[] _templateBytes;

    private ErgoTreeTemplate(Values.ErgoTree ergoTree) {
        this._tree = ergoTree;
        this._templateBytes = JavaHelpers.ergoTreeTemplateBytes(this._tree);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ErgoTreeTemplate ergoTreeTemplate = (ErgoTreeTemplate)object;
        return Arrays.equals(this.getBytes(), ergoTreeTemplate.getBytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this._templateBytes);
    }

    public byte[] getBytes() {
        return this._templateBytes;
    }

    public String getEncodedBytes() {
        return Base16.encode(this.getBytes());
    }

    public int getParameterCount() {
        return this._tree.constants().length();
    }

    public List<ErgoType<?>> getParameterTypes() {
        Iso iso = Iso.JListToIndexedSeq(Iso.identityIso());
        List list = iso.from(this._tree.constants());
        return list.stream().map(constant -> Iso.isoErgoTypeToSType().from((SType)constant.tpe())).collect(Collectors.toList());
    }

    public Values.ErgoTree applyParameters(ErgoValue<?> ergoValue) {
        throw new NotImplementedError();
    }

    public static ErgoTreeTemplate fromErgoTree(Values.ErgoTree ergoTree) {
        return new ErgoTreeTemplate(ergoTree);
    }
}

