# coding: utf-8

"""
    IBM Watson Machine Learning REST API

    ## Authorization  ### IBM Watson Machine Learning Credentials  To start working with API one needs to generate an `access token` using the `username` and `password` available on the Service Credentials tab of the IBM Watson Machine Learning service instance or also available in the VCAP environment variable.  Example of the Service Credentials:  ```json {     \"url\": \"https://ibm-watson-ml.mybluemix.net\",     \"access_key\": \"ERY9vcBfE4sE+F4g8hcotF9L+j81WXWeZv\",     \"username\": \"c1ef4b80-2ee2-458e-ab92-e9ca97ec657d\",     \"password\": \"030528d4-5a3e-4d4c-9258-5d553513be6f\" } ```  Example of obtaining `access token` from Token Endpoint using HTTP Basic Auth (for details please refer to Token section below):  ` curl --basic --user username:password https://ibm-watson-ml.mybluemix.net/v3/identity/token `   ### Apache Spark Service Credentials  The IBM Watson Machine Learning co-operates with the Apache Spark as a Service to deploy pipeline models. For API methods requiring Apache Spark Service instance a custom header: `X-Spark-Service-Instance` with Service Credentials must be specified. The header value is a **base64 encoded** string with the Service Credentials JSON data.  [Example of API method requiring Apache Spark Service](https://console.ng.bluemix.net/docs/services/PredictiveModeling/index-gentopic1.html#pm_service_api_spark_batch)

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

#  (C) Copyright IBM Corp. 2021.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from pprint import pformat
from six import iteritems
import re


class MetaObjectMetadata(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, guid=None, href=None, created_at=None, modified_at=None, id=None, name=None, owner=None,
                 space_id=None, project_id=None):
        """
        MetaObjectMetadata - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'guid': 'str',
            'href': 'str',
            'created_at': 'datetime',
            'modified_at': 'datetime',
            'id': 'str',
            'name': 'str',
            'owner': 'str',
            'space_id': 'str',
            'project_id': 'str'
        }

        self.attribute_map = {
            'guid': 'guid',
            'href': 'href',
            'created_at': 'created_at',
            'modified_at': 'modified_at',
            'id': 'id',
            'name': 'name',
            'owner': 'owner',
            'space_id': 'space_id',
            'project_id': 'project_id'

        }

        self._guid = guid
        self._href = href
        self._created_at = created_at
        self._modified_at = modified_at

    @property
    def guid(self):
        """
        Gets the guid of this MetaObjectMetadata.


        :return: The guid of this MetaObjectMetadata.
        :rtype: str
        """
        return self._guid

    @guid.setter
    def guid(self, guid):
        """
        Sets the guid of this MetaObjectMetadata.


        :param guid: The guid of this MetaObjectMetadata.
        :type: str
        """

        self._guid = guid

    @property
    def href(self):
        """
        Gets the href of this MetaObjectMetadata.


        :return: The href of this MetaObjectMetadata.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this MetaObjectMetadata.


        :param href: The href of this MetaObjectMetadata.
        :type: str
        """

        self._href = href

    @property
    def created_at(self):
        """
        Gets the created_at of this MetaObjectMetadata.


        :return: The created_at of this MetaObjectMetadata.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this MetaObjectMetadata.


        :param created_at: The created_at of this MetaObjectMetadata.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def modified_at(self):
        """
        Gets the modified_at of this MetaObjectMetadata.


        :return: The modified_at of this MetaObjectMetadata.
        :rtype: datetime
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """
        Sets the modified_at of this MetaObjectMetadata.


        :param modified_at: The modified_at of this MetaObjectMetadata.
        :type: datetime
        """

        self._modified_at = modified_at

    @property
    def id(self):
        """
        Gets the id of this MetaObjectMetadata.


        :return: The id of this MetaObjectMetadata.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MetaObjectMetadata.


        :param id: The guid of this MetaObjectMetadata.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this MetaObjectMetadata.


        :return: The name of this MetaObjectMetadata.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this MetaObjectMetadata.


        :param name: The name of this MetaObjectMetadata.
        :type: str
        """

        self._name = name

    @property
    def owner(self):
        """
        Gets the owner of this MetaObjectMetadata.


        :return: The owner of this MetaObjectMetadata.
        :rtype: str
        """
        return self.owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this MetaObjectMetadata.


        :param owner: The owner of this MetaObjectMetadata.
        :type: str
        """

        self.owner = owner

    @property
    def space_id(self):
        """
        Gets the space_id of this MetaObjectMetadata.


        :return: The space_id of this MetaObjectMetadata.
        :rtype: str
        """
        return self.space_id

    @space_id.setter
    def space_id(self, space_id):
        """
        Sets the space_id of this MetaObjectMetadata.


        :param space_id: The space_id of this MetaObjectMetadata.
        :type: str
        """

        self.space_id = space_id

    @property
    def project_id(self):
        """
        Gets the project_id of this MetaObjectMetadata.


        :return: The project_id of this MetaObjectMetadata.
        :rtype: str
        """
        return self.project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this MetaObjectMetadata.


        :param project_id: The project_id of this MetaObjectMetadata.
        :type: str
        """
        self.project_id = project_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
