# AUTOGENERATED! DO NOT EDIT! File to edit: 01_modelAPI.ipynb (unless otherwise specified).

__all__ = ['mish', 'Mish', 'EmoModel', 'label2int', 'get_model', 'load_tokenizer', 'setup_tokenizer', 'print_emotion',
           'get_output', 'get_model_exp']

# Cell
# necessary evil
import torch
import torch.nn as nn
import torch.nn.functional as F
import os

# Cell
# from https://github.com/digantamisra98/Mish/blob/b5f006660ac0b4c46e2c6958ad0301d7f9c59651/Mish/Torch/mish.py
@torch.jit.script
def mish(input):
    return input * torch.tanh(F.softplus(input))

class Mish(nn.Module):
    def forward(self, input):
        return mish(input)

# Cell
class EmoModel(nn.Module):
    def __init__(self, base_model, n_classes, base_model_output_size=768, dropout=0.05):
        super().__init__()
        self.base_model = base_model

        self.classifier = nn.Sequential(
            nn.Dropout(dropout),
            nn.Linear(base_model_output_size, base_model_output_size),
            Mish(),
            nn.Dropout(dropout),
            nn.Linear(base_model_output_size, n_classes)
        )

        for layer in self.classifier:
            if isinstance(layer, nn.Linear):
                layer.weight.data.normal_(mean=0.0, std=0.02)
                if layer.bias is not None:
                    layer.bias.data.zero_()

    def forward(self, input_, *args):
        X, attention_mask = input_
        hidden_states = self.base_model(X, attention_mask=attention_mask)
        # customize here
        # use the <s> representation
        return self.classifier(hidden_states[0][:, 0, :])

# Cell
label2int = {
    "sadness": 0,
    "joy": 1,
    "love": 2,
    "anger": 3,
    "fear": 4,
    "surprise": 5
}

# Cell
def get_model(PATH=".pt", pretrained=True, inference_only=True, lr=0.0001, default_model=None):
    if PATH[-3:] != ".pt" and PATH[-4:] != ".pth":
        print("Unable to load pretrained model")
        return None

    # show warning message when it's inference only but lr has been changed
    if inference_only == True and lr != 0.0001:
        print("Warning: the loaded model is for inference only, so there's no optimizer for the changed learning rate")
    # model = EmoModel(AutoModelWithLMHead.from_pretrained("distilroberta-base").base_model, len(emotions))
    # emotions = ["sadness", "joy", "love", "anger", "fear", "surprise"], len(label2int) would work as well
    model = None
    if default_model is None:
        from transformers import AutoModelWithLMHead
        model = EmoModel(AutoModelWithLMHead.from_pretrained("distilroberta-base").base_model, 6)
    else:
        # set model to user-defined model
        model = default_model

    # if you want to train it from scratch
    if pretrained == False:
        return model

    checkpoint = torch.load(PATH)

    if inference_only:
        # model would not be subscriptable
        model.load_state_dict(checkpoint)
        model.eval()
    else:
        # lr: learning rate, adjustable
        from transformers import AdamW
        optimizer = AdamW(model.parameters(), lr=lr)
        model.load_state_dict(checkpoint['model_state_dict'])
        optimizer.load_state_dict(checkpoint['optimizer_state_dict'])
        model.train()

    return model

# Cell
# save the pretrained token
def load_tokenizer():
    from transformers import AutoTokenizer
    tokenizer = AutoTokenizer.from_pretrained('distilroberta-base')
    # -p, --parent, no error if it exists, make parent directory as necessary
    import os
    os.system("mkdir -p tokenizer")
    tokenizer.save_pretrained("tokenizer")

def setup_tokenizer():
    import os
    # if there's no previous file/record
    # should we check if there are missing files given that it's previously downloaded?
    if not os.path.isdir("tokenizer"):
        load_tokenizer()

    else: # content of previously download files is not complete
        checklist = ['merges.txt', 'special_tokens_map.json', 'tokenizer.json', 'tokenizer_config.json', 'vocab.json']
        # check existing files
        # existing_files = os.walk(os.path.join(os.getcwd(), "tokenizer"))
        existing_files = list(os.walk("tokenizer"))[0][2]
        # os.walk() won't messed up the order of the searched files,
        # so, we can just use "==" operator
        if existing_files != checklist:
            # clean the previously download ones
            os.system("rmdir -rf tokenizer")
            # and, re-download it
            load_tokenizer()

# Cell
def print_emotion(output, print_emo=True):
    # output = model.forward(input)
    import torch
    idx = torch.argmax(output, dim=1)
    from .model_api import label2int
    for key in label2int:
        if label2int[key] == idx:
            if print_emo == True:
                print("Emotion: %s" % key)
            break
    return key

# Cell
# mainly about not re-writing with torch.no_grad(), model.eval() again
def get_output(text, model, tokenizer=None, return_tensor=False, print_emo=False):
    # we should add try/Except error handling for "model" argument
    # , but i consider it to be ugly
    from .data_process import convert_text_to_tensor
    import torch
    with torch.no_grad():
        model.eval()
        # we have control flow in convert_text_to_tensor()
        out = model(convert_text_to_tensor(text, tokenizer))
    # put it right here to enable "print_emo" argument
    emo_label = print_emotion(out, print_emo=print_emo)
    if return_tensor == True:
        return out
    # else, return emotion label (a string)
    return emo_label


# Cell
def get_model_exp(PATH=".pt", pretrained=True, inference_only=True, lr=0.0001, custom_model=None, custom_optimizer=None):
    def valid_pth(P):
        # .pt
        # length >=3 and .pt: true
        # .pth
        # length >=4 and .pth: true
        N = len(P)
        if N >= 3 and PATH.endswith(".pt"):
            return True
        if N >= 4 and PATH.endswith(".pth"):
            return True
        return False
    # init globally inside this function
    model = None
    # if no customized model (user defined model) -> load default model arch.
    if custom_model is None:
        from transformers import AutoModelWithLMHead
        model = EmoModel(AutoModelWithLMHead.from_pretrained("distilroberta-base").base_model, 6)
    else:
        model = custom_model
    if not pretrained:
        if inference_only:
            model.eval()
        return model
    if not valid_pth(PATH):
        print("model path not valid, return None")
        return None
    if inference_only:
        model.load_state_dict(PATH)
        model.eval()
    else:
        # if it's customized model -> pretrained -> not inference only-> check if optimizer is None
        import torch
        checkpoint = torch.load(PATH)
        if custom_optimizer:
            optimizer = custom_optimizer
        else:
            from transformers import AdamW
            optimizer = AdamW(model.parameters(), lr=lr)
        model.load_state_dict(checkpoint['model_state_dict'])
        optimizer.load_state_dict(checkpoint['optimizer_state_dict'])
        model.train()
    return model