// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.filemanager', ['core', 'ajenti.filesystem']);

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('core').config(function($routeProvider) {
    $routeProvider.when('/view/filemanager', {
      templateUrl: '/filemanager:resources/partial/index.html',
      controller: 'FileManagerIndexController'
    });
    $routeProvider.when('/view/filemanager/properties/:path*', {
      templateUrl: '/filemanager:resources/partial/properties.html',
      controller: 'FileManagerPropertiesController'
    });
    return $routeProvider.when('/view/filemanager/:path*', {
      templateUrl: '/filemanager:resources/partial/index.html',
      controller: 'FileManagerIndexController'
    });
  });

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.filemanager').controller('FileManagerIndexController', function($scope, $routeParams, $location, $localStorage, $timeout, notify, filesystem, pageTitle, urlPrefix, tasks, messagebox, $upload, gettext) {
    var uploadCallback;
    pageTitle.set('path', $scope);
    $scope.loading = false;
    $scope.newDirectoryDialogVisible = false;
    $scope.newFileDialogVisible = false;
    $scope.clipboardVisible = false;
    $scope.load = function(path) {
      $scope.loading = true;
      return filesystem.list(path).then(function(data) {
        $scope.path = path;
        $scope.items = data.items;
        return $scope.parent = data.parent;
      })["catch"](function(data) {
        return notify.error(gettext('Could not load directory'), data.message);
      })["finally"](function() {
        return $scope.loading = false;
      });
    };
    $scope.refresh = function() {
      return $scope.load($scope.path);
    };
    $scope.$on('push:filesystem', function($event, msg) {
      if (msg === 'refresh') {
        return $scope.refresh();
      }
    });
    $scope.navigate = function(path) {
      return $location.path("" + urlPrefix + "/view/filemanager/" + path);
    };
    $scope.select = function(item) {
      if (item.isDir) {
        return $scope.navigate(item.path);
      } else {
        if ($scope.mode === 'open') {
          $scope.onSelect({
            item: item
          });
        }
        if ($scope.mode === 'save') {
          return $scope.name = item.name;
        }
      }
    };
    $scope.clearSelection = function() {
      var item, _i, _len, _ref, _results;
      _ref = $scope.items;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        _results.push(item.selected = false);
      }
      return _results;
    };
    if (!$localStorage.fileManagerClipboard) {
      $localStorage.fileManagerClipboard = [];
    }
    $scope.clipboard = $localStorage.fileManagerClipboard;
    $scope.showClipboard = function() {
      return $scope.clipboardVisible = true;
    };
    $scope.hideClipboard = function() {
      return $scope.clipboardVisible = false;
    };
    $scope.clearClipboard = function() {
      $scope.clipboard.length = 0;
      return $scope.hideClipboard();
    };
    $scope.doCut = function() {
      var item, _i, _len, _ref;
      _ref = $scope.items;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        if (item.selected) {
          $scope.clipboard.push({
            mode: 'move',
            item: item
          });
        }
      }
      return $scope.clearSelection();
    };
    $scope.doCopy = function() {
      var item, _i, _len, _ref;
      _ref = $scope.items;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        if (item.selected) {
          $scope.clipboard.push({
            mode: 'copy',
            item: item
          });
        }
      }
      return $scope.clearSelection();
    };
    $scope.doDelete = function() {
      return messagebox.show({
        text: gettext('Delete selected items?'),
        positive: gettext('Delete'),
        negative: gettext('Cancel')
      }).then(function() {
        var item, items;
        items = (function() {
          var _i, _len, _ref, _results;
          _ref = $scope.items;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            item = _ref[_i];
            if (item.selected) {
              _results.push(item);
            }
          }
          return _results;
        })();
        tasks.start('aj.plugins.filesystem.tasks.Delete', [], {
          items: items
        });
        return $scope.clearSelection();
      });
    };
    $scope.doPaste = function() {
      var items;
      items = angular.copy($scope.clipboard);
      return tasks.start('aj.plugins.filesystem.tasks.Transfer', [], {
        destination: $scope.path,
        items: items
      }).then(function() {
        return $scope.clearClipboard();
      });
    };
    $scope.showNewFileDialog = function() {
      $scope.newFileName = '';
      return $scope.newFileDialogVisible = true;
    };
    $scope.doCreateFile = function() {
      if (!$scope.newFileName) {
        return;
      }
      return filesystem.createFile($scope.path + '/' + $scope.newFileName).then(function() {
        $scope.refresh();
        return $scope.newFileDialogVisible = false;
      })["catch"](function(err) {
        return notify.error(gettext('Could not create file'), err.message);
      });
    };
    $scope.showNewDirectoryDialog = function() {
      $scope.newDirectoryName = '';
      return $scope.newDirectoryDialogVisible = true;
    };
    $scope.doCreateDirectory = function() {
      if (!$scope.newDirectoryName) {
        return;
      }
      return filesystem.createDirectory($scope.path + '/' + $scope.newDirectoryName).then(function() {
        $scope.refresh();
        return $scope.newDirectoryDialogVisible = false;
      })["catch"](function(err) {
        return notify.error(gettext('Could not create directory'), err.message);
      });
    };
    $scope.uploadFiles = [];
    $scope.uploadPending = [];
    $scope.showUploadDialog = function() {
      return $scope.uploadDialogVisible = true;
    };
    uploadCallback = function() {
      if ($scope.uploadPending.length > 0) {
        $scope.uploadCurrent = {
          file: $scope.uploadPending[0],
          name: $scope.uploadPending[0].name
        };
        $scope.uploadPending.remove($scope.uploadCurrent.file);
        return $upload.upload({
          url: "" + urlPrefix + "/api/filesystem/upload/" + $scope.path + "/" + $scope.uploadCurrent.name,
          file: $scope.uploadCurrent.file,
          fileName: $scope.uploadCurrent.name,
          fileFormDataName: 'upload'
        }).success(function() {
          notify.success(gettext('Uploaded'), $scope.uploadCurrent.name);
          $scope.refresh();
          return uploadCallback();
        }).xhr(function(xhr) {
          return $scope.uploadCurrent.cancel = function() {
            return xhr.abort();
          };
        }).progress(function(e) {
          $scope.uploadCurrent.length = e.total;
          return $scope.uploadCurrent.progress = e.loaded;
        }).error(function(e) {
          if ($scope.uploadCurrent) {
            notify.error(gettext('Upload failed'), $scope.uploadCurrent.name);
            return uploadCallback();
          } else {
            return notify.info(gettext('Upload cancelled'));
          }
        });
      } else {
        $scope.uploadDialogVisible = false;
        $scope.uploadPending = [];
        $scope.uploadRunning = false;
        return $scope.uploadCurrent = null;
      }
    };
    $scope.doUpload = function() {
      return $timeout(function() {
        $scope.uploadRunning = true;
        $scope.uploadPending = $scope.uploadFiles;
        $scope.uploadFiles = [];
        return uploadCallback();
      });
    };
    $scope.cancelUpload = function() {
      $scope.uploadDialogVisible = false;
      $scope.uploadFiles = [];
      $scope.uploadPending = [];
      $scope.uploadRunning = false;
      if ($scope.uploadCurrent) {
        $scope.uploadCurrent.cancel();
        return $scope.uploadCurrent = null;
      }
    };
    if ($routeParams.path) {
      return $scope.load($routeParams.path);
    } else {
      return $scope.navigate('/');
    }
  });

}).call(this);

// Generated by CoffeeScript 1.8.0
(function() {
  angular.module('ajenti.filemanager').controller('FileManagerPropertiesController', function($scope, $routeParams, $location, notify, filesystem, pageTitle, urlPrefix, gettext) {
    var modeBits;
    pageTitle.set('path', $scope);
    $scope.permissionsDialogVisible = false;
    modeBits = ['ax', 'aw', 'ar', 'gx', 'gw', 'gr', 'ux', 'uw', 'ur', 'sticky', 'setuid', 'setgid'];
    $scope.path = $routeParams.path;
    $scope.refresh = function() {
      return filesystem.stat($scope.path).then(function(info) {
        var i, _i, _ref, _results;
        $scope.info = info;
        $scope.mode = {};
        _results = [];
        for (i = _i = 0, _ref = modeBits.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
          _results.push($scope.mode[modeBits[i]] = !!($scope.info.mode & Math.pow(2, i)));
        }
        return _results;
      })["catch"](function(err) {
        return notify.error(gettext('Could not read file information'), err);
      });
    };
    $scope.hidePermissionsDialog = function() {
      return $scope.permissionsDialogVisible = false;
    };
    $scope.applyPermissions = function() {
      var i, mode, _i, _ref;
      $scope.hidePermissionsDialog();
      mode = 0;
      for (i = _i = 0, _ref = modeBits.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
        mode += $scope.mode[modeBits[i]] ? Math.pow(2, i) : 0;
      }
      return filesystem.chmod($scope.path, mode).then(function() {
        notify.info(gettext('File mode saved'));
        return $scope.refresh();
      });
    };
    return $scope.refresh();
  });

}).call(this);

