"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobDefinitionImageConfig = void 0;
const ecs = require("@aws-cdk/aws-ecs");
const iam = require("@aws-cdk/aws-iam");
/**
 * Batch Job Task Definition
 *
 * Defines a Batch Job Task Definition. The properties of this task definition mirrors
 * those of an {@link ecs.ContainerDefinition}. This class is a wrapper on that structure.
 */
class TaskDefinition {
    constructor(props) {
        this.executionRole = props.executionRole;
    }
    /**
     * Internal function to allow the Batch Job task defintion
     * to match the CDK requirements of an EC2 task definition.
     *
     * @internal
     */
    // tslint:disable-next-line: no-empty
    _linkContainer() { }
    /**
     * Retrieves the execution role for this task definition
     */
    obtainExecutionRole() {
        return this.executionRole;
    }
}
/**
 * The configuration for creating a batch container image.
 */
class JobDefinitionImageConfig {
    constructor(scope, container) {
        const config = this.bindImageConfig(scope, container);
        this.imageName = config.imageName;
    }
    bindImageConfig(scope, container) {
        return container.image.bind(scope, new ecs.ContainerDefinition(scope, 'Resource-Batch-Job-Container-Definition', {
            command: container.command,
            cpu: container.vcpus,
            image: container.image,
            environment: container.environment,
            linuxParameters: container.linuxParams,
            memoryLimitMiB: container.memoryLimitMiB,
            privileged: container.privileged,
            readonlyRootFilesystem: container.readOnly,
            gpuCount: container.gpuCount,
            user: container.user,
            taskDefinition: new TaskDefinition({
                executionRole: container.jobRole || new iam.LazyRole(scope, 'Resource-Batch-Task-Definition-Role', {
                    assumedBy: new iam.ServicePrincipal('batch.amazonaws.com'),
                }),
            }),
        }));
    }
}
exports.JobDefinitionImageConfig = JobDefinitionImageConfig;
//# sourceMappingURL=data:application/json;base64,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