# Generated by Django 3.0.7 on 2020-06-30 13:58

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import modelcluster.contrib.taggit
import modelcluster.fields
import taggit.managers
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.core.models
import wagtail.documents.blocks
import wagtail.images.blocks
import wagtail.search.index
import wagtail.snippets.blocks
import webspace.cms.amp.mixins
import webspace.cms.blocks.static.social_share
import webspace.cms.forms.abstract


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('taggit', '0003_taggeditem_add_unique_index'),
        ('wagtailcore', '0045_assign_unlock_grouppagepermission'),
        ('wagtailimages', '0022_uploadedimage'),
    ]

    operations = [
        migrations.CreateModel(
            name='Form',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('help_text', models.CharField(blank=True, default='', max_length=100, verbose_name='Nom du formulaire')),
                ('text', wagtail.core.fields.RichTextField(blank=True, default='', verbose_name='Texte avant le formulaire')),
                ('button_text', models.CharField(blank=True, default='Submit', max_length=250, verbose_name='Bouton text')),
                ('button_theme', models.CharField(blank=True, choices=[('primary-light', 'Primary Light'), ('primary-full', 'Primary Full'), ('secondary-light', 'Secondary Light'), ('secondary-full', 'Secondary Full'), ('tertiary-light', 'Tertiary Light'), ('tertiary-full', 'Tertiary Full')], default='primary-full', max_length=250, verbose_name='Bouton theme')),
                ('redirection_url', models.CharField(blank=True, default='', max_length=250, verbose_name='Url de redirection')),
                ('actions', wagtail.core.fields.StreamField([('email', wagtail.core.blocks.StructBlock([('email_receiver', wagtail.core.blocks.CharBlock(required=False))]))], blank=True)),
                ('redirection_page', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page', verbose_name='Page de redirection après un formulaire validé')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GenericPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('theme', models.CharField(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], default='space', help_text='Permet de changer le theme du header et du footer', max_length=100)),
                ('breadcrumb', models.BooleanField(default=True, help_text='Ajoute la page dans le sitemap et génère un schéma Breadcrumb', verbose_name='Public pour Google')),
                ('schemas', wagtail.core.fields.StreamField([('how_to', wagtail.core.blocks.StructBlock([('name', wagtail.core.blocks.CharBlock(required=True)), ('description', wagtail.core.blocks.CharBlock(required=True)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=True)), ('step', wagtail.core.blocks.StreamBlock([('step', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=True)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('name', wagtail.core.blocks.CharBlock(required=True)), ('url', wagtail.core.blocks.URLBlock(required=False))]))]))])), ('faq_page', wagtail.core.blocks.StructBlock([('questions', wagtail.core.blocks.StreamBlock([('questions', wagtail.core.blocks.StructBlock([('question', wagtail.core.blocks.CharBlock(required=True)), ('answer', wagtail.core.blocks.CharBlock(required=True))]))]))]))], blank=True)),
                ('body', wagtail.core.fields.StreamField([('svg', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('svg', wagtail.core.blocks.StructBlock([('file', wagtail.documents.blocks.DocumentChooserBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))]))])), ('image', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('image', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))]))])), ('text', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark'], required=False))])), ('align', wagtail.core.blocks.ChoiceBlock(choices=[(None, 'Unset'), ('left', 'Left'), ('center', 'Center'), ('right', 'Right'), ('justify', 'Justify')], required=False))])), ('cards', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('carousel', wagtail.core.blocks.BooleanBlock(required=False)), ('carousel_cta', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('cards', wagtail.core.blocks.StreamBlock([('custom', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark'], required=False))])), ('button', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(required=False)), ('page', wagtail.core.blocks.PageChooserBlock(required=False)), ('open_new_tab', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('type', wagtail.core.blocks.ChoiceBlock(choices=[('primary-light', 'Primary Light'), ('primary-full', 'Primary Full'), ('secondary-light', 'Secondary Light'), ('secondary-full', 'Secondary Full'), ('tertiary-light', 'Tertiary Light'), ('tertiary-full', 'Tertiary Full')]))])), ('icon', wagtail.core.blocks.StructBlock([('file', wagtail.documents.blocks.DocumentChooserBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('media', wagtail.core.blocks.StreamBlock([('svg', wagtail.core.blocks.StructBlock([('file', wagtail.documents.blocks.DocumentChooserBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('image', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))]))], max_num=1, required=False))]))], min_num=1))])), ('component_text', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('titles', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark'], required=False))])), ('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark'], required=False))])), ('reverse', wagtail.core.blocks.BooleanBlock(help_text="Permet de d'intervertir le component et la zone de texte", required=False)), ('section', wagtail.core.blocks.BooleanBlock(help_text='Permet de sectionner la zone de texte', required=False)), ('align', wagtail.core.blocks.ChoiceBlock(choices=[(None, 'Unset'), ('left', 'Left'), ('center', 'Center'), ('right', 'Right'), ('justify', 'Justify')], required=False)), ('component', wagtail.core.blocks.StreamBlock([('svg', wagtail.core.blocks.StructBlock([('file', wagtail.documents.blocks.DocumentChooserBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('image', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('embed', wagtail.core.blocks.StructBlock([('link', wagtail.core.blocks.URLBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('form', wagtail.core.blocks.StructBlock([('form', wagtail.snippets.blocks.SnippetChooserBlock('cms.Form', required=True))]))], max_num=1)), ('buttons', wagtail.core.blocks.StreamBlock([('button', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(required=False)), ('page', wagtail.core.blocks.PageChooserBlock(required=False)), ('open_new_tab', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('type', wagtail.core.blocks.ChoiceBlock(choices=[('primary-light', 'Primary Light'), ('primary-full', 'Primary Full'), ('secondary-light', 'Secondary Light'), ('secondary-full', 'Secondary Full'), ('tertiary-light', 'Tertiary Light'), ('tertiary-full', 'Tertiary Full')]))]))], max_num=2, required=False))])), ('grid_info', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('infos', wagtail.core.blocks.StreamBlock([('svg_info', wagtail.core.blocks.StructBlock([('file', wagtail.documents.blocks.DocumentChooserBlock(required=False)), ('title', wagtail.core.blocks.CharBlock()), ('text_hover', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark'], required=False))]))])), ('image_info', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('title', wagtail.core.blocks.CharBlock()), ('text_hover', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark'], required=False))]))]))], min_num=1))])), ('medias_line', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('medias', wagtail.core.blocks.StreamBlock([('svg_label', wagtail.core.blocks.StructBlock([('file', wagtail.documents.blocks.DocumentChooserBlock(required=False)), ('label', wagtail.core.blocks.CharBlock(required=False)), ('page', wagtail.core.blocks.PageChooserBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(required=False))])), ('image_label', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('label', wagtail.core.blocks.CharBlock(required=False)), ('page', wagtail.core.blocks.PageChooserBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(required=False))]))], min_num=1))])), ('timeline', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('items', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark'], required=False))]))], min_num=1))])), ('buttons', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('align', wagtail.core.blocks.ChoiceBlock(choices=[(None, 'Unset'), ('left', 'Left'), ('center', 'Center'), ('right', 'Right'), ('justify', 'Justify')], required=False)), ('buttons', wagtail.core.blocks.StreamBlock([('button', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(required=False)), ('page', wagtail.core.blocks.PageChooserBlock(required=False)), ('open_new_tab', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('type', wagtail.core.blocks.ChoiceBlock(choices=[('primary-light', 'Primary Light'), ('primary-full', 'Primary Full'), ('secondary-light', 'Secondary Light'), ('secondary-full', 'Secondary Full'), ('tertiary-light', 'Tertiary Light'), ('tertiary-full', 'Tertiary Full')]))]))], max_num=3))])), ('calendly', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('link', wagtail.core.blocks.URLBlock(required=False))])), ('articles', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('articles', wagtail.core.blocks.StreamBlock([('article', wagtail.core.blocks.PageChooserBlock(page_type=['cms.BlogPage'], required=False))], min_num=1))])), ('embed', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('embed', wagtail.core.blocks.StructBlock([('link', wagtail.core.blocks.URLBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))]))])), ('social_share', webspace.cms.blocks.static.social_share.SocialShare()), ('table', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('rows', wagtail.core.blocks.StreamBlock([('cells', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark'], required=False))])), ('svg', wagtail.core.blocks.StructBlock([('file', wagtail.documents.blocks.DocumentChooserBlock(required=False))])), ('image', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False))]))], min_num=1))], min_num=1))])), ('accordion', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('items', wagtail.core.blocks.StreamBlock([('classic', wagtail.core.blocks.StructBlock([('head', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark'], required=False))], label='Head')), ('content', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark'], required=False))], label='Head'))]))], min_num=1))])), ('numbers', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('items', wagtail.core.blocks.StreamBlock([('classic', wagtail.core.blocks.StructBlock([('number', wagtail.core.blocks.IntegerBlock(required=True)), ('unit', wagtail.core.blocks.CharBlock(help_text='unité de mesure', required=False)), ('content', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark'], required=False))], label='Content'))]))], min_num=1))])), ('form', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], max_num=1, required=False)), ('svg_bg_position', wagtail.core.blocks.ChoiceBlock(choices=[('top', 'Top'), ('center', 'Center'), ('bottom', 'Bottom'), ('left', 'Left'), ('right', 'Right')], required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('container', wagtail.core.blocks.ChoiceBlock(choices=[('regular', 'Regular'), ('content', 'Content (blog)'), ('full', 'Full (width 100%)')], required=False)), ('padding_top', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('padding_bottom', wagtail.core.blocks.BooleanBlock(default=True, required=False)), ('form', wagtail.core.blocks.StructBlock([('form', wagtail.snippets.blocks.SnippetChooserBlock('cms.Form', required=True))]))]))], blank=True)),
                ('feed_image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='SEO - Image')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='Menu',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('help_text', models.CharField(blank=True, default='', max_length=100)),
                ('title', models.CharField(max_length=100)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Navigation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('help_text', models.CharField(blank=True, default='', max_length=100)),
                ('footer', wagtail.core.fields.StreamField([('menu', wagtail.snippets.blocks.SnippetChooserBlock('cms.Menu', required=False))], blank=True)),
                ('header_menus', wagtail.core.fields.StreamField([('menu', wagtail.snippets.blocks.SnippetChooserBlock('cms.Menu', required=False))], blank=True)),
                ('header_buttons', wagtail.core.fields.StreamField([('button', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(required=False)), ('page', wagtail.core.blocks.PageChooserBlock(required=False)), ('open_new_tab', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('type', wagtail.core.blocks.ChoiceBlock(choices=[('primary-light', 'Primary Light'), ('primary-full', 'Primary Full'), ('secondary-light', 'Secondary Light'), ('secondary-full', 'Secondary Full'), ('tertiary-light', 'Tertiary Light'), ('tertiary-full', 'Tertiary Full')]))]))], blank=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BlogIndexPage',
            fields=[
                ('genericpage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cms.GenericPage')),
                ('bg_desktop', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], blank=True)),
                ('bg_mobile', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], blank=True)),
                ('h1', models.CharField(blank=True, default='', max_length=200)),
                ('first_text', wagtail.core.fields.RichTextField(blank=True, default='')),
            ],
            options={
                'abstract': False,
            },
            bases=(webspace.cms.amp.mixins.AmpMixin, 'cms.genericpage', models.Model),
        ),
        migrations.CreateModel(
            name='BlogPage',
            fields=[
                ('genericpage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cms.GenericPage')),
                ('cover', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], blank=True)),
                ('bg_desktop', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], blank=True)),
                ('bg_mobile', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtail.documents.blocks.DocumentChooserBlock())], blank=True)),
                ('date', models.DateTimeField(default=datetime.date.today, verbose_name='Date publication + tri')),
                ('date_updated', models.DateTimeField(blank=True, default=None, null=True, verbose_name='Date mise à jour')),
                ('intro', models.CharField(blank=True, default='', max_length=500)),
                ('intro_page', wagtail.core.fields.RichTextField(blank=True, default='')),
                ('h1', models.CharField(blank=True, default='', max_length=200)),
                ('related_blogs', wagtail.core.fields.StreamField([('article', wagtail.core.blocks.PageChooserBlock(page_type=['cms.BlogPage'], required=False))], blank=True)),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
            bases=(webspace.cms.amp.mixins.AmpMixin, webspace.cms.forms.abstract.FormMixin, 'cms.genericpage', models.Model),
        ),
        migrations.CreateModel(
            name='ContentPage',
            fields=[
                ('genericpage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cms.GenericPage')),
            ],
            options={
                'abstract': False,
            },
            bases=(webspace.cms.amp.mixins.AmpMixin, webspace.cms.forms.abstract.FormMixin, 'cms.genericpage', models.Model),
        ),
        migrations.CreateModel(
            name='HomePage',
            fields=[
                ('genericpage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cms.GenericPage')),
            ],
            options={
                'abstract': False,
            },
            bases=(webspace.cms.amp.mixins.AmpMixin, webspace.cms.forms.abstract.FormMixin, 'cms.genericpage', models.Model),
        ),
        migrations.CreateModel(
            name='WebspaceSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('facebook', models.URLField(blank=True, help_text='Facebook page URL')),
                ('instagram', models.URLField(blank=True, help_text='Instagram page URL')),
                ('linkedin', models.URLField(blank=True, help_text='Linkedin page URL')),
                ('twitter', models.URLField(blank=True, help_text='Twitter page URL')),
                ('pinterest', models.URLField(blank=True, help_text='Pinterest page URL')),
                ('youtube', models.URLField(blank=True, help_text='Youtube page URL')),
                ('brand_name', models.CharField(blank=True, default='', max_length=100)),
                ('logo_header_primary', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock(label='Image - ratio 200x55')), ('svg', wagtail.documents.blocks.DocumentChooserBlock(label='Svg - ratio 200x55'))], blank=True)),
                ('logo_header_secondary', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock(label='Image - ratio 200x55')), ('svg', wagtail.documents.blocks.DocumentChooserBlock(label='Svg - ratio 200x55'))], blank=True)),
                ('ga_code', models.CharField(blank=True, default='', help_text='Google Analytics - Code de suivis', max_length=100)),
                ('language', models.CharField(blank=True, choices=[('fr', 'French'), ('en', 'English')], default='', help_text='Language du site', max_length=100)),
                ('collect_text', wagtail.core.fields.RichTextField(blank=True, default='', help_text="Text qui apparait lorsqu'une personne doit accepter les CGU ou autre")),
                ('social_share_text', wagtail.core.fields.RichTextField(blank=True, default='', help_text='Text qui apparait sur un block Social Share')),
                ('vat_id', models.CharField(blank=True, default='', max_length=100)),
                ('legal_name', models.CharField(blank=True, default='', max_length=100)),
                ('founding_date', models.DateField(blank=True, default=None, null=True)),
                ('contact_phone', models.CharField(blank=True, default='', max_length=100)),
                ('contact_email', models.CharField(blank=True, default='', max_length=100)),
                ('area_served', models.CharField(blank=True, default='', max_length=100)),
                ('location_street_address', models.CharField(blank=True, default='', max_length=100)),
                ('location_address_locality', models.CharField(blank=True, default='', max_length=100)),
                ('location_postal_code', models.CharField(blank=True, default='', max_length=100)),
                ('location_address_country', models.CharField(blank=True, default='', max_length=100)),
                ('founding_location', models.CharField(blank=True, default='', max_length=100)),
                ('favicon', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Favicon')),
                ('logo_schema', models.ForeignKey(blank=True, help_text='Logo pour les Schemas Google', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Logo Entreprise')),
                ('newsletter', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='cms.Form', verbose_name='Newsletter Formulaire')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
            ],
            options={
                'verbose_name': 'Base',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MyDocument',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('file', models.FileField(upload_to='documents', verbose_name='file')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('file_size', models.PositiveIntegerField(editable=False, null=True)),
                ('file_hash', models.CharField(blank=True, editable=False, max_length=40)),
                ('width', models.IntegerField(blank=True, default=None, help_text='for SVG', null=True)),
                ('height', models.IntegerField(blank=True, default=None, help_text='for SVG', null=True)),
                ('collection', models.ForeignKey(default=wagtail.core.models.get_root_collection_id, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='wagtailcore.Collection', verbose_name='collection')),
                ('tags', taggit.managers.TaggableManager(blank=True, help_text=None, through='taggit.TaggedItem', to='taggit.Tag', verbose_name='tags')),
                ('uploaded_by_user', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='uploaded by user')),
            ],
            options={
                'abstract': False,
            },
            bases=(wagtail.search.index.Indexed, models.Model),
        ),
        migrations.CreateModel(
            name='MultiLanguagePage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('language', models.CharField(blank=True, choices=[('fr', 'French'), ('en', 'English')], default='', help_text='Language de la page', max_length=100)),
                ('page', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page', verbose_name='Page')),
                ('parent', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='language_pages', to='cms.GenericPage')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MenuItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('link_title', models.CharField(blank=True, max_length=50, null=True)),
                ('link_url', models.CharField(blank=True, max_length=500)),
                ('open_in_new_tab', models.BooleanField(blank=True, default=False)),
                ('link_page', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='wagtailcore.Page')),
                ('menu', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='menu_items', to='cms.Menu')),
            ],
            options={
                'verbose_name': 'Icon',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='IconSnippet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(max_length=255)),
                ('light', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='cms.MyDocument')),
                ('space', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='cms.MyDocument')),
            ],
            options={
                'verbose_name': 'Icon',
                'abstract': False,
            },
            bases=(wagtail.search.index.Indexed, models.Model),
        ),
        migrations.AddField(
            model_name='genericpage',
            name='navigation',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='cms.Navigation', verbose_name='Navigation'),
        ),
        migrations.CreateModel(
            name='Founders',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('name', models.CharField(blank=True, default='', max_length=100)),
                ('gender', models.CharField(blank=True, choices=[('Male', 'Male'), ('Female', 'Female')], default='', max_length=100)),
                ('same_as', models.URLField(blank=True)),
                ('nationality', models.CharField(blank=True, default='', max_length=100)),
                ('settings', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='founders', to='cms.WebspaceSettings')),
            ],
            options={
                'verbose_name': 'Founder',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FormSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('form_data', models.TextField()),
                ('submit_time', models.DateTimeField(auto_now_add=True, verbose_name='submit time')),
                ('form', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='submissions_form', to='cms.Form')),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='submissions_page', to='wagtailcore.Page')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FormField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('label', models.CharField(help_text='The label of the form field', max_length=255, verbose_name='label')),
                ('field_type', models.CharField(choices=[('singleline', 'Single line text'), ('multiline', 'Multi-line text'), ('email', 'Email'), ('number', 'Number'), ('url', 'URL'), ('checkbox', 'Checkbox'), ('checkboxes', 'Checkboxes'), ('dropdown', 'Drop down'), ('multiselect', 'Multiple select'), ('radio', 'Radio buttons'), ('date', 'Date'), ('datetime', 'Date/time'), ('hidden', 'Hidden field')], max_length=16, verbose_name='field type')),
                ('required', models.BooleanField(default=True, verbose_name='required')),
                ('choices', models.TextField(blank=True, help_text='Comma separated list of choices. Only applicable in checkboxes, radio and dropdown.', verbose_name='choices')),
                ('default_value', models.CharField(blank=True, help_text='Default value. Comma separated values supported for checkboxes.', max_length=255, verbose_name='default value')),
                ('help_text', models.CharField(blank=True, max_length=255, verbose_name='help text')),
                ('placeholder', models.CharField(blank=True, max_length=255, verbose_name='Placeholder')),
                ('form', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='form_fields', to='cms.Form')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DocumentPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('document', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='cms.MyDocument')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='BlogPageTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='cms_blogpagetag_items', to='taggit.Tag')),
                ('content_object', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='tagged_items', to='cms.BlogPage')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='blogpage',
            name='tags',
            field=modelcluster.contrib.taggit.ClusterTaggableManager(blank=True, help_text='A comma-separated list of tags.', through='cms.BlogPageTag', to='taggit.Tag', verbose_name='Tags'),
        ),
    ]
