# coding: utf-8

"""
    Safe Checkout

    Simple, yet elegant web interfaces for your convenience. One request away from your first secured C2C transaction.

    The version of the OpenAPI document: 2.0.54
    Contact: noc@tripartie.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from tpdk_safe_checkout.models.webhook_object import WebhookObject
from typing import Optional, Set
from typing_extensions import Self

class Webhook(BaseModel):
    """
    Webhook
    """ # noqa: E501
    id: Optional[StrictInt] = None
    event: Optional[StrictStr] = None
    object_id: Optional[StrictStr] = Field(default=None, alias="objectId")
    iri: Optional[StrictStr] = None
    occurred_at: Optional[datetime] = Field(default=None, alias="occurredAt")
    object: Optional[WebhookObject] = None
    __properties: ClassVar[List[str]] = ["id", "event", "objectId", "iri", "occurredAt", "object"]

    @field_validator('event')
    def event_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['offer.transaction.authorized', 'offer.transaction.accepted', 'offer.transaction.shipped', 'offer.transaction.delivered', 'offer.transaction.completed', 'offer.transaction.canceled', 'offer.transaction.disputed', 'offer.closed', 'persona.added']):
            raise ValueError("must be one of enum values ('offer.transaction.authorized', 'offer.transaction.accepted', 'offer.transaction.shipped', 'offer.transaction.delivered', 'offer.transaction.completed', 'offer.transaction.canceled', 'offer.transaction.disputed', 'offer.closed', 'persona.added')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Webhook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of object
        if self.object:
            _dict['object'] = self.object.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Webhook from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "event": obj.get("event"),
            "objectId": obj.get("objectId"),
            "iri": obj.get("iri"),
            "occurredAt": obj.get("occurredAt"),
            "object": WebhookObject.from_dict(obj["object"]) if obj.get("object") is not None else None
        })
        return _obj


