# coding: utf-8

"""
    Safe Checkout

    Simple, yet elegant web interfaces for your convenience. One request away from your first secured C2C transaction.

    The version of the OpenAPI document: 2.0.54
    Contact: noc@tripartie.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class TransactionUpdate(BaseModel):
    """
    
    """ # noqa: E501
    status: Optional[StrictStr] = None
    supplemental_fees: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="usually set if the weight was underestimated and shipping carrier billed us an extra.", alias="supplementalFees")
    balance_to_refund: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="balanceToRefund")
    fees_to_refund: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="feesToRefund")
    force_refund_shipping: Optional[StrictBool] = Field(default=None, description="Shipping is never refunded on purpose. Once deposited (parcel), we are billed for it.", alias="forceRefundShipping")
    review: Optional[StrictStr] = None
    rating: Optional[StrictInt] = None
    hand_over_code_confirmation: Optional[StrictStr] = Field(default=None, alias="handOverCodeConfirmation")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    __properties: ClassVar[List[str]] = ["status", "supplementalFees", "balanceToRefund", "feesToRefund", "forceRefundShipping", "review", "rating", "handOverCodeConfirmation", "updatedAt"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CREATED', 'AUTHORIZED', 'REFUSED', 'ACCEPTED', 'SHIPPED', 'IN_TRANSIT', 'BLOCKED', 'DELIVERED', 'COMPLETED', 'DISPUTED', 'CANCELLED', 'null']):
            raise ValueError("must be one of enum values ('CREATED', 'AUTHORIZED', 'REFUSED', 'ACCEPTED', 'SHIPPED', 'IN_TRANSIT', 'BLOCKED', 'DELIVERED', 'COMPLETED', 'DISPUTED', 'CANCELLED', 'null')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if supplemental_fees (nullable) is None
        # and model_fields_set contains the field
        if self.supplemental_fees is None and "supplemental_fees" in self.model_fields_set:
            _dict['supplementalFees'] = None

        # set to None if balance_to_refund (nullable) is None
        # and model_fields_set contains the field
        if self.balance_to_refund is None and "balance_to_refund" in self.model_fields_set:
            _dict['balanceToRefund'] = None

        # set to None if fees_to_refund (nullable) is None
        # and model_fields_set contains the field
        if self.fees_to_refund is None and "fees_to_refund" in self.model_fields_set:
            _dict['feesToRefund'] = None

        # set to None if force_refund_shipping (nullable) is None
        # and model_fields_set contains the field
        if self.force_refund_shipping is None and "force_refund_shipping" in self.model_fields_set:
            _dict['forceRefundShipping'] = None

        # set to None if review (nullable) is None
        # and model_fields_set contains the field
        if self.review is None and "review" in self.model_fields_set:
            _dict['review'] = None

        # set to None if rating (nullable) is None
        # and model_fields_set contains the field
        if self.rating is None and "rating" in self.model_fields_set:
            _dict['rating'] = None

        # set to None if hand_over_code_confirmation (nullable) is None
        # and model_fields_set contains the field
        if self.hand_over_code_confirmation is None and "hand_over_code_confirmation" in self.model_fields_set:
            _dict['handOverCodeConfirmation'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updatedAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "supplementalFees": obj.get("supplementalFees"),
            "balanceToRefund": obj.get("balanceToRefund"),
            "feesToRefund": obj.get("feesToRefund"),
            "forceRefundShipping": obj.get("forceRefundShipping"),
            "review": obj.get("review"),
            "rating": obj.get("rating"),
            "handOverCodeConfirmation": obj.get("handOverCodeConfirmation"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj


