# coding: utf-8

"""
    Safe Checkout

    Simple, yet elegant web interfaces for your convenience. One request away from your first secured C2C transaction.

    The version of the OpenAPI document: 2.0.54
    Contact: noc@tripartie.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr, field_validator
from typing import List, Optional, Union
from typing_extensions import Annotated
from tpdk_safe_checkout.models.media_read import MediaRead
from tpdk_safe_checkout.models.offer_collection_read import OfferCollectionRead
from tpdk_safe_checkout.models.offer_independent_write import OfferIndependentWrite
from tpdk_safe_checkout.models.offer_post_creation_read import OfferPostCreationRead
from tpdk_safe_checkout.models.offer_read import OfferRead
from tpdk_safe_checkout.models.offer_solo_write import OfferSoloWrite
from tpdk_safe_checkout.models.offer_update import OfferUpdate

from tpdk_safe_checkout.api_client import ApiClient, RequestSerialized
from tpdk_safe_checkout.api_response import ApiResponse
from tpdk_safe_checkout.rest import RESTResponseType


class SafeCheckoutApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def api_offers_get_collection(
        self,
        page: Annotated[Optional[StrictInt], Field(description="The collection page number")] = None,
        title: Optional[StrictStr] = None,
        public_url: Optional[StrictStr] = None,
        public_url2: Optional[List[StrictStr]] = None,
        unit_price: Optional[StrictStr] = None,
        unit_price2: Optional[List[StrictStr]] = None,
        item_count: Optional[StrictInt] = None,
        item_count2: Optional[List[StrictInt]] = None,
        created_at_before: Optional[StrictStr] = None,
        created_at_strictly_before: Optional[StrictStr] = None,
        created_at_after: Optional[StrictStr] = None,
        created_at_strictly_after: Optional[StrictStr] = None,
        metadata: Annotated[Optional[List[List[StrictStr]]], Field(description="Flattened OrderedMap for metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.")] = None,
        offer_metadata: Annotated[Optional[List[List[StrictStr]]], Field(description="Flattened OrderedMap for offer.metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.")] = None,
        seller_metadata: Annotated[Optional[List[List[StrictStr]]], Field(description="Flattened OrderedMap for seller.metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.")] = None,
        nature: Annotated[Optional[StrictStr], Field(description="Filter on a specific value of nature")] = None,
        nature2: Annotated[Optional[List[List[StrictStr]]], Field(description="Filter on a limited subset of nature")] = None,
        condition: Annotated[Optional[StrictStr], Field(description="Filter on a specific value of condition")] = None,
        condition2: Annotated[Optional[List[List[StrictStr]]], Field(description="Filter on a limited subset of condition")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter on a specific value of status")] = None,
        status2: Annotated[Optional[List[List[StrictStr]]], Field(description="Filter on a limited subset of status")] = None,
        shipping_allowed: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[OfferCollectionRead]:
        """Search amongst Offers

        Retrieves the collection of Offer resources.

        :param page: The collection page number
        :type page: int
        :param title: 
        :type title: str
        :param public_url: 
        :type public_url: str
        :param public_url2: 
        :type public_url2: List[str]
        :param unit_price: 
        :type unit_price: str
        :param unit_price2: 
        :type unit_price2: List[str]
        :param item_count: 
        :type item_count: int
        :param item_count2: 
        :type item_count2: List[int]
        :param created_at_before: 
        :type created_at_before: str
        :param created_at_strictly_before: 
        :type created_at_strictly_before: str
        :param created_at_after: 
        :type created_at_after: str
        :param created_at_strictly_after: 
        :type created_at_strictly_after: str
        :param metadata: Flattened OrderedMap for metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.
        :type metadata: List[str]
        :param offer_metadata: Flattened OrderedMap for offer.metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.
        :type offer_metadata: List[str]
        :param seller_metadata: Flattened OrderedMap for seller.metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.
        :type seller_metadata: List[str]
        :param nature: Filter on a specific value of nature
        :type nature: str
        :param nature2: Filter on a limited subset of nature
        :type nature2: List[str]
        :param condition: Filter on a specific value of condition
        :type condition: str
        :param condition2: Filter on a limited subset of condition
        :type condition2: List[str]
        :param status: Filter on a specific value of status
        :type status: str
        :param status2: Filter on a limited subset of status
        :type status2: List[str]
        :param shipping_allowed: 
        :type shipping_allowed: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_get_collection_serialize(
            page=page,
            title=title,
            public_url=public_url,
            public_url2=public_url2,
            unit_price=unit_price,
            unit_price2=unit_price2,
            item_count=item_count,
            item_count2=item_count2,
            created_at_before=created_at_before,
            created_at_strictly_before=created_at_strictly_before,
            created_at_after=created_at_after,
            created_at_strictly_after=created_at_strictly_after,
            metadata=metadata,
            offer_metadata=offer_metadata,
            seller_metadata=seller_metadata,
            nature=nature,
            nature2=nature2,
            condition=condition,
            condition2=condition2,
            status=status,
            status2=status2,
            shipping_allowed=shipping_allowed,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[OfferCollectionRead]",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_offers_get_collection_with_http_info(
        self,
        page: Annotated[Optional[StrictInt], Field(description="The collection page number")] = None,
        title: Optional[StrictStr] = None,
        public_url: Optional[StrictStr] = None,
        public_url2: Optional[List[StrictStr]] = None,
        unit_price: Optional[StrictStr] = None,
        unit_price2: Optional[List[StrictStr]] = None,
        item_count: Optional[StrictInt] = None,
        item_count2: Optional[List[StrictInt]] = None,
        created_at_before: Optional[StrictStr] = None,
        created_at_strictly_before: Optional[StrictStr] = None,
        created_at_after: Optional[StrictStr] = None,
        created_at_strictly_after: Optional[StrictStr] = None,
        metadata: Annotated[Optional[List[List[StrictStr]]], Field(description="Flattened OrderedMap for metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.")] = None,
        offer_metadata: Annotated[Optional[List[List[StrictStr]]], Field(description="Flattened OrderedMap for offer.metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.")] = None,
        seller_metadata: Annotated[Optional[List[List[StrictStr]]], Field(description="Flattened OrderedMap for seller.metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.")] = None,
        nature: Annotated[Optional[StrictStr], Field(description="Filter on a specific value of nature")] = None,
        nature2: Annotated[Optional[List[List[StrictStr]]], Field(description="Filter on a limited subset of nature")] = None,
        condition: Annotated[Optional[StrictStr], Field(description="Filter on a specific value of condition")] = None,
        condition2: Annotated[Optional[List[List[StrictStr]]], Field(description="Filter on a limited subset of condition")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter on a specific value of status")] = None,
        status2: Annotated[Optional[List[List[StrictStr]]], Field(description="Filter on a limited subset of status")] = None,
        shipping_allowed: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[OfferCollectionRead]]:
        """Search amongst Offers

        Retrieves the collection of Offer resources.

        :param page: The collection page number
        :type page: int
        :param title: 
        :type title: str
        :param public_url: 
        :type public_url: str
        :param public_url2: 
        :type public_url2: List[str]
        :param unit_price: 
        :type unit_price: str
        :param unit_price2: 
        :type unit_price2: List[str]
        :param item_count: 
        :type item_count: int
        :param item_count2: 
        :type item_count2: List[int]
        :param created_at_before: 
        :type created_at_before: str
        :param created_at_strictly_before: 
        :type created_at_strictly_before: str
        :param created_at_after: 
        :type created_at_after: str
        :param created_at_strictly_after: 
        :type created_at_strictly_after: str
        :param metadata: Flattened OrderedMap for metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.
        :type metadata: List[str]
        :param offer_metadata: Flattened OrderedMap for offer.metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.
        :type offer_metadata: List[str]
        :param seller_metadata: Flattened OrderedMap for seller.metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.
        :type seller_metadata: List[str]
        :param nature: Filter on a specific value of nature
        :type nature: str
        :param nature2: Filter on a limited subset of nature
        :type nature2: List[str]
        :param condition: Filter on a specific value of condition
        :type condition: str
        :param condition2: Filter on a limited subset of condition
        :type condition2: List[str]
        :param status: Filter on a specific value of status
        :type status: str
        :param status2: Filter on a limited subset of status
        :type status2: List[str]
        :param shipping_allowed: 
        :type shipping_allowed: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_get_collection_serialize(
            page=page,
            title=title,
            public_url=public_url,
            public_url2=public_url2,
            unit_price=unit_price,
            unit_price2=unit_price2,
            item_count=item_count,
            item_count2=item_count2,
            created_at_before=created_at_before,
            created_at_strictly_before=created_at_strictly_before,
            created_at_after=created_at_after,
            created_at_strictly_after=created_at_strictly_after,
            metadata=metadata,
            offer_metadata=offer_metadata,
            seller_metadata=seller_metadata,
            nature=nature,
            nature2=nature2,
            condition=condition,
            condition2=condition2,
            status=status,
            status2=status2,
            shipping_allowed=shipping_allowed,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[OfferCollectionRead]",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_offers_get_collection_without_preload_content(
        self,
        page: Annotated[Optional[StrictInt], Field(description="The collection page number")] = None,
        title: Optional[StrictStr] = None,
        public_url: Optional[StrictStr] = None,
        public_url2: Optional[List[StrictStr]] = None,
        unit_price: Optional[StrictStr] = None,
        unit_price2: Optional[List[StrictStr]] = None,
        item_count: Optional[StrictInt] = None,
        item_count2: Optional[List[StrictInt]] = None,
        created_at_before: Optional[StrictStr] = None,
        created_at_strictly_before: Optional[StrictStr] = None,
        created_at_after: Optional[StrictStr] = None,
        created_at_strictly_after: Optional[StrictStr] = None,
        metadata: Annotated[Optional[List[List[StrictStr]]], Field(description="Flattened OrderedMap for metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.")] = None,
        offer_metadata: Annotated[Optional[List[List[StrictStr]]], Field(description="Flattened OrderedMap for offer.metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.")] = None,
        seller_metadata: Annotated[Optional[List[List[StrictStr]]], Field(description="Flattened OrderedMap for seller.metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.")] = None,
        nature: Annotated[Optional[StrictStr], Field(description="Filter on a specific value of nature")] = None,
        nature2: Annotated[Optional[List[List[StrictStr]]], Field(description="Filter on a limited subset of nature")] = None,
        condition: Annotated[Optional[StrictStr], Field(description="Filter on a specific value of condition")] = None,
        condition2: Annotated[Optional[List[List[StrictStr]]], Field(description="Filter on a limited subset of condition")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter on a specific value of status")] = None,
        status2: Annotated[Optional[List[List[StrictStr]]], Field(description="Filter on a limited subset of status")] = None,
        shipping_allowed: Optional[StrictBool] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Search amongst Offers

        Retrieves the collection of Offer resources.

        :param page: The collection page number
        :type page: int
        :param title: 
        :type title: str
        :param public_url: 
        :type public_url: str
        :param public_url2: 
        :type public_url2: List[str]
        :param unit_price: 
        :type unit_price: str
        :param unit_price2: 
        :type unit_price2: List[str]
        :param item_count: 
        :type item_count: int
        :param item_count2: 
        :type item_count2: List[int]
        :param created_at_before: 
        :type created_at_before: str
        :param created_at_strictly_before: 
        :type created_at_strictly_before: str
        :param created_at_after: 
        :type created_at_after: str
        :param created_at_strictly_after: 
        :type created_at_strictly_after: str
        :param metadata: Flattened OrderedMap for metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.
        :type metadata: List[str]
        :param offer_metadata: Flattened OrderedMap for offer.metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.
        :type offer_metadata: List[str]
        :param seller_metadata: Flattened OrderedMap for seller.metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.
        :type seller_metadata: List[str]
        :param nature: Filter on a specific value of nature
        :type nature: str
        :param nature2: Filter on a limited subset of nature
        :type nature2: List[str]
        :param condition: Filter on a specific value of condition
        :type condition: str
        :param condition2: Filter on a limited subset of condition
        :type condition2: List[str]
        :param status: Filter on a specific value of status
        :type status: str
        :param status2: Filter on a limited subset of status
        :type status2: List[str]
        :param shipping_allowed: 
        :type shipping_allowed: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_get_collection_serialize(
            page=page,
            title=title,
            public_url=public_url,
            public_url2=public_url2,
            unit_price=unit_price,
            unit_price2=unit_price2,
            item_count=item_count,
            item_count2=item_count2,
            created_at_before=created_at_before,
            created_at_strictly_before=created_at_strictly_before,
            created_at_after=created_at_after,
            created_at_strictly_after=created_at_strictly_after,
            metadata=metadata,
            offer_metadata=offer_metadata,
            seller_metadata=seller_metadata,
            nature=nature,
            nature2=nature2,
            condition=condition,
            condition2=condition2,
            status=status,
            status2=status2,
            shipping_allowed=shipping_allowed,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[OfferCollectionRead]",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_offers_get_collection_serialize(
        self,
        page,
        title,
        public_url,
        public_url2,
        unit_price,
        unit_price2,
        item_count,
        item_count2,
        created_at_before,
        created_at_strictly_before,
        created_at_after,
        created_at_strictly_after,
        metadata,
        offer_metadata,
        seller_metadata,
        nature,
        nature2,
        condition,
        condition2,
        status,
        status2,
        shipping_allowed,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'publicUrl[]': 'multi',
            'unitPrice[]': 'multi',
            'itemCount[]': 'multi',
            'metadata[]': 'csv',
            'offer.metadata[]': 'csv',
            'seller.metadata[]': 'csv',
            'nature[]': 'csv',
            'condition[]': 'csv',
            'status[]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if public_url is not None:
            
            _query_params.append(('publicUrl', public_url))
            
        if public_url2 is not None:
            
            _query_params.append(('publicUrl[]', public_url2))
            
        if unit_price is not None:
            
            _query_params.append(('unitPrice', unit_price))
            
        if unit_price2 is not None:
            
            _query_params.append(('unitPrice[]', unit_price2))
            
        if item_count is not None:
            
            _query_params.append(('itemCount', item_count))
            
        if item_count2 is not None:
            
            _query_params.append(('itemCount[]', item_count2))
            
        if created_at_before is not None:
            
            _query_params.append(('createdAt[before]', created_at_before))
            
        if created_at_strictly_before is not None:
            
            _query_params.append(('createdAt[strictly_before]', created_at_strictly_before))
            
        if created_at_after is not None:
            
            _query_params.append(('createdAt[after]', created_at_after))
            
        if created_at_strictly_after is not None:
            
            _query_params.append(('createdAt[strictly_after]', created_at_strictly_after))
            
        if metadata is not None:
            
            _query_params.append(('metadata[]', metadata))
            
        if offer_metadata is not None:
            
            _query_params.append(('offer.metadata[]', offer_metadata))
            
        if seller_metadata is not None:
            
            _query_params.append(('seller.metadata[]', seller_metadata))
            
        if nature is not None:
            
            _query_params.append(('nature', nature))
            
        if nature2 is not None:
            
            _query_params.append(('nature[]', nature2))
            
        if condition is not None:
            
            _query_params.append(('condition', condition))
            
        if condition2 is not None:
            
            _query_params.append(('condition[]', condition2))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if status2 is not None:
            
            _query_params.append(('status[]', status2))
            
        if shipping_allowed is not None:
            
            _query_params.append(('shippingAllowed', shipping_allowed))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'jwtPersonalKey', 
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/offers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_offers_post(
        self,
        offer_independent_write: Annotated[OfferIndependentWrite, Field(description="The new Offer resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OfferPostCreationRead:
        """Create a public link for Offer

        Create a public listening Offer linked to a specific Seller

        :param offer_independent_write: The new Offer resource (required)
        :type offer_independent_write: OfferIndependentWrite
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_post_serialize(
            offer_independent_write=offer_independent_write,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "OfferPostCreationRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_offers_post_with_http_info(
        self,
        offer_independent_write: Annotated[OfferIndependentWrite, Field(description="The new Offer resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OfferPostCreationRead]:
        """Create a public link for Offer

        Create a public listening Offer linked to a specific Seller

        :param offer_independent_write: The new Offer resource (required)
        :type offer_independent_write: OfferIndependentWrite
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_post_serialize(
            offer_independent_write=offer_independent_write,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "OfferPostCreationRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_offers_post_without_preload_content(
        self,
        offer_independent_write: Annotated[OfferIndependentWrite, Field(description="The new Offer resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a public link for Offer

        Create a public listening Offer linked to a specific Seller

        :param offer_independent_write: The new Offer resource (required)
        :type offer_independent_write: OfferIndependentWrite
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_post_serialize(
            offer_independent_write=offer_independent_write,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "OfferPostCreationRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_offers_post_serialize(
        self,
        offer_independent_write,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if offer_independent_write is not None:
            _body_params = offer_independent_write


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/offers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_offers_ulid_delete(
        self,
        ulid: Annotated[StrictStr, Field(description="Offer identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Disable existing Offer

        Make a specific Offer as non longer active

        :param ulid: Offer identifier (required)
        :type ulid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulid_delete_serialize(
            ulid=ulid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_offers_ulid_delete_with_http_info(
        self,
        ulid: Annotated[StrictStr, Field(description="Offer identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Disable existing Offer

        Make a specific Offer as non longer active

        :param ulid: Offer identifier (required)
        :type ulid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulid_delete_serialize(
            ulid=ulid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_offers_ulid_delete_without_preload_content(
        self,
        ulid: Annotated[StrictStr, Field(description="Offer identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Disable existing Offer

        Make a specific Offer as non longer active

        :param ulid: Offer identifier (required)
        :type ulid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulid_delete_serialize(
            ulid=ulid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_offers_ulid_delete_serialize(
        self,
        ulid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ulid is not None:
            _path_params['ulid'] = ulid
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'jwtPersonalKey', 
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/offers/{ulid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_offers_ulid_get(
        self,
        ulid: Annotated[StrictStr, Field(description="Offer identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OfferRead:
        """Fetch a Offer details

        Retrieves a Offer resource.

        :param ulid: Offer identifier (required)
        :type ulid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulid_get_serialize(
            ulid=ulid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferRead",
            '404': "NotFoundError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_offers_ulid_get_with_http_info(
        self,
        ulid: Annotated[StrictStr, Field(description="Offer identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OfferRead]:
        """Fetch a Offer details

        Retrieves a Offer resource.

        :param ulid: Offer identifier (required)
        :type ulid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulid_get_serialize(
            ulid=ulid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferRead",
            '404': "NotFoundError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_offers_ulid_get_without_preload_content(
        self,
        ulid: Annotated[StrictStr, Field(description="Offer identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Fetch a Offer details

        Retrieves a Offer resource.

        :param ulid: Offer identifier (required)
        :type ulid: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulid_get_serialize(
            ulid=ulid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferRead",
            '404': "NotFoundError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_offers_ulid_get_serialize(
        self,
        ulid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ulid is not None:
            _path_params['ulid'] = ulid
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'jwtPersonalKey', 
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/offers/{ulid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_offers_ulid_patch(
        self,
        ulid: Annotated[StrictStr, Field(description="Offer identifier")],
        offer_update: Annotated[OfferUpdate, Field(description="The updated Offer resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OfferPostCreationRead:
        """Update existing Offer

        Update your existing Offer and reuse existing generated link

        :param ulid: Offer identifier (required)
        :type ulid: str
        :param offer_update: The updated Offer resource (required)
        :type offer_update: OfferUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulid_patch_serialize(
            ulid=ulid,
            offer_update=offer_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferPostCreationRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_offers_ulid_patch_with_http_info(
        self,
        ulid: Annotated[StrictStr, Field(description="Offer identifier")],
        offer_update: Annotated[OfferUpdate, Field(description="The updated Offer resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OfferPostCreationRead]:
        """Update existing Offer

        Update your existing Offer and reuse existing generated link

        :param ulid: Offer identifier (required)
        :type ulid: str
        :param offer_update: The updated Offer resource (required)
        :type offer_update: OfferUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulid_patch_serialize(
            ulid=ulid,
            offer_update=offer_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferPostCreationRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_offers_ulid_patch_without_preload_content(
        self,
        ulid: Annotated[StrictStr, Field(description="Offer identifier")],
        offer_update: Annotated[OfferUpdate, Field(description="The updated Offer resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update existing Offer

        Update your existing Offer and reuse existing generated link

        :param ulid: Offer identifier (required)
        :type ulid: str
        :param offer_update: The updated Offer resource (required)
        :type offer_update: OfferUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulid_patch_serialize(
            ulid=ulid,
            offer_update=offer_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferPostCreationRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_offers_ulid_patch_serialize(
        self,
        ulid,
        offer_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ulid is not None:
            _path_params['ulid'] = ulid
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if offer_update is not None:
            _body_params = offer_update


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'jwtPersonalKey', 
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/offers/{ulid}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_offers_ulidmedias_id_delete(
        self,
        ulid: StrictStr,
        id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Removes the Media resource.

        Removes the Media resource.

        :param ulid:  (required)
        :type ulid: str
        :param id:  (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulidmedias_id_delete_serialize(
            ulid=ulid,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_offers_ulidmedias_id_delete_with_http_info(
        self,
        ulid: StrictStr,
        id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Removes the Media resource.

        Removes the Media resource.

        :param ulid:  (required)
        :type ulid: str
        :param id:  (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulidmedias_id_delete_serialize(
            ulid=ulid,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_offers_ulidmedias_id_delete_without_preload_content(
        self,
        ulid: StrictStr,
        id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Removes the Media resource.

        Removes the Media resource.

        :param ulid:  (required)
        :type ulid: str
        :param id:  (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulidmedias_id_delete_serialize(
            ulid=ulid,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_offers_ulidmedias_id_delete_serialize(
        self,
        ulid,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ulid is not None:
            _path_params['ulid'] = ulid
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'jwtPersonalKey', 
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/offers/{ulid}/medias/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_offers_ulidmedias_post(
        self,
        ulid: StrictStr,
        file: Optional[Union[StrictBytes, StrictStr]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MediaRead:
        """Upload a picture for a given Offer

        Creates a Media resource.

        :param ulid:  (required)
        :type ulid: str
        :param file:
        :type file: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulidmedias_post_serialize(
            ulid=ulid,
            file=file,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "MediaRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_offers_ulidmedias_post_with_http_info(
        self,
        ulid: StrictStr,
        file: Optional[Union[StrictBytes, StrictStr]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MediaRead]:
        """Upload a picture for a given Offer

        Creates a Media resource.

        :param ulid:  (required)
        :type ulid: str
        :param file:
        :type file: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulidmedias_post_serialize(
            ulid=ulid,
            file=file,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "MediaRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_offers_ulidmedias_post_without_preload_content(
        self,
        ulid: StrictStr,
        file: Optional[Union[StrictBytes, StrictStr]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Upload a picture for a given Offer

        Creates a Media resource.

        :param ulid:  (required)
        :type ulid: str
        :param file:
        :type file: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_offers_ulidmedias_post_serialize(
            ulid=ulid,
            file=file,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "MediaRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_offers_ulidmedias_post_serialize(
        self,
        ulid,
        file,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ulid is not None:
            _path_params['ulid'] = ulid
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if file is not None:
            _files['file'] = file
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'jwtPersonalKey', 
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/offers/{ulid}/medias',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_users_idoffers_post(
        self,
        id: Annotated[StrictInt, Field(description="User identifier")],
        offer_solo_write: Annotated[OfferSoloWrite, Field(description="The new Offer resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OfferPostCreationRead:
        """Issue an Offer as User

        Create a public listening Offer linked to a specific User

        :param id: User identifier (required)
        :type id: int
        :param offer_solo_write: The new Offer resource (required)
        :type offer_solo_write: OfferSoloWrite
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_users_idoffers_post_serialize(
            id=id,
            offer_solo_write=offer_solo_write,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "OfferPostCreationRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_users_idoffers_post_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="User identifier")],
        offer_solo_write: Annotated[OfferSoloWrite, Field(description="The new Offer resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OfferPostCreationRead]:
        """Issue an Offer as User

        Create a public listening Offer linked to a specific User

        :param id: User identifier (required)
        :type id: int
        :param offer_solo_write: The new Offer resource (required)
        :type offer_solo_write: OfferSoloWrite
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_users_idoffers_post_serialize(
            id=id,
            offer_solo_write=offer_solo_write,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "OfferPostCreationRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_users_idoffers_post_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="User identifier")],
        offer_solo_write: Annotated[OfferSoloWrite, Field(description="The new Offer resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Issue an Offer as User

        Create a public listening Offer linked to a specific User

        :param id: User identifier (required)
        :type id: int
        :param offer_solo_write: The new Offer resource (required)
        :type offer_solo_write: OfferSoloWrite
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_users_idoffers_post_serialize(
            id=id,
            offer_solo_write=offer_solo_write,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "OfferPostCreationRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_users_idoffers_post_serialize(
        self,
        id,
        offer_solo_write,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if offer_solo_write is not None:
            _body_params = offer_solo_write


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'jwtPersonalKey', 
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/users/{id}/offers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


