# coding: utf-8

"""
    Safe Checkout

    Simple, yet elegant web interfaces for your convenience. One request away from your first secured C2C transaction.

    The version of the OpenAPI document: 2.0.54
    Contact: noc@tripartie.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from tpdk_safe_checkout.models.persona_collection_read import PersonaCollectionRead
from tpdk_safe_checkout.models.persona_read import PersonaRead
from tpdk_safe_checkout.models.persona_update import PersonaUpdate
from tpdk_safe_checkout.models.persona_write import PersonaWrite

from tpdk_safe_checkout.api_client import ApiClient, RequestSerialized
from tpdk_safe_checkout.api_response import ApiResponse
from tpdk_safe_checkout.rest import RESTResponseType


class PersonaApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def api_personas_get_collection(
        self,
        page: Annotated[Optional[StrictInt], Field(description="The collection page number")] = None,
        first_name: Optional[StrictStr] = None,
        last_name: Optional[StrictStr] = None,
        email: Optional[StrictStr] = None,
        email2: Optional[List[StrictStr]] = None,
        mobile_phone_number: Optional[StrictStr] = None,
        mobile_phone_number2: Optional[List[StrictStr]] = None,
        gender: Annotated[Optional[StrictStr], Field(description="Filter on a specific value of gender")] = None,
        gender2: Annotated[Optional[List[List[StrictStr]]], Field(description="Filter on a limited subset of gender")] = None,
        order_created_at: Optional[StrictStr] = None,
        created_at_before: Optional[StrictStr] = None,
        created_at_strictly_before: Optional[StrictStr] = None,
        created_at_after: Optional[StrictStr] = None,
        created_at_strictly_after: Optional[StrictStr] = None,
        date_of_birth_before: Optional[StrictStr] = None,
        date_of_birth_strictly_before: Optional[StrictStr] = None,
        date_of_birth_after: Optional[StrictStr] = None,
        date_of_birth_strictly_after: Optional[StrictStr] = None,
        metadata: Annotated[Optional[List[List[StrictStr]]], Field(description="Flattened OrderedMap for metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[PersonaCollectionRead]:
        """Retrieves the collection of Persona resources.

        Retrieves the collection of Persona resources.

        :param page: The collection page number
        :type page: int
        :param first_name: 
        :type first_name: str
        :param last_name: 
        :type last_name: str
        :param email: 
        :type email: str
        :param email2: 
        :type email2: List[str]
        :param mobile_phone_number: 
        :type mobile_phone_number: str
        :param mobile_phone_number2: 
        :type mobile_phone_number2: List[str]
        :param gender: Filter on a specific value of gender
        :type gender: str
        :param gender2: Filter on a limited subset of gender
        :type gender2: List[str]
        :param order_created_at: 
        :type order_created_at: str
        :param created_at_before: 
        :type created_at_before: str
        :param created_at_strictly_before: 
        :type created_at_strictly_before: str
        :param created_at_after: 
        :type created_at_after: str
        :param created_at_strictly_after: 
        :type created_at_strictly_after: str
        :param date_of_birth_before: 
        :type date_of_birth_before: str
        :param date_of_birth_strictly_before: 
        :type date_of_birth_strictly_before: str
        :param date_of_birth_after: 
        :type date_of_birth_after: str
        :param date_of_birth_strictly_after: 
        :type date_of_birth_strictly_after: str
        :param metadata: Flattened OrderedMap for metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.
        :type metadata: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_get_collection_serialize(
            page=page,
            first_name=first_name,
            last_name=last_name,
            email=email,
            email2=email2,
            mobile_phone_number=mobile_phone_number,
            mobile_phone_number2=mobile_phone_number2,
            gender=gender,
            gender2=gender2,
            order_created_at=order_created_at,
            created_at_before=created_at_before,
            created_at_strictly_before=created_at_strictly_before,
            created_at_after=created_at_after,
            created_at_strictly_after=created_at_strictly_after,
            date_of_birth_before=date_of_birth_before,
            date_of_birth_strictly_before=date_of_birth_strictly_before,
            date_of_birth_after=date_of_birth_after,
            date_of_birth_strictly_after=date_of_birth_strictly_after,
            metadata=metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[PersonaCollectionRead]",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_personas_get_collection_with_http_info(
        self,
        page: Annotated[Optional[StrictInt], Field(description="The collection page number")] = None,
        first_name: Optional[StrictStr] = None,
        last_name: Optional[StrictStr] = None,
        email: Optional[StrictStr] = None,
        email2: Optional[List[StrictStr]] = None,
        mobile_phone_number: Optional[StrictStr] = None,
        mobile_phone_number2: Optional[List[StrictStr]] = None,
        gender: Annotated[Optional[StrictStr], Field(description="Filter on a specific value of gender")] = None,
        gender2: Annotated[Optional[List[List[StrictStr]]], Field(description="Filter on a limited subset of gender")] = None,
        order_created_at: Optional[StrictStr] = None,
        created_at_before: Optional[StrictStr] = None,
        created_at_strictly_before: Optional[StrictStr] = None,
        created_at_after: Optional[StrictStr] = None,
        created_at_strictly_after: Optional[StrictStr] = None,
        date_of_birth_before: Optional[StrictStr] = None,
        date_of_birth_strictly_before: Optional[StrictStr] = None,
        date_of_birth_after: Optional[StrictStr] = None,
        date_of_birth_strictly_after: Optional[StrictStr] = None,
        metadata: Annotated[Optional[List[List[StrictStr]]], Field(description="Flattened OrderedMap for metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[PersonaCollectionRead]]:
        """Retrieves the collection of Persona resources.

        Retrieves the collection of Persona resources.

        :param page: The collection page number
        :type page: int
        :param first_name: 
        :type first_name: str
        :param last_name: 
        :type last_name: str
        :param email: 
        :type email: str
        :param email2: 
        :type email2: List[str]
        :param mobile_phone_number: 
        :type mobile_phone_number: str
        :param mobile_phone_number2: 
        :type mobile_phone_number2: List[str]
        :param gender: Filter on a specific value of gender
        :type gender: str
        :param gender2: Filter on a limited subset of gender
        :type gender2: List[str]
        :param order_created_at: 
        :type order_created_at: str
        :param created_at_before: 
        :type created_at_before: str
        :param created_at_strictly_before: 
        :type created_at_strictly_before: str
        :param created_at_after: 
        :type created_at_after: str
        :param created_at_strictly_after: 
        :type created_at_strictly_after: str
        :param date_of_birth_before: 
        :type date_of_birth_before: str
        :param date_of_birth_strictly_before: 
        :type date_of_birth_strictly_before: str
        :param date_of_birth_after: 
        :type date_of_birth_after: str
        :param date_of_birth_strictly_after: 
        :type date_of_birth_strictly_after: str
        :param metadata: Flattened OrderedMap for metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.
        :type metadata: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_get_collection_serialize(
            page=page,
            first_name=first_name,
            last_name=last_name,
            email=email,
            email2=email2,
            mobile_phone_number=mobile_phone_number,
            mobile_phone_number2=mobile_phone_number2,
            gender=gender,
            gender2=gender2,
            order_created_at=order_created_at,
            created_at_before=created_at_before,
            created_at_strictly_before=created_at_strictly_before,
            created_at_after=created_at_after,
            created_at_strictly_after=created_at_strictly_after,
            date_of_birth_before=date_of_birth_before,
            date_of_birth_strictly_before=date_of_birth_strictly_before,
            date_of_birth_after=date_of_birth_after,
            date_of_birth_strictly_after=date_of_birth_strictly_after,
            metadata=metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[PersonaCollectionRead]",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_personas_get_collection_without_preload_content(
        self,
        page: Annotated[Optional[StrictInt], Field(description="The collection page number")] = None,
        first_name: Optional[StrictStr] = None,
        last_name: Optional[StrictStr] = None,
        email: Optional[StrictStr] = None,
        email2: Optional[List[StrictStr]] = None,
        mobile_phone_number: Optional[StrictStr] = None,
        mobile_phone_number2: Optional[List[StrictStr]] = None,
        gender: Annotated[Optional[StrictStr], Field(description="Filter on a specific value of gender")] = None,
        gender2: Annotated[Optional[List[List[StrictStr]]], Field(description="Filter on a limited subset of gender")] = None,
        order_created_at: Optional[StrictStr] = None,
        created_at_before: Optional[StrictStr] = None,
        created_at_strictly_before: Optional[StrictStr] = None,
        created_at_after: Optional[StrictStr] = None,
        created_at_strictly_after: Optional[StrictStr] = None,
        date_of_birth_before: Optional[StrictStr] = None,
        date_of_birth_strictly_before: Optional[StrictStr] = None,
        date_of_birth_after: Optional[StrictStr] = None,
        date_of_birth_strictly_after: Optional[StrictStr] = None,
        metadata: Annotated[Optional[List[List[StrictStr]]], Field(description="Flattened OrderedMap for metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves the collection of Persona resources.

        Retrieves the collection of Persona resources.

        :param page: The collection page number
        :type page: int
        :param first_name: 
        :type first_name: str
        :param last_name: 
        :type last_name: str
        :param email: 
        :type email: str
        :param email2: 
        :type email2: List[str]
        :param mobile_phone_number: 
        :type mobile_phone_number: str
        :param mobile_phone_number2: 
        :type mobile_phone_number2: List[str]
        :param gender: Filter on a specific value of gender
        :type gender: str
        :param gender2: Filter on a limited subset of gender
        :type gender2: List[str]
        :param order_created_at: 
        :type order_created_at: str
        :param created_at_before: 
        :type created_at_before: str
        :param created_at_strictly_before: 
        :type created_at_strictly_before: str
        :param created_at_after: 
        :type created_at_after: str
        :param created_at_strictly_after: 
        :type created_at_strictly_after: str
        :param date_of_birth_before: 
        :type date_of_birth_before: str
        :param date_of_birth_strictly_before: 
        :type date_of_birth_strictly_before: str
        :param date_of_birth_after: 
        :type date_of_birth_after: str
        :param date_of_birth_strictly_after: 
        :type date_of_birth_strictly_after: str
        :param metadata: Flattened OrderedMap for metadata. Must be a multiple of two items count. Explicitly set \"null\" for desired value.
        :type metadata: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_get_collection_serialize(
            page=page,
            first_name=first_name,
            last_name=last_name,
            email=email,
            email2=email2,
            mobile_phone_number=mobile_phone_number,
            mobile_phone_number2=mobile_phone_number2,
            gender=gender,
            gender2=gender2,
            order_created_at=order_created_at,
            created_at_before=created_at_before,
            created_at_strictly_before=created_at_strictly_before,
            created_at_after=created_at_after,
            created_at_strictly_after=created_at_strictly_after,
            date_of_birth_before=date_of_birth_before,
            date_of_birth_strictly_before=date_of_birth_strictly_before,
            date_of_birth_after=date_of_birth_after,
            date_of_birth_strictly_after=date_of_birth_strictly_after,
            metadata=metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[PersonaCollectionRead]",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_personas_get_collection_serialize(
        self,
        page,
        first_name,
        last_name,
        email,
        email2,
        mobile_phone_number,
        mobile_phone_number2,
        gender,
        gender2,
        order_created_at,
        created_at_before,
        created_at_strictly_before,
        created_at_after,
        created_at_strictly_after,
        date_of_birth_before,
        date_of_birth_strictly_before,
        date_of_birth_after,
        date_of_birth_strictly_after,
        metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'email[]': 'multi',
            'mobilePhoneNumber[]': 'multi',
            'gender[]': 'csv',
            'metadata[]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if first_name is not None:
            
            _query_params.append(('firstName', first_name))
            
        if last_name is not None:
            
            _query_params.append(('lastName', last_name))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if email2 is not None:
            
            _query_params.append(('email[]', email2))
            
        if mobile_phone_number is not None:
            
            _query_params.append(('mobilePhoneNumber', mobile_phone_number))
            
        if mobile_phone_number2 is not None:
            
            _query_params.append(('mobilePhoneNumber[]', mobile_phone_number2))
            
        if gender is not None:
            
            _query_params.append(('gender', gender))
            
        if gender2 is not None:
            
            _query_params.append(('gender[]', gender2))
            
        if order_created_at is not None:
            
            _query_params.append(('order[createdAt]', order_created_at))
            
        if created_at_before is not None:
            
            _query_params.append(('createdAt[before]', created_at_before))
            
        if created_at_strictly_before is not None:
            
            _query_params.append(('createdAt[strictly_before]', created_at_strictly_before))
            
        if created_at_after is not None:
            
            _query_params.append(('createdAt[after]', created_at_after))
            
        if created_at_strictly_after is not None:
            
            _query_params.append(('createdAt[strictly_after]', created_at_strictly_after))
            
        if date_of_birth_before is not None:
            
            _query_params.append(('dateOfBirth[before]', date_of_birth_before))
            
        if date_of_birth_strictly_before is not None:
            
            _query_params.append(('dateOfBirth[strictly_before]', date_of_birth_strictly_before))
            
        if date_of_birth_after is not None:
            
            _query_params.append(('dateOfBirth[after]', date_of_birth_after))
            
        if date_of_birth_strictly_after is not None:
            
            _query_params.append(('dateOfBirth[strictly_after]', date_of_birth_strictly_after))
            
        if metadata is not None:
            
            _query_params.append(('metadata[]', metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'jwtPersonalKey', 
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/personas',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_personas_id_delete(
        self,
        id: Annotated[StrictStr, Field(description="Persona identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Unregister a Persona (Your customer)

        You **MAY** unregister (or free the email/phone number) your Persona entry using that endpoint. *Please note that* this operation will fail if that Persona have any ongoing operations.

        :param id: Persona identifier (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_id_delete_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_personas_id_delete_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Persona identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Unregister a Persona (Your customer)

        You **MAY** unregister (or free the email/phone number) your Persona entry using that endpoint. *Please note that* this operation will fail if that Persona have any ongoing operations.

        :param id: Persona identifier (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_id_delete_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_personas_id_delete_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Persona identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Unregister a Persona (Your customer)

        You **MAY** unregister (or free the email/phone number) your Persona entry using that endpoint. *Please note that* this operation will fail if that Persona have any ongoing operations.

        :param id: Persona identifier (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_id_delete_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_personas_id_delete_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'jwtPersonalKey', 
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/personas/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_personas_id_get(
        self,
        id: Annotated[StrictStr, Field(description="Persona identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PersonaRead:
        """Retrieves a Persona resource.

        Retrieves a Persona resource.

        :param id: Persona identifier (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_id_get_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PersonaRead",
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_personas_id_get_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Persona identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PersonaRead]:
        """Retrieves a Persona resource.

        Retrieves a Persona resource.

        :param id: Persona identifier (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_id_get_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PersonaRead",
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_personas_id_get_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Persona identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves a Persona resource.

        Retrieves a Persona resource.

        :param id: Persona identifier (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_id_get_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PersonaRead",
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_personas_id_get_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'jwtPersonalKey', 
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/personas/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_personas_id_patch(
        self,
        id: Annotated[StrictStr, Field(description="Persona identifier")],
        persona_update: Annotated[PersonaUpdate, Field(description="The updated Persona resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PersonaRead:
        """Updates the Persona resource.

        Update your Persona (eg. your customer/user entry) through that API call. _Beware that updating_ **email** and/or the **mobile phone number** must be done using non reserved values. Otherwise this operation will be rejected.

        :param id: Persona identifier (required)
        :type id: str
        :param persona_update: The updated Persona resource (required)
        :type persona_update: PersonaUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_id_patch_serialize(
            id=id,
            persona_update=persona_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PersonaRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_personas_id_patch_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Persona identifier")],
        persona_update: Annotated[PersonaUpdate, Field(description="The updated Persona resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PersonaRead]:
        """Updates the Persona resource.

        Update your Persona (eg. your customer/user entry) through that API call. _Beware that updating_ **email** and/or the **mobile phone number** must be done using non reserved values. Otherwise this operation will be rejected.

        :param id: Persona identifier (required)
        :type id: str
        :param persona_update: The updated Persona resource (required)
        :type persona_update: PersonaUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_id_patch_serialize(
            id=id,
            persona_update=persona_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PersonaRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_personas_id_patch_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Persona identifier")],
        persona_update: Annotated[PersonaUpdate, Field(description="The updated Persona resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Updates the Persona resource.

        Update your Persona (eg. your customer/user entry) through that API call. _Beware that updating_ **email** and/or the **mobile phone number** must be done using non reserved values. Otherwise this operation will be rejected.

        :param id: Persona identifier (required)
        :type id: str
        :param persona_update: The updated Persona resource (required)
        :type persona_update: PersonaUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_id_patch_serialize(
            id=id,
            persona_update=persona_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PersonaRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '404': "NotFoundError",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_personas_id_patch_serialize(
        self,
        id,
        persona_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if persona_update is not None:
            _body_params = persona_update


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'jwtPersonalKey', 
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/personas/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_personas_post(
        self,
        persona_write: Annotated[PersonaWrite, Field(description="The new Persona resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PersonaRead:
        """Register a Persona (Your customer)

        You should not register your whole database of users, only those who are concerned by a Transaction operation. One Persona entry for your organization can be assigned as a seller or buyer.  **Notes:**   - (i) There is a unique constraint for the mobile phone numbers and email.   - (ii) You will have to issue a DELETE operation on a Persona that withhold a specific phone number or email.   - (iii) You are NOT REQUIRED to provide email OR a mobile phone number but it is highly recommended, if none provided the email will be generated as '{ulid}@your-domain.tld'. In that case, please specify at least one metadata in order to find your entry with ease.

        :param persona_write: The new Persona resource (required)
        :type persona_write: PersonaWrite
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_post_serialize(
            persona_write=persona_write,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PersonaRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_personas_post_with_http_info(
        self,
        persona_write: Annotated[PersonaWrite, Field(description="The new Persona resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PersonaRead]:
        """Register a Persona (Your customer)

        You should not register your whole database of users, only those who are concerned by a Transaction operation. One Persona entry for your organization can be assigned as a seller or buyer.  **Notes:**   - (i) There is a unique constraint for the mobile phone numbers and email.   - (ii) You will have to issue a DELETE operation on a Persona that withhold a specific phone number or email.   - (iii) You are NOT REQUIRED to provide email OR a mobile phone number but it is highly recommended, if none provided the email will be generated as '{ulid}@your-domain.tld'. In that case, please specify at least one metadata in order to find your entry with ease.

        :param persona_write: The new Persona resource (required)
        :type persona_write: PersonaWrite
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_post_serialize(
            persona_write=persona_write,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PersonaRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_personas_post_without_preload_content(
        self,
        persona_write: Annotated[PersonaWrite, Field(description="The new Persona resource")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Register a Persona (Your customer)

        You should not register your whole database of users, only those who are concerned by a Transaction operation. One Persona entry for your organization can be assigned as a seller or buyer.  **Notes:**   - (i) There is a unique constraint for the mobile phone numbers and email.   - (ii) You will have to issue a DELETE operation on a Persona that withhold a specific phone number or email.   - (iii) You are NOT REQUIRED to provide email OR a mobile phone number but it is highly recommended, if none provided the email will be generated as '{ulid}@your-domain.tld'. In that case, please specify at least one metadata in order to find your entry with ease.

        :param persona_write: The new Persona resource (required)
        :type persona_write: PersonaWrite
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_personas_post_serialize(
            persona_write=persona_write,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PersonaRead",
            '400': "InvalidQueryError",
            '422': "UnprocessableEntity",
            '401': "AuthError",
            '403': "AccessError",
            '429': "RateLimitError",
            '500': "GenericError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_personas_post_serialize(
        self,
        persona_write,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if persona_write is not None:
            _body_params = persona_write


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/personas',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


