# tpdk-safe-checkout
Simple, yet elegant web interfaces for your convenience. One request away from your first secured C2C transaction.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0.54
- Package version: 2.0.54
- Generator version: 7.8.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://tripartie.com](https://tripartie.com)

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/tripartie/tpdk-safe-checkout.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/tripartie/tpdk-safe-checkout.git`)

Then import the package:
```python
import tpdk_safe_checkout
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import tpdk_safe_checkout
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import tpdk_safe_checkout
from tpdk_safe_checkout.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://staging-api.tripartie.app
# See configuration.py for a list of all supported configuration parameters.
configuration = tpdk_safe_checkout.Configuration(
    host = "https://staging-api.tripartie.app"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: jwtPersonalKey
configuration.api_key['jwtPersonalKey'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['jwtPersonalKey'] = 'Bearer'


# Enter a context with an instance of the API client
with tpdk_safe_checkout.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = tpdk_safe_checkout.AdminApi(api_client)
    page = 1 # int | The collection page number (optional) (default to 1)

    try:
        # Retrieves the collection of ApiClient resources.
        api_response = api_instance.api_api_clients_get_collection(page=page)
        print("The response of AdminApi->api_api_clients_get_collection:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AdminApi->api_api_clients_get_collection: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://staging-api.tripartie.app*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminApi* | [**api_api_clients_get_collection**](docs/AdminApi.md#api_api_clients_get_collection) | **GET** /api-clients | Retrieves the collection of ApiClient resources.
*AdminApi* | [**api_api_clients_identifier_delete**](docs/AdminApi.md#api_api_clients_identifier_delete) | **DELETE** /api-clients/{identifier} | Removes the ApiClient resource.
*AdminApi* | [**api_api_clients_identifier_get**](docs/AdminApi.md#api_api_clients_identifier_get) | **GET** /api-clients/{identifier} | Retrieves a ApiClient resource.
*AdminApi* | [**api_api_clients_post**](docs/AdminApi.md#api_api_clients_post) | **POST** /api-clients | Creates a ApiClient resource.
*AdminApi* | [**api_invite_post**](docs/AdminApi.md#api_invite_post) | **POST** /invite | Organization invite
*AdminApi* | [**api_organizations_get_collection**](docs/AdminApi.md#api_organizations_get_collection) | **GET** /organizations | Retrieves the collection of Organization resources.
*AdminApi* | [**api_organizations_id_get**](docs/AdminApi.md#api_organizations_id_get) | **GET** /organizations/{id} | Retrieves a Organization resource.
*AdminApi* | [**api_users_get_collection**](docs/AdminApi.md#api_users_get_collection) | **GET** /users | Retrieves the collection of User resources.
*AdminApi* | [**api_users_id_get**](docs/AdminApi.md#api_users_id_get) | **GET** /users/{id} | Retrieves a User resource.
*AdminApi* | [**api_users_iddisable_patch**](docs/AdminApi.md#api_users_iddisable_patch) | **PATCH** /users/{id}/disable | Updates the User resource.
*AdminApi* | [**api_users_idenable_patch**](docs/AdminApi.md#api_users_idenable_patch) | **PATCH** /users/{id}/enable | Updates the User resource.
*AdminApi* | [**authentication_post**](docs/AdminApi.md#authentication_post) | **POST** /authentication | User authentication
*BrandingApi* | [**api_organizations_id_patch**](docs/BrandingApi.md#api_organizations_id_patch) | **PATCH** /organizations/{id} | Update your Organization details, branding or parameters
*BrandingApi* | [**api_organizations_idicon_delete**](docs/BrandingApi.md#api_organizations_idicon_delete) | **DELETE** /organizations/{id}/icon | Unset your Organization Icon
*BrandingApi* | [**api_organizations_idicon_post**](docs/BrandingApi.md#api_organizations_idicon_post) | **POST** /organizations/{id}/icon | Upload your Organization Icon
*BrandingApi* | [**api_organizations_idlogo_delete**](docs/BrandingApi.md#api_organizations_idlogo_delete) | **DELETE** /organizations/{id}/logo | Unset your Organization Logo
*BrandingApi* | [**api_organizations_idlogo_post**](docs/BrandingApi.md#api_organizations_idlogo_post) | **POST** /organizations/{id}/logo | Upload your Organization logo
*PersonaApi* | [**api_personas_get_collection**](docs/PersonaApi.md#api_personas_get_collection) | **GET** /personas | Retrieves the collection of Persona resources.
*PersonaApi* | [**api_personas_id_delete**](docs/PersonaApi.md#api_personas_id_delete) | **DELETE** /personas/{id} | Unregister a Persona (Your customer)
*PersonaApi* | [**api_personas_id_get**](docs/PersonaApi.md#api_personas_id_get) | **GET** /personas/{id} | Retrieves a Persona resource.
*PersonaApi* | [**api_personas_id_patch**](docs/PersonaApi.md#api_personas_id_patch) | **PATCH** /personas/{id} | Updates the Persona resource.
*PersonaApi* | [**api_personas_post**](docs/PersonaApi.md#api_personas_post) | **POST** /personas | Register a Persona (Your customer)
*SafeCheckoutApi* | [**api_offers_get_collection**](docs/SafeCheckoutApi.md#api_offers_get_collection) | **GET** /offers | Search amongst Offers
*SafeCheckoutApi* | [**api_offers_post**](docs/SafeCheckoutApi.md#api_offers_post) | **POST** /offers | Create a public link for Offer
*SafeCheckoutApi* | [**api_offers_ulid_delete**](docs/SafeCheckoutApi.md#api_offers_ulid_delete) | **DELETE** /offers/{ulid} | Disable existing Offer
*SafeCheckoutApi* | [**api_offers_ulid_get**](docs/SafeCheckoutApi.md#api_offers_ulid_get) | **GET** /offers/{ulid} | Fetch a Offer details
*SafeCheckoutApi* | [**api_offers_ulid_patch**](docs/SafeCheckoutApi.md#api_offers_ulid_patch) | **PATCH** /offers/{ulid} | Update existing Offer
*SafeCheckoutApi* | [**api_offers_ulidmedias_id_delete**](docs/SafeCheckoutApi.md#api_offers_ulidmedias_id_delete) | **DELETE** /offers/{ulid}/medias/{id} | Removes the Media resource.
*SafeCheckoutApi* | [**api_offers_ulidmedias_post**](docs/SafeCheckoutApi.md#api_offers_ulidmedias_post) | **POST** /offers/{ulid}/medias | Upload a picture for a given Offer
*SafeCheckoutApi* | [**api_users_idoffers_post**](docs/SafeCheckoutApi.md#api_users_idoffers_post) | **POST** /users/{id}/offers | Issue an Offer as User
*TransactionApi* | [**api_quotes_id_get**](docs/TransactionApi.md#api_quotes_id_get) | **GET** /quotes/{id} | Retrieve a Quote
*TransactionApi* | [**api_quotes_id_patch**](docs/TransactionApi.md#api_quotes_id_patch) | **PATCH** /quotes/{id} | Update a Quote prior to issuing a Transaction
*TransactionApi* | [**api_quotes_post**](docs/TransactionApi.md#api_quotes_post) | **POST** /quotes | Create a Quote prior to issuing a Transaction
*TransactionApi* | [**api_transactions_get_collection**](docs/TransactionApi.md#api_transactions_get_collection) | **GET** /transactions | List all Transaction
*TransactionApi* | [**api_transactions_post**](docs/TransactionApi.md#api_transactions_post) | **POST** /transactions | Initialize a new Transaction
*TransactionApi* | [**api_transactions_ulid_get**](docs/TransactionApi.md#api_transactions_ulid_get) | **GET** /transactions/{ulid} | Get a Transaction
*TransactionApi* | [**api_transactions_ulid_patch**](docs/TransactionApi.md#api_transactions_ulid_patch) | **PATCH** /transactions/{ulid} | Interact with a Transaction
*UserApi* | [**api_bank_accounts_id_delete**](docs/UserApi.md#api_bank_accounts_id_delete) | **DELETE** /bank-accounts/{id} | Removes the BankAccount resource.
*UserApi* | [**api_bank_accounts_id_get**](docs/UserApi.md#api_bank_accounts_id_get) | **GET** /bank-accounts/{id} | Retrieves a BankAccount resource.
*UserApi* | [**api_bank_accounts_post**](docs/UserApi.md#api_bank_accounts_post) | **POST** /bank-accounts | Creates a BankAccount resource.
*UserApi* | [**api_cards_get_collection**](docs/UserApi.md#api_cards_get_collection) | **GET** /cards | Retrieves the collection of Card resources.
*UserApi* | [**api_cards_id_delete**](docs/UserApi.md#api_cards_id_delete) | **DELETE** /cards/{id} | Removes the Card resource.
*UserApi* | [**api_cards_id_get**](docs/UserApi.md#api_cards_id_get) | **GET** /cards/{id} | Retrieves a Card resource.
*UserApi* | [**api_cards_id_patch**](docs/UserApi.md#api_cards_id_patch) | **PATCH** /cards/{id} | Push back the tokenization output from the external provider
*UserApi* | [**api_cards_post**](docs/UserApi.md#api_cards_post) | **POST** /cards | Creates a Card resource.
*UserApi* | [**api_cash_outs_get_collection**](docs/UserApi.md#api_cash_outs_get_collection) | **GET** /cash-outs | Retrieves the collection of CashOut resources.
*UserApi* | [**api_cash_outs_id_get**](docs/UserApi.md#api_cash_outs_id_get) | **GET** /cash-outs/{id} | Retrieves a CashOut resource.
*UserApi* | [**api_cash_outs_post**](docs/UserApi.md#api_cash_outs_post) | **POST** /cash-outs | Withdraw the full amount available in the user wallet to set bank account
*UserApi* | [**api_me_get**](docs/UserApi.md#api_me_get) | **GET** /me | Retrieves a User resource.
*UserApi* | [**api_proof_of_identities_get_collection**](docs/UserApi.md#api_proof_of_identities_get_collection) | **GET** /proof-of-identities | List all submitted PoI
*UserApi* | [**api_proof_of_identities_id_get**](docs/UserApi.md#api_proof_of_identities_id_get) | **GET** /proof-of-identities/{id} | Retrieve a specific PoI
*UserApi* | [**api_proof_of_identities_iddocument_post**](docs/UserApi.md#api_proof_of_identities_iddocument_post) | **POST** /proof-of-identities/{id}/document | Upload the document for your PoI slot
*UserApi* | [**api_proof_of_identities_post**](docs/UserApi.md#api_proof_of_identities_post) | **POST** /proof-of-identities | Submit a slot for a PoI
*UserApi* | [**api_register_post**](docs/UserApi.md#api_register_post) | **POST** /register | Customer onboarding
*UserApi* | [**api_users_id_delete**](docs/UserApi.md#api_users_id_delete) | **DELETE** /users/{id} | Removes the User resource.
*UserApi* | [**api_users_id_patch**](docs/UserApi.md#api_users_id_patch) | **PATCH** /users/{id} | Update your profile
*UserApi* | [**api_users_idavatar_delete**](docs/UserApi.md#api_users_idavatar_delete) | **DELETE** /users/{id}/avatar | Unset your personal avatar
*UserApi* | [**api_users_idavatar_post**](docs/UserApi.md#api_users_idavatar_post) | **POST** /users/{id}/avatar | Upload your personal avatar
*UserApi* | [**api_users_idemail_patch**](docs/UserApi.md#api_users_idemail_patch) | **PATCH** /users/{id}/email | Update user email
*UserApi* | [**api_users_idemail_validation_patch**](docs/UserApi.md#api_users_idemail_validation_patch) | **PATCH** /users/{id}/email-validation | Validate email ownership
*UserApi* | [**api_users_idpassword_patch**](docs/UserApi.md#api_users_idpassword_patch) | **PATCH** /users/{id}/password | Change your password
*UserApi* | [**api_users_idtotp_setup_patch**](docs/UserApi.md#api_users_idtotp_setup_patch) | **PATCH** /users/{id}/totp-setup | Setup an additional authentication factor
*UserApi* | [**api_users_idtotp_toggle_patch**](docs/UserApi.md#api_users_idtotp_toggle_patch) | **PATCH** /users/{id}/totp-toggle | Disable the second authentication factor
*UserApi* | [**authentication_post**](docs/UserApi.md#authentication_post) | **POST** /authentication | User authentication
*WebhookApi* | [**api_webhook_histories_get_collection**](docs/WebhookApi.md#api_webhook_histories_get_collection) | **GET** /webhook-histories | Retrieves the collection of WebhookHistory resources.
*WebhookApi* | [**api_webhook_histories_id_get**](docs/WebhookApi.md#api_webhook_histories_id_get) | **GET** /webhook-histories/{id} | Retrieves a WebhookHistory resource.
*WebhookApi* | [**api_webhook_histories_id_put**](docs/WebhookApi.md#api_webhook_histories_id_put) | **PUT** /webhook-histories/{id} | Replay a Webhook that ended up in failure
*WebhookApi* | [**api_webhook_subscriptions_get_collection**](docs/WebhookApi.md#api_webhook_subscriptions_get_collection) | **GET** /webhook-subscriptions | Retrieves the collection of WebhookSubscription resources.
*WebhookApi* | [**api_webhook_subscriptions_id_delete**](docs/WebhookApi.md#api_webhook_subscriptions_id_delete) | **DELETE** /webhook-subscriptions/{id} | Removes the WebhookSubscription resource.
*WebhookApi* | [**api_webhook_subscriptions_post**](docs/WebhookApi.md#api_webhook_subscriptions_post) | **POST** /webhook-subscriptions | Subscribe to Event(s)


## Documentation For Models

 - [AccessError](docs/AccessError.md)
 - [Address](docs/Address.md)
 - [AddressUserRead](docs/AddressUserRead.md)
 - [ApiClientPostCreationRead](docs/ApiClientPostCreationRead.md)
 - [ApiClientRead](docs/ApiClientRead.md)
 - [ApiClientWrite](docs/ApiClientWrite.md)
 - [AuthError](docs/AuthError.md)
 - [BankAccountRead](docs/BankAccountRead.md)
 - [BankAccountUserRead](docs/BankAccountUserRead.md)
 - [BankAccountWrite](docs/BankAccountWrite.md)
 - [CardCollectionRead](docs/CardCollectionRead.md)
 - [CardMetadataCollectionRead](docs/CardMetadataCollectionRead.md)
 - [CardMetadataRead](docs/CardMetadataRead.md)
 - [CardMetadataUpdate](docs/CardMetadataUpdate.md)
 - [CardRead](docs/CardRead.md)
 - [CardUpdate](docs/CardUpdate.md)
 - [CardUserRead](docs/CardUserRead.md)
 - [CardWrite](docs/CardWrite.md)
 - [CashoutCashOutCollectionRead](docs/CashoutCashOutCollectionRead.md)
 - [CashoutCashOutRead](docs/CashoutCashOutRead.md)
 - [CashoutCashOutWrite](docs/CashoutCashOutWrite.md)
 - [GenericError](docs/GenericError.md)
 - [InvalidQueryError](docs/InvalidQueryError.md)
 - [Media](docs/Media.md)
 - [MediaRead](docs/MediaRead.md)
 - [MediaUserRead](docs/MediaUserRead.md)
 - [MessageError](docs/MessageError.md)
 - [Metadata](docs/Metadata.md)
 - [NotFoundError](docs/NotFoundError.md)
 - [Offer](docs/Offer.md)
 - [OfferAddressIndependentWrite](docs/OfferAddressIndependentWrite.md)
 - [OfferCollectionRead](docs/OfferCollectionRead.md)
 - [OfferIndependentWrite](docs/OfferIndependentWrite.md)
 - [OfferMediaCollectionRead](docs/OfferMediaCollectionRead.md)
 - [OfferMediaRead](docs/OfferMediaRead.md)
 - [OfferMetadataIndependentWrite](docs/OfferMetadataIndependentWrite.md)
 - [OfferMetadataUpdate](docs/OfferMetadataUpdate.md)
 - [OfferOrganizationCollectionRead](docs/OfferOrganizationCollectionRead.md)
 - [OfferOrganizationRead](docs/OfferOrganizationRead.md)
 - [OfferPersonaIndependentWrite](docs/OfferPersonaIndependentWrite.md)
 - [OfferPersonaRead](docs/OfferPersonaRead.md)
 - [OfferPostCreationRead](docs/OfferPostCreationRead.md)
 - [OfferRead](docs/OfferRead.md)
 - [OfferSoloWrite](docs/OfferSoloWrite.md)
 - [OfferUpdate](docs/OfferUpdate.md)
 - [OrganizationAddressUpdate](docs/OrganizationAddressUpdate.md)
 - [OrganizationCollectionRead](docs/OrganizationCollectionRead.md)
 - [OrganizationMediaCollectionRead](docs/OrganizationMediaCollectionRead.md)
 - [OrganizationMediaRead](docs/OrganizationMediaRead.md)
 - [OrganizationRead](docs/OrganizationRead.md)
 - [OrganizationUpdate](docs/OrganizationUpdate.md)
 - [OrganizationUserRead](docs/OrganizationUserRead.md)
 - [Persona](docs/Persona.md)
 - [PersonaAddressRead](docs/PersonaAddressRead.md)
 - [PersonaAddressUpdate](docs/PersonaAddressUpdate.md)
 - [PersonaAddressWrite](docs/PersonaAddressWrite.md)
 - [PersonaCollectionRead](docs/PersonaCollectionRead.md)
 - [PersonaMetadataRead](docs/PersonaMetadataRead.md)
 - [PersonaMetadataUpdate](docs/PersonaMetadataUpdate.md)
 - [PersonaMetadataWrite](docs/PersonaMetadataWrite.md)
 - [PersonaRead](docs/PersonaRead.md)
 - [PersonaUpdate](docs/PersonaUpdate.md)
 - [PersonaUserRead](docs/PersonaUserRead.md)
 - [PersonaWrite](docs/PersonaWrite.md)
 - [ProofOfIdentityCollectionRead](docs/ProofOfIdentityCollectionRead.md)
 - [ProofOfIdentityRead](docs/ProofOfIdentityRead.md)
 - [ProofOfIdentityWrite](docs/ProofOfIdentityWrite.md)
 - [QuoteAddressRead](docs/QuoteAddressRead.md)
 - [QuoteAddressUpdate](docs/QuoteAddressUpdate.md)
 - [QuoteAddressWrite](docs/QuoteAddressWrite.md)
 - [QuoteRead](docs/QuoteRead.md)
 - [QuoteUpdate](docs/QuoteUpdate.md)
 - [QuoteWrite](docs/QuoteWrite.md)
 - [RateLimitError](docs/RateLimitError.md)
 - [TransactionAddressRead](docs/TransactionAddressRead.md)
 - [TransactionCardRead](docs/TransactionCardRead.md)
 - [TransactionCollectionRead](docs/TransactionCollectionRead.md)
 - [TransactionMediaCollectionRead](docs/TransactionMediaCollectionRead.md)
 - [TransactionMediaRead](docs/TransactionMediaRead.md)
 - [TransactionMetadataRead](docs/TransactionMetadataRead.md)
 - [TransactionOfferCollectionRead](docs/TransactionOfferCollectionRead.md)
 - [TransactionOfferRead](docs/TransactionOfferRead.md)
 - [TransactionOrganizationCollectionRead](docs/TransactionOrganizationCollectionRead.md)
 - [TransactionOrganizationRead](docs/TransactionOrganizationRead.md)
 - [TransactionParcelRead](docs/TransactionParcelRead.md)
 - [TransactionPersonaCollectionRead](docs/TransactionPersonaCollectionRead.md)
 - [TransactionPersonaRead](docs/TransactionPersonaRead.md)
 - [TransactionQuoteCollectionRead](docs/TransactionQuoteCollectionRead.md)
 - [TransactionQuoteRead](docs/TransactionQuoteRead.md)
 - [TransactionRead](docs/TransactionRead.md)
 - [TransactionUpdate](docs/TransactionUpdate.md)
 - [TransactionWalletRead](docs/TransactionWalletRead.md)
 - [TransactionWrite](docs/TransactionWrite.md)
 - [UnprocessableEntity](docs/UnprocessableEntity.md)
 - [UnprocessableEntityViolationsInner](docs/UnprocessableEntityViolationsInner.md)
 - [UserAddressAuthenticatedRead](docs/UserAddressAuthenticatedRead.md)
 - [UserAddressCollectionRead](docs/UserAddressCollectionRead.md)
 - [UserAddressSupportRead](docs/UserAddressSupportRead.md)
 - [UserAddressUpdate](docs/UserAddressUpdate.md)
 - [UserAuthenticatedRead](docs/UserAuthenticatedRead.md)
 - [UserBankAccountAuthenticatedRead](docs/UserBankAccountAuthenticatedRead.md)
 - [UserCardAuthenticatedRead](docs/UserCardAuthenticatedRead.md)
 - [UserCollectionRead](docs/UserCollectionRead.md)
 - [UserEmailValidationWrite](docs/UserEmailValidationWrite.md)
 - [UserInvite](docs/UserInvite.md)
 - [UserJwtCreated](docs/UserJwtCreated.md)
 - [UserJwtWrite](docs/UserJwtWrite.md)
 - [UserMediaAuthenticatedRead](docs/UserMediaAuthenticatedRead.md)
 - [UserMediaCollectionRead](docs/UserMediaCollectionRead.md)
 - [UserMediaRead](docs/UserMediaRead.md)
 - [UserMediaSupportRead](docs/UserMediaSupportRead.md)
 - [UserOrganizationAuthenticatedRead](docs/UserOrganizationAuthenticatedRead.md)
 - [UserOrganizationCollectionRead](docs/UserOrganizationCollectionRead.md)
 - [UserOrganizationRead](docs/UserOrganizationRead.md)
 - [UserOrganizationSupportRead](docs/UserOrganizationSupportRead.md)
 - [UserPersonaAuthenticatedRead](docs/UserPersonaAuthenticatedRead.md)
 - [UserPostRegisterRead](docs/UserPostRegisterRead.md)
 - [UserSupportRead](docs/UserSupportRead.md)
 - [UserTotpSetupRead](docs/UserTotpSetupRead.md)
 - [UserTotpToggleWrite](docs/UserTotpToggleWrite.md)
 - [UserUpdate](docs/UserUpdate.md)
 - [UserUserEmailUpdate](docs/UserUserEmailUpdate.md)
 - [UserUserPasswordUpdate](docs/UserUserPasswordUpdate.md)
 - [UserUserRead](docs/UserUserRead.md)
 - [UserUserSubscribed](docs/UserUserSubscribed.md)
 - [UserWalletAuthenticatedRead](docs/UserWalletAuthenticatedRead.md)
 - [UserWalletCollectionRead](docs/UserWalletCollectionRead.md)
 - [UserWalletSupportRead](docs/UserWalletSupportRead.md)
 - [UserWrite](docs/UserWrite.md)
 - [View](docs/View.md)
 - [WalletUserRead](docs/WalletUserRead.md)
 - [Webhook](docs/Webhook.md)
 - [WebhookHistoryCollectionRead](docs/WebhookHistoryCollectionRead.md)
 - [WebhookHistoryRead](docs/WebhookHistoryRead.md)
 - [WebhookObject](docs/WebhookObject.md)
 - [WebhookSubscriptionRead](docs/WebhookSubscriptionRead.md)
 - [WebhookSubscriptionWrite](docs/WebhookSubscriptionWrite.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="oauth"></a>
### oauth

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **OFFER_READ**: Read-only operations on safe-checkout offers
 - **OFFER_WRITE**: Write permissions on safe-checkout offers
 - **ORGANIZATION_READ**: Read organization details and stats
 - **PERSONA_READ**: Read operations on the shared user-base knowledge
 - **PERSONA_WRITE**: Write permissions on the shared user-base knowledge
 - **PERSONA_AUTH**: Capability to issue short-term lived authenticated URL

<a id="jwtPersonalKey"></a>
### jwtPersonalKey

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

noc@tripartie.com


