/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.LongAddable;
import com.google.common.cache.Striped64;
import java.io.Serializable;

final class LongAdder
extends Striped64
implements LongAddable,
Serializable {
    @Override
    final long fn(long v, long x) {
        return v + x;
    }

    @Override
    public void add(long x) {
        long b;
        Striped64.Cell[] as = this.cells;
        if (this.cells != null || !this.casBase(b = this.base, b + x)) {
            long v;
            Striped64.Cell a;
            int n;
            boolean uncontended = true;
            int[] hc = (int[])threadHashCode.get();
            if (hc == null || as == null || (n = as.length) < 1 || (a = as[n - 1 & hc[0]]) == null || !(uncontended = a.cas(v = a.value, v + x))) {
                this.retryUpdate(x, hc, uncontended);
            }
        }
    }

    @Override
    public void increment() {
        this.add(1L);
    }

    public long sum() {
        long sum = this.base;
        Striped64.Cell[] as = this.cells;
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                sum += a.value;
            }
        }
        return sum;
    }

    public String toString() {
        return Long.toString(this.sum());
    }

    @Override
    public long longValue() {
        return this.sum();
    }

    @Override
    public int intValue() {
        return (int)this.sum();
    }

    @Override
    public float floatValue() {
        return this.sum();
    }

    @Override
    public double doubleValue() {
        return this.sum();
    }
}

