"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpAlbIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("aws-cdk-lib/aws-elasticloadbalancingv2");
const integration_1 = require("./private/integration");
/**
 * The Application Load Balancer integration resource for HTTP API
 */
class HttpAlbIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param listener the ELB application listener
     * @param props properties to configure the integration
     */
    constructor(id, listener, props = {}) {
        super(id);
        this.listener = listener;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpAlbIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpAlbIntegration);
            }
            throw error;
        }
    }
    bind(options) {
        let vpc = this.props.vpcLink?.vpc;
        if (!vpc && (this.listener instanceof elbv2.ApplicationListener)) {
            vpc = this.listener.loadBalancer.vpc;
        }
        if (!vpc) {
            throw new Error('The vpcLink property must be specified when using an imported Application Listener.');
        }
        const vpcLink = this._configureVpcLink(options, {
            vpcLink: this.props.vpcLink,
            vpc,
        });
        return {
            method: this.props.method ?? this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: vpcLink.vpcLinkId,
            uri: this.listener.listenerArn,
            secureServerName: this.props.secureServerName,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpAlbIntegration = HttpAlbIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpAlbIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpAlbIntegration", version: "2.59.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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