/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.loader.gaussian;

import com.cmayes.common.chem.AtomicElement;
import com.cmayes.common.model.Atom;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.antlr.runtime.tree.CommonTree;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseGaussianLoader {
    public static final int ATOM_COL_COUNT = 6;
    public static final int SEC_IDX = 3;
    public static final int MIN_IDX = 2;
    public static final int HOUR_IDX = 1;
    public static final int DAY_IDX = 0;
    public static final String TERM_DATE_PAT = "E MMM dd HH:mm:ss yyyy";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected void handleAtom(String nodeText, Atom curAtom, int atomColCount) {
        switch (atomColCount % 6) {
            case 0: {
                curAtom.setId(this.toInt(nodeText));
                break;
            }
            case 1: {
                curAtom.setType(AtomicElement.valueOf(this.toInt(nodeText)));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                curAtom.setX(this.toDouble(nodeText));
                break;
            }
            case 4: {
                curAtom.setY(this.toDouble(nodeText));
                break;
            }
            case 5: {
                curAtom.setZ(this.toDouble(nodeText));
                break;
            }
            default: {
                this.logger.warn("Unlikely atom mod %d", (Object)atomColCount);
            }
        }
    }

    protected Integer toInt(String strVal) {
        try {
            return Integer.valueOf(strVal);
        }
        catch (NumberFormatException e) {
            this.logger.warn("Couldn't parse integer " + strVal);
            return null;
        }
    }

    protected Double toDouble(String strVal) {
        try {
            String properSciNot = strVal.replace('D', 'E');
            return Double.valueOf(properSciNot);
        }
        catch (NumberFormatException e) {
            this.logger.warn("Couldn't parse double " + strVal);
            return null;
        }
    }

    protected Date processTermDate(CommonTree curNode) {
        String rawDate = null;
        try {
            rawDate = curNode.getChild(0).getText();
            return new SimpleDateFormat(TERM_DATE_PAT).parse(rawDate);
        }
        catch (ParseException e) {
            this.logger.warn(String.format("Parse exception on date %s", rawDate));
            return null;
        }
    }

    protected Duration processCpuTime(CommonTree curNode) {
        try {
            Duration dur = Duration.standardDays(Long.valueOf(curNode.getChild(0).getText())).plus(Duration.standardHours(Long.valueOf(curNode.getChild(1).getText()))).plus(Duration.standardMinutes(Long.valueOf(curNode.getChild(2).getText())));
            BigDecimal seconds = new BigDecimal(curNode.getChild(3).getText());
            BigDecimal millis = seconds.multiply(new BigDecimal(1000));
            return dur.plus(Duration.millis(millis.longValue()));
        }
        catch (NumberFormatException e) {
            this.logger.warn("Problems processing numbers for CPU time", e);
            return null;
        }
    }
}

