/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.calc.impl;

import com.cmayes.common.chem.AtomicElement;
import com.cmayes.common.exception.NotFoundException;
import com.cmayes.common.exception.TooManyException;
import com.cmayes.common.model.Atom;
import com.cmayes.common.util.ChemUtils;
import java.util.ArrayList;
import java.util.List;
import org.cmayes.hartree.calc.Calculation;
import org.cmayes.hartree.model.def.CpCalculationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IonDistanceCalculation
implements Calculation {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicElement ionTarget;

    public IonDistanceCalculation(AtomicElement tgtType) {
        this.ionTarget = tgtType;
    }

    @Override
    public Object calculate(Object rawInput) {
        if (rawInput instanceof CpCalculationSnapshot) {
            CpCalculationSnapshot cpSnap = new CpCalculationSnapshot((CpCalculationSnapshot)rawInput);
            try {
                Atom ionAtom = ChemUtils.findSingle(this.ionTarget, cpSnap.getAtoms());
                this.fillIonDistances(cpSnap, ionAtom);
            }
            catch (NotFoundException e) {
                this.logger.info("Could not find ion atom of type {}.  Skipping distance calc.", (Object)this.ionTarget.name(), (Object)e);
            }
            catch (TooManyException e) {
                this.logger.info("Found too many atoms of type {}.  Skipping distance calc.", (Object)this.ionTarget.name(), (Object)e);
            }
            return cpSnap;
        }
        throw new IllegalArgumentException(String.format("Unhandled class '%s'", rawInput.getClass()));
    }

    private void fillIonDistances(CpCalculationSnapshot cpSnap, Atom ion) {
        List<Atom> oxygens = cpSnap.getOxygenAtoms();
        ArrayList<Double> ionDistances = new ArrayList<Double>(6);
        for (Atom oxyAtom : oxygens) {
            if (oxyAtom == null) continue;
            ionDistances.add(ChemUtils.findDistance(ion, oxyAtom));
        }
        cpSnap.setIonDistances(ionDistances);
    }
}

