/*
 * Decompiled with CFR 0.152.
 */
package com.cmayes.common.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptServletFilter
implements Filter {
    public static final String ACCEPT_KEY = "accept";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, String> map = new HashMap<String, String>();

    public void init(FilterConfig config) throws ServletException {
        Enumeration names = config.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.map.put("." + name, config.getInitParameter(name));
        }
        this.logger.debug("Map after init: " + this.map);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest srvRequest = (HttpServletRequest)request;
        String uri = srvRequest.getRequestURI();
        String extension = this.getExtension(uri);
        String type = this.map.get(extension);
        ArrayList<String> values = new ArrayList<String>();
        if (type == null) {
            Enumeration headers = srvRequest.getHeaders(ACCEPT_KEY);
            while (headers.hasMoreElements()) {
                values.add((String)headers.nextElement());
            }
        } else {
            values.add(type);
        }
        chain.doFilter((ServletRequest)new Wrapper(srvRequest, extension, values), response);
    }

    private String getExtension(String path) {
        int index = path.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        String extension = path.substring(index);
        if (this.map.containsKey(extension)) {
            return extension;
        }
        return "";
    }

    private static final class Wrapper
    extends HttpServletRequestWrapper {
        private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        private final List<String> accept;
        private final String acceptExtension;

        public Wrapper(HttpServletRequest request, String extension, List<String> theMime) {
            super(request);
            this.accept = theMime;
            this.acceptExtension = extension;
            this.logger.debug("Initialized with extension {}, accept: {}", (Object)this.acceptExtension, (Object)this.accept);
        }

        public String getRequestURI() {
            return this.stripAcceptExtension(super.getRequestURI());
        }

        public String getServletPath() {
            return this.stripAcceptExtension(super.getServletPath());
        }

        public Enumeration<String> getHeaders(String name) {
            if (AcceptServletFilter.ACCEPT_KEY.equals(name)) {
                return Collections.enumeration(this.accept);
            }
            return super.getHeaders(name);
        }

        public String getHeader(String name) {
            if (AcceptServletFilter.ACCEPT_KEY.equalsIgnoreCase(name)) {
                if (this.accept.isEmpty()) {
                    return null;
                }
                return this.accept.get(0);
            }
            return super.getHeader(name);
        }

        private String stripAcceptExtension(String path) {
            if (this.acceptExtension.isEmpty()) {
                return path;
            }
            int index = path.lastIndexOf(46);
            if (index == -1) {
                return path;
            }
            String extension = path.substring(index);
            this.logger.debug("searching for: " + extension);
            if (this.acceptExtension.equals(extension)) {
                return path.substring(0, path.length() - extension.length());
            }
            return path;
        }
    }
}

