/*
 * Decompiled with CFR 0.152.
 */
package com.cmayes.common.util;

import com.cmayes.common.exception.EnvironmentException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class EnvUtils {
    private EnvUtils() {
    }

    public static void recursiveDelete(File file) {
        if (file.isFile()) {
            boolean isDeleted = file.delete();
            if (!isDeleted) {
                throw new EnvironmentException("Failed to recursively delete location " + file.getAbsolutePath(), new Object[0]);
            }
        } else if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            for (int i = 0; i < subFiles.length; ++i) {
                EnvUtils.recursiveDelete(subFiles[i]);
            }
            boolean isDeleted = file.delete();
            if (!isDeleted) {
                throw new EnvironmentException("Failed to recursively delete location " + file.getAbsolutePath(), new Object[0]);
            }
        }
        if (file.exists()) {
            throw new EnvironmentException("Failed to recursively delete location " + file.getAbsolutePath(), new Object[0]);
        }
    }

    public static String getResourceAsString(String aResName) {
        Reader resourceReader = EnvUtils.getResourceReader(aResName);
        if (resourceReader == null) {
            return null;
        }
        return EnvUtils.getStringFromReader(resourceReader);
    }

    public static Reader getResourceReader(String aResName) {
        InputStream resource = EnvUtils.getResource(aResName);
        if (resource == null) {
            return null;
        }
        return new InputStreamReader(resource);
    }

    public static InputStream getResource(String aResName) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(aResName);
    }

    public static String getStringFromReader(Reader aData) {
        return EnvUtils.getStringFromReader(aData, true);
    }

    public static String getStringFromReader(Reader aData, boolean isAddNewlines) {
        StringBuffer buf = new StringBuffer();
        BufferedReader br = new BufferedReader(aData);
        try {
            String thisLine;
            while ((thisLine = br.readLine()) != null) {
                buf.append(thisLine);
                if (!isAddNewlines) continue;
                buf.append(System.getProperty("line.separator"));
            }
            aData.close();
        }
        catch (IOException e) {
            throw new EnvironmentException("Problems reading response stream: " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        return buf.toString();
    }
}

