import * as iam from '@aws-cdk/aws-iam';
/**
 * A principal to allow access to a key if it's being used through another AWS service.
 *
 * @stability stable
 */
export declare class ViaServicePrincipal extends iam.PrincipalBase {
    private readonly serviceName;
    private readonly basePrincipal;
    /**
     * @stability stable
     */
    constructor(serviceName: string, basePrincipal?: iam.IPrincipal);
    /**
     * Return the policy fragment that identifies this principal in a Policy.
     *
     * @stability stable
     */
    get policyFragment(): iam.PrincipalPolicyFragment;
}
