# python-bol-retailer-api
Wrapper for the bol.com Retailer API (v5)

## Install
This package is published on PyPi: https://pypi.org/project/python-bol-retailer-api/

Install with pip

    pip install python-bol-retailer-api
    
    
## Usage

Usage at this point is minimal. I will extend this package as I go and as I need.

Current usage is limited to Orders.

### Create connection
You will need a Client ID and Client Secret generated by Bol. Generate these here: https://partner.bol.com/sdd/settings.html#!/services/api

Create a new API connection

    from bol.api import BolAPI
    api = BolAPI(clientId, clientSecret)

Access token is automatically stored for later use. In the event that an access token is expired, a new access token will be requested and the initial request will be resend. This should ensure that the connection is never cut off.

The API keeps in account the rate limits that bol.com apply. In the event that the rate limit is almost exhausted within a timeframe, the API will stall until a new timeframe with new rate limits is available.

### Get all orders

By default all orders will be returned

    orderlist = api.orders.list()

You can specify the method and status yourself. Standard method is FBR and standard status is ALL.

    orderlist = api.orders.list(method='FBB', status='OPEN')

This will return an OrderList object.
You can loop over the orders like so:

    for order in orderlist.orders:
        print(order.orderId)
 
 Each order contains a list of OrderItem objects:
 
     for item in order.orderItems:
          print(item.orderItemId)
          
### Get specific order

To get more info about an order, you can get the specific details of an order by its ID.

    order = api.orders.get(id)

This will return an Order object.
          
