# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.9.1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class NewApiKey(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'description': 'str',
        'type': 'ApiKeyType',
        'tenant_id': 'str',
        'portfolio_ids': 'list[str]',
        'inherit_tenant_portfolios': 'bool',
        'can_read': 'bool',
        'can_trade': 'bool',
        'can_signal': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'type': 'type',
        'tenant_id': 'tenantId',
        'portfolio_ids': 'portfolio_ids',
        'inherit_tenant_portfolios': 'inherit_tenant_portfolios',
        'can_read': 'can_read',
        'can_trade': 'can_trade',
        'can_signal': 'can_signal'
    }

    def __init__(self, name=None, description=None, type=None, tenant_id=None, portfolio_ids=None, inherit_tenant_portfolios=False, can_read=True, can_trade=False, can_signal=False, local_vars_configuration=None):  # noqa: E501
        """NewApiKey - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._description = None
        self._type = None
        self._tenant_id = None
        self._portfolio_ids = None
        self._inherit_tenant_portfolios = None
        self._can_read = None
        self._can_trade = None
        self._can_signal = None
        self.discriminator = None

        self.name = name
        if description is not None:
            self.description = description
        self.type = type
        if tenant_id is not None:
            self.tenant_id = tenant_id
        if portfolio_ids is not None:
            self.portfolio_ids = portfolio_ids
        if inherit_tenant_portfolios is not None:
            self.inherit_tenant_portfolios = inherit_tenant_portfolios
        if can_read is not None:
            self.can_read = can_read
        if can_trade is not None:
            self.can_trade = can_trade
        if can_signal is not None:
            self.can_signal = can_signal

    @property
    def name(self):
        """Gets the name of this NewApiKey.  # noqa: E501

        An identifier for the API key, i.e. \"K1\"  # noqa: E501

        :return: The name of this NewApiKey.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NewApiKey.

        An identifier for the API key, i.e. \"K1\"  # noqa: E501

        :param name: The name of this NewApiKey.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and not re.search(r'[a-zA-Z0-9._-]+', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/[a-zA-Z0-9._-]+/`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this NewApiKey.  # noqa: E501


        :return: The description of this NewApiKey.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this NewApiKey.


        :param description: The description of this NewApiKey.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def type(self):
        """Gets the type of this NewApiKey.  # noqa: E501


        :return: The type of this NewApiKey.  # noqa: E501
        :rtype: ApiKeyType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NewApiKey.


        :param type: The type of this NewApiKey.  # noqa: E501
        :type type: ApiKeyType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def tenant_id(self):
        """Gets the tenant_id of this NewApiKey.  # noqa: E501


        :return: The tenant_id of this NewApiKey.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this NewApiKey.


        :param tenant_id: The tenant_id of this NewApiKey.  # noqa: E501
        :type tenant_id: str
        """

        self._tenant_id = tenant_id

    @property
    def portfolio_ids(self):
        """Gets the portfolio_ids of this NewApiKey.  # noqa: E501

        The IDs of the portfolios the API key is allowed to access. This property is mutually exclusive with `inherit_tenant_portfolios`.  # noqa: E501

        :return: The portfolio_ids of this NewApiKey.  # noqa: E501
        :rtype: list[str]
        """
        return self._portfolio_ids

    @portfolio_ids.setter
    def portfolio_ids(self, portfolio_ids):
        """Sets the portfolio_ids of this NewApiKey.

        The IDs of the portfolios the API key is allowed to access. This property is mutually exclusive with `inherit_tenant_portfolios`.  # noqa: E501

        :param portfolio_ids: The portfolio_ids of this NewApiKey.  # noqa: E501
        :type portfolio_ids: list[str]
        """

        self._portfolio_ids = portfolio_ids

    @property
    def inherit_tenant_portfolios(self):
        """Gets the inherit_tenant_portfolios of this NewApiKey.  # noqa: E501

        If true, all tenant portfolios will be accessible. This property is mutually exclusive with the `portfolio_ids` property.  # noqa: E501

        :return: The inherit_tenant_portfolios of this NewApiKey.  # noqa: E501
        :rtype: bool
        """
        return self._inherit_tenant_portfolios

    @inherit_tenant_portfolios.setter
    def inherit_tenant_portfolios(self, inherit_tenant_portfolios):
        """Sets the inherit_tenant_portfolios of this NewApiKey.

        If true, all tenant portfolios will be accessible. This property is mutually exclusive with the `portfolio_ids` property.  # noqa: E501

        :param inherit_tenant_portfolios: The inherit_tenant_portfolios of this NewApiKey.  # noqa: E501
        :type inherit_tenant_portfolios: bool
        """

        self._inherit_tenant_portfolios = inherit_tenant_portfolios

    @property
    def can_read(self):
        """Gets the can_read of this NewApiKey.  # noqa: E501

        Set to true, if the API key should be able to read data from the exchange (orderbook, trades, etc.)  # noqa: E501

        :return: The can_read of this NewApiKey.  # noqa: E501
        :rtype: bool
        """
        return self._can_read

    @can_read.setter
    def can_read(self, can_read):
        """Sets the can_read of this NewApiKey.

        Set to true, if the API key should be able to read data from the exchange (orderbook, trades, etc.)  # noqa: E501

        :param can_read: The can_read of this NewApiKey.  # noqa: E501
        :type can_read: bool
        """

        self._can_read = can_read

    @property
    def can_trade(self):
        """Gets the can_trade of this NewApiKey.  # noqa: E501

        Set to true, if the API key should be able to trade.  # noqa: E501

        :return: The can_trade of this NewApiKey.  # noqa: E501
        :rtype: bool
        """
        return self._can_trade

    @can_trade.setter
    def can_trade(self, can_trade):
        """Sets the can_trade of this NewApiKey.

        Set to true, if the API key should be able to trade.  # noqa: E501

        :param can_trade: The can_trade of this NewApiKey.  # noqa: E501
        :type can_trade: bool
        """

        self._can_trade = can_trade

    @property
    def can_signal(self):
        """Gets the can_signal of this NewApiKey.  # noqa: E501

        Set to true, if the API key should be allowed to submit signals  # noqa: E501

        :return: The can_signal of this NewApiKey.  # noqa: E501
        :rtype: bool
        """
        return self._can_signal

    @can_signal.setter
    def can_signal(self, can_signal):
        """Sets the can_signal of this NewApiKey.

        Set to true, if the API key should be allowed to submit signals  # noqa: E501

        :param can_signal: The can_signal of this NewApiKey.  # noqa: E501
        :type can_signal: bool
        """

        self._can_signal = can_signal

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NewApiKey):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NewApiKey):
            return True

        return self.to_dict() != other.to_dict()
