# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.9.1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class LogEntry(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'received': 'datetime',
        'text': 'str',
        'as_of': 'datetime',
        'category': 'str',
        'severity': 'Severity',
        'portfolio_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'received': 'received',
        'text': 'text',
        'as_of': 'as_of',
        'category': 'category',
        'severity': 'severity',
        'portfolio_id': 'portfolio_id'
    }

    def __init__(self, id=None, received=None, text=None, as_of=None, category=None, severity=None, portfolio_id=None, local_vars_configuration=None):  # noqa: E501
        """LogEntry - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._received = None
        self._text = None
        self._as_of = None
        self._category = None
        self._severity = None
        self._portfolio_id = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if received is not None:
            self.received = received
        self.text = text
        self.as_of = as_of
        if category is not None:
            self.category = category
        if severity is not None:
            self.severity = severity
        if portfolio_id is not None:
            self.portfolio_id = portfolio_id

    @property
    def id(self):
        """Gets the id of this LogEntry.  # noqa: E501

        The unique id of the log entry  # noqa: E501

        :return: The id of this LogEntry.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this LogEntry.

        The unique id of the log entry  # noqa: E501

        :param id: The id of this LogEntry.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def received(self):
        """Gets the received of this LogEntry.  # noqa: E501

        The timestamp when the trading API has received the log entry. UTC timezone is used.  # noqa: E501

        :return: The received of this LogEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._received

    @received.setter
    def received(self, received):
        """Sets the received of this LogEntry.

        The timestamp when the trading API has received the log entry. UTC timezone is used.  # noqa: E501

        :param received: The received of this LogEntry.  # noqa: E501
        :type received: datetime
        """

        self._received = received

    @property
    def text(self):
        """Gets the text of this LogEntry.  # noqa: E501

        The content of your log entry  # noqa: E501

        :return: The text of this LogEntry.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this LogEntry.

        The content of your log entry  # noqa: E501

        :param text: The text of this LogEntry.  # noqa: E501
        :type text: str
        """
        if self.local_vars_configuration.client_side_validation and text is None:  # noqa: E501
            raise ValueError("Invalid value for `text`, must not be `None`")  # noqa: E501

        self._text = text

    @property
    def as_of(self):
        """Gets the as_of of this LogEntry.  # noqa: E501

        Should be set to the time (UTC) when the log entry was emitted by your system  # noqa: E501

        :return: The as_of of this LogEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._as_of

    @as_of.setter
    def as_of(self, as_of):
        """Sets the as_of of this LogEntry.

        Should be set to the time (UTC) when the log entry was emitted by your system  # noqa: E501

        :param as_of: The as_of of this LogEntry.  # noqa: E501
        :type as_of: datetime
        """
        if self.local_vars_configuration.client_side_validation and as_of is None:  # noqa: E501
            raise ValueError("Invalid value for `as_of`, must not be `None`")  # noqa: E501

        self._as_of = as_of

    @property
    def category(self):
        """Gets the category of this LogEntry.  # noqa: E501

        An optional category of the log entry  # noqa: E501

        :return: The category of this LogEntry.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this LogEntry.

        An optional category of the log entry  # noqa: E501

        :param category: The category of this LogEntry.  # noqa: E501
        :type category: str
        """

        self._category = category

    @property
    def severity(self):
        """Gets the severity of this LogEntry.  # noqa: E501


        :return: The severity of this LogEntry.  # noqa: E501
        :rtype: Severity
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this LogEntry.


        :param severity: The severity of this LogEntry.  # noqa: E501
        :type severity: Severity
        """

        self._severity = severity

    @property
    def portfolio_id(self):
        """Gets the portfolio_id of this LogEntry.  # noqa: E501

        The portfolio for which the log entry is applicable  # noqa: E501

        :return: The portfolio_id of this LogEntry.  # noqa: E501
        :rtype: str
        """
        return self._portfolio_id

    @portfolio_id.setter
    def portfolio_id(self, portfolio_id):
        """Sets the portfolio_id of this LogEntry.

        The portfolio for which the log entry is applicable  # noqa: E501

        :param portfolio_id: The portfolio_id of this LogEntry.  # noqa: E501
        :type portfolio_id: str
        """

        self._portfolio_id = portfolio_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LogEntry):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LogEntry):
            return True

        return self.to_dict() != other.to_dict()
