"""empty message

Revision ID: a2af1e2e44ee
Revises: None
Create Date: 2021-08-29 18:38:10.030545

"""

# revision identifiers, used by Alembic.
revision = 'a2af1e2e44ee'
down_revision = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('account',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=255), nullable=True),
    sa.Column('username', sa.String(length=255), nullable=True),
    sa.Column('email', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_account_email'), 'account', ['email'], unique=False)
    op.create_index(op.f('ix_account_id'), 'account', ['id'], unique=True)
    op.create_index(op.f('ix_account_name'), 'account', ['name'], unique=False)
    op.create_index(op.f('ix_account_username'), 'account', ['username'], unique=False)
    op.create_table('repository',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.Column('subscribed', sa.Boolean(), nullable=True),
    sa.Column('description', sa.Text(), nullable=False),
    sa.Column('can_push', sa.Boolean(), nullable=True),
    sa.Column('updated', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_repository_name'), 'repository', ['name'], unique=True)
    op.create_index(op.f('ix_repository_subscribed'), 'repository', ['subscribed'], unique=False)
    op.create_table('topic',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.Column('sequence', sa.Integer(), nullable=False),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_topic_name'), 'topic', ['name'], unique=False)
    op.create_index(op.f('ix_topic_sequence'), 'topic', ['sequence'], unique=True)
    op.create_table('branch',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('repository_key', sa.Integer(), nullable=True),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.ForeignKeyConstraint(['repository_key'], ['repository.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_branch_name'), 'branch', ['name'], unique=False)
    op.create_index(op.f('ix_branch_repository_key'), 'branch', ['repository_key'], unique=False)
    op.create_table('label',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('repository_key', sa.Integer(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.Column('color', sa.String(length=8), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['repository_key'], ['repository.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_label_id'), 'label', ['id'], unique=False)
    op.create_index(op.f('ix_label_repository_key'), 'label', ['repository_key'], unique=False)
    op.create_table('pull_request',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('repository_key', sa.Integer(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('number', sa.Integer(), nullable=False),
    sa.Column('branch', sa.String(length=255), nullable=False),
    sa.Column('pr_id', sa.String(length=255), nullable=False),
    sa.Column('account_key', sa.Integer(), nullable=True),
    sa.Column('title', sa.String(length=255), nullable=False),
    sa.Column('body', sa.Text(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('updated', sa.DateTime(), nullable=False),
    sa.Column('state', sa.String(length=16), nullable=False),
    sa.Column('additions', sa.Integer(), nullable=False),
    sa.Column('deletions', sa.Integer(), nullable=False),
    sa.Column('html_url', sa.Text(), nullable=False),
    sa.Column('hidden', sa.Boolean(), nullable=False),
    sa.Column('reviewed', sa.Boolean(), nullable=False),
    sa.Column('starred', sa.Boolean(), nullable=False),
    sa.Column('held', sa.Boolean(), nullable=False),
    sa.Column('pending_rebase', sa.Boolean(), nullable=False),
    sa.Column('pending_edit', sa.Boolean(), nullable=False),
    sa.Column('pending_labels', sa.Boolean(), nullable=False),
    sa.Column('pending_edit_message', sa.Text(), nullable=True),
    sa.Column('last_seen', sa.DateTime(), nullable=True),
    sa.Column('outdated', sa.Boolean(), nullable=False),
    sa.Column('merged', sa.Boolean(), nullable=False),
    sa.Column('mergeable', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['account_key'], ['account.key'], ),
    sa.ForeignKeyConstraint(['repository_key'], ['repository.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_pull_request_account_key'), 'pull_request', ['account_key'], unique=False)
    op.create_index(op.f('ix_pull_request_branch'), 'pull_request', ['branch'], unique=False)
    op.create_index(op.f('ix_pull_request_created'), 'pull_request', ['created'], unique=False)
    op.create_index(op.f('ix_pull_request_held'), 'pull_request', ['held'], unique=False)
    op.create_index(op.f('ix_pull_request_hidden'), 'pull_request', ['hidden'], unique=False)
    op.create_index(op.f('ix_pull_request_id'), 'pull_request', ['id'], unique=True)
    op.create_index(op.f('ix_pull_request_last_seen'), 'pull_request', ['last_seen'], unique=False)
    op.create_index(op.f('ix_pull_request_mergeable'), 'pull_request', ['mergeable'], unique=False)
    op.create_index(op.f('ix_pull_request_merged'), 'pull_request', ['merged'], unique=False)
    op.create_index(op.f('ix_pull_request_number'), 'pull_request', ['number'], unique=False)
    op.create_index(op.f('ix_pull_request_outdated'), 'pull_request', ['outdated'], unique=False)
    op.create_index(op.f('ix_pull_request_pending_edit'), 'pull_request', ['pending_edit'], unique=False)
    op.create_index(op.f('ix_pull_request_pending_labels'), 'pull_request', ['pending_labels'], unique=False)
    op.create_index(op.f('ix_pull_request_pending_rebase'), 'pull_request', ['pending_rebase'], unique=False)
    op.create_index(op.f('ix_pull_request_pr_id'), 'pull_request', ['pr_id'], unique=True)
    op.create_index(op.f('ix_pull_request_repository_key'), 'pull_request', ['repository_key'], unique=False)
    op.create_index(op.f('ix_pull_request_reviewed'), 'pull_request', ['reviewed'], unique=False)
    op.create_index(op.f('ix_pull_request_starred'), 'pull_request', ['starred'], unique=False)
    op.create_index(op.f('ix_pull_request_state'), 'pull_request', ['state'], unique=False)
    op.create_index(op.f('ix_pull_request_updated'), 'pull_request', ['updated'], unique=False)
    op.create_table('repository_topic',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('repository_key', sa.Integer(), nullable=True),
    sa.Column('topic_key', sa.Integer(), nullable=True),
    sa.Column('sequence', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['repository_key'], ['repository.key'], ),
    sa.ForeignKeyConstraint(['topic_key'], ['topic.key'], ),
    sa.PrimaryKeyConstraint('key'),
    sa.UniqueConstraint('topic_key', 'sequence', name='topic_key_sequence_const')
    )
    op.create_index(op.f('ix_repository_topic_repository_key'), 'repository_topic', ['repository_key'], unique=False)
    op.create_index(op.f('ix_repository_topic_topic_key'), 'repository_topic', ['topic_key'], unique=False)
    op.create_table('server',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('own_account_key', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['own_account_key'], ['account.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_server_own_account_key'), 'server', ['own_account_key'], unique=False)
    op.create_table('approval',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('pr_key', sa.Integer(), nullable=True),
    sa.Column('account_key', sa.Integer(), nullable=True),
    sa.Column('state', sa.String(length=32), nullable=False),
    sa.Column('sha', sa.String(length=64), nullable=False),
    sa.Column('draft', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['account_key'], ['account.key'], ),
    sa.ForeignKeyConstraint(['pr_key'], ['pull_request.key'], ),
    sa.PrimaryKeyConstraint('key'),
    sa.UniqueConstraint('pr_key', 'account_key', 'sha', name='approval_pr_key_account_key_sha_const')
    )
    op.create_index(op.f('ix_approval_account_key'), 'approval', ['account_key'], unique=False)
    op.create_index(op.f('ix_approval_draft'), 'approval', ['draft'], unique=False)
    op.create_index(op.f('ix_approval_pr_key'), 'approval', ['pr_key'], unique=False)
    op.create_index(op.f('ix_approval_state'), 'approval', ['state'], unique=False)
    op.create_table('commit',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('pr_key', sa.Integer(), nullable=True),
    sa.Column('message', sa.Text(), nullable=False),
    sa.Column('sha', sa.String(length=64), nullable=False),
    sa.Column('parent', sa.String(length=64), nullable=False),
    sa.ForeignKeyConstraint(['pr_key'], ['pull_request.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_commit_parent'), 'commit', ['parent'], unique=False)
    op.create_index(op.f('ix_commit_pr_key'), 'commit', ['pr_key'], unique=False)
    op.create_index(op.f('ix_commit_sha'), 'commit', ['sha'], unique=False)
    op.create_table('pending_merge',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('pr_key', sa.Integer(), nullable=True),
    sa.Column('commit_title', sa.String(length=255), nullable=True),
    sa.Column('commit_message', sa.Text(), nullable=True),
    sa.Column('sha', sa.String(length=255), nullable=False),
    sa.Column('merge_method', sa.String(length=255), nullable=False),
    sa.ForeignKeyConstraint(['pr_key'], ['pull_request.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_pending_merge_pr_key'), 'pending_merge', ['pr_key'], unique=False)
    op.create_table('pull_request_label',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('pr_key', sa.Integer(), nullable=True),
    sa.Column('label_key', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['label_key'], ['label.key'], ),
    sa.ForeignKeyConstraint(['pr_key'], ['pull_request.key'], ),
    sa.PrimaryKeyConstraint('key'),
    sa.UniqueConstraint('pr_key', 'label_key', name='pr_key_label_key_const')
    )
    op.create_index(op.f('ix_pull_request_label_label_key'), 'pull_request_label', ['label_key'], unique=False)
    op.create_index(op.f('ix_pull_request_label_pr_key'), 'pull_request_label', ['pr_key'], unique=False)
    op.create_table('check',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('commit_key', sa.Integer(), nullable=True),
    sa.Column('state', sa.String(length=16), nullable=False),
    sa.Column('name', sa.String(length=255), nullable=True),
    sa.Column('url', sa.Text(), nullable=True),
    sa.Column('message', sa.Text(), nullable=True),
    sa.Column('started', sa.DateTime(), nullable=True),
    sa.Column('finished', sa.DateTime(), nullable=True),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('updated', sa.DateTime(), nullable=False),
    sa.ForeignKeyConstraint(['commit_key'], ['commit.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_check_commit_key'), 'check', ['commit_key'], unique=False)
    op.create_index(op.f('ix_check_name'), 'check', ['name'], unique=False)
    op.create_table('file',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('commit_key', sa.Integer(), nullable=True),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('old_path', sa.Text(), nullable=True),
    sa.Column('inserted', sa.Integer(), nullable=True),
    sa.Column('deleted', sa.Integer(), nullable=True),
    sa.Column('status', sa.String(length=16), nullable=False),
    sa.ForeignKeyConstraint(['commit_key'], ['commit.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_file_commit_key'), 'file', ['commit_key'], unique=False)
    op.create_index(op.f('ix_file_old_path'), 'file', ['old_path'], unique=False)
    op.create_index(op.f('ix_file_path'), 'file', ['path'], unique=False)
    op.create_index(op.f('ix_file_status'), 'file', ['status'], unique=False)
    op.create_table('message',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('pr_key', sa.Integer(), nullable=True),
    sa.Column('commit_key', sa.Integer(), nullable=True),
    sa.Column('account_key', sa.Integer(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=True),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('message', sa.Text(), nullable=False),
    sa.Column('draft', sa.Boolean(), nullable=False),
    sa.Column('pending', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['account_key'], ['account.key'], ),
    sa.ForeignKeyConstraint(['commit_key'], ['commit.key'], ),
    sa.ForeignKeyConstraint(['pr_key'], ['pull_request.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_message_account_key'), 'message', ['account_key'], unique=False)
    op.create_index(op.f('ix_message_commit_key'), 'message', ['commit_key'], unique=False)
    op.create_index(op.f('ix_message_created'), 'message', ['created'], unique=False)
    op.create_index(op.f('ix_message_draft'), 'message', ['draft'], unique=False)
    op.create_index(op.f('ix_message_id'), 'message', ['id'], unique=False)
    op.create_index(op.f('ix_message_pending'), 'message', ['pending'], unique=False)
    op.create_index(op.f('ix_message_pr_key'), 'message', ['pr_key'], unique=False)
    op.create_table('comment',
    sa.Column('key', sa.Integer(), nullable=False),
    sa.Column('message_key', sa.Integer(), nullable=True),
    sa.Column('file_key', sa.Integer(), nullable=True),
    sa.Column('account_key', sa.Integer(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=True),
    sa.Column('in_reply_to', sa.Integer(), nullable=True),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('updated', sa.DateTime(), nullable=False),
    sa.Column('parent', sa.Boolean(), nullable=False),
    sa.Column('commit_id', sa.String(length=64), nullable=False),
    sa.Column('original_commit_id', sa.String(length=64), nullable=False),
    sa.Column('line', sa.Integer(), nullable=True),
    sa.Column('original_line', sa.Integer(), nullable=True),
    sa.Column('message', sa.Text(), nullable=False),
    sa.Column('draft', sa.Boolean(), nullable=False),
    sa.Column('url', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['account_key'], ['account.key'], ),
    sa.ForeignKeyConstraint(['file_key'], ['file.key'], ),
    sa.ForeignKeyConstraint(['message_key'], ['message.key'], ),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_index(op.f('ix_comment_account_key'), 'comment', ['account_key'], unique=False)
    op.create_index(op.f('ix_comment_created'), 'comment', ['created'], unique=False)
    op.create_index(op.f('ix_comment_draft'), 'comment', ['draft'], unique=False)
    op.create_index(op.f('ix_comment_file_key'), 'comment', ['file_key'], unique=False)
    op.create_index(op.f('ix_comment_id'), 'comment', ['id'], unique=False)
    op.create_index(op.f('ix_comment_in_reply_to'), 'comment', ['in_reply_to'], unique=False)
    op.create_index(op.f('ix_comment_line'), 'comment', ['line'], unique=False)
    op.create_index(op.f('ix_comment_message_key'), 'comment', ['message_key'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_comment_message_key'), table_name='comment')
    op.drop_index(op.f('ix_comment_line'), table_name='comment')
    op.drop_index(op.f('ix_comment_in_reply_to'), table_name='comment')
    op.drop_index(op.f('ix_comment_id'), table_name='comment')
    op.drop_index(op.f('ix_comment_file_key'), table_name='comment')
    op.drop_index(op.f('ix_comment_draft'), table_name='comment')
    op.drop_index(op.f('ix_comment_created'), table_name='comment')
    op.drop_index(op.f('ix_comment_account_key'), table_name='comment')
    op.drop_table('comment')
    op.drop_index(op.f('ix_message_pr_key'), table_name='message')
    op.drop_index(op.f('ix_message_pending'), table_name='message')
    op.drop_index(op.f('ix_message_id'), table_name='message')
    op.drop_index(op.f('ix_message_draft'), table_name='message')
    op.drop_index(op.f('ix_message_created'), table_name='message')
    op.drop_index(op.f('ix_message_commit_key'), table_name='message')
    op.drop_index(op.f('ix_message_account_key'), table_name='message')
    op.drop_table('message')
    op.drop_index(op.f('ix_file_status'), table_name='file')
    op.drop_index(op.f('ix_file_path'), table_name='file')
    op.drop_index(op.f('ix_file_old_path'), table_name='file')
    op.drop_index(op.f('ix_file_commit_key'), table_name='file')
    op.drop_table('file')
    op.drop_index(op.f('ix_check_name'), table_name='check')
    op.drop_index(op.f('ix_check_commit_key'), table_name='check')
    op.drop_table('check')
    op.drop_index(op.f('ix_pull_request_label_pr_key'), table_name='pull_request_label')
    op.drop_index(op.f('ix_pull_request_label_label_key'), table_name='pull_request_label')
    op.drop_table('pull_request_label')
    op.drop_index(op.f('ix_pending_merge_pr_key'), table_name='pending_merge')
    op.drop_table('pending_merge')
    op.drop_index(op.f('ix_commit_sha'), table_name='commit')
    op.drop_index(op.f('ix_commit_pr_key'), table_name='commit')
    op.drop_index(op.f('ix_commit_parent'), table_name='commit')
    op.drop_table('commit')
    op.drop_index(op.f('ix_approval_state'), table_name='approval')
    op.drop_index(op.f('ix_approval_pr_key'), table_name='approval')
    op.drop_index(op.f('ix_approval_draft'), table_name='approval')
    op.drop_index(op.f('ix_approval_account_key'), table_name='approval')
    op.drop_table('approval')
    op.drop_index(op.f('ix_server_own_account_key'), table_name='server')
    op.drop_table('server')
    op.drop_index(op.f('ix_repository_topic_topic_key'), table_name='repository_topic')
    op.drop_index(op.f('ix_repository_topic_repository_key'), table_name='repository_topic')
    op.drop_table('repository_topic')
    op.drop_index(op.f('ix_pull_request_updated'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_state'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_starred'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_reviewed'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_repository_key'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_pr_id'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_pending_rebase'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_pending_labels'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_pending_edit'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_outdated'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_number'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_merged'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_mergeable'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_last_seen'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_id'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_hidden'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_held'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_created'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_branch'), table_name='pull_request')
    op.drop_index(op.f('ix_pull_request_account_key'), table_name='pull_request')
    op.drop_table('pull_request')
    op.drop_index(op.f('ix_label_repository_key'), table_name='label')
    op.drop_index(op.f('ix_label_id'), table_name='label')
    op.drop_table('label')
    op.drop_index(op.f('ix_branch_repository_key'), table_name='branch')
    op.drop_index(op.f('ix_branch_name'), table_name='branch')
    op.drop_table('branch')
    op.drop_index(op.f('ix_topic_sequence'), table_name='topic')
    op.drop_index(op.f('ix_topic_name'), table_name='topic')
    op.drop_table('topic')
    op.drop_index(op.f('ix_repository_subscribed'), table_name='repository')
    op.drop_index(op.f('ix_repository_name'), table_name='repository')
    op.drop_table('repository')
    op.drop_index(op.f('ix_account_username'), table_name='account')
    op.drop_index(op.f('ix_account_name'), table_name='account')
    op.drop_index(op.f('ix_account_id'), table_name='account')
    op.drop_index(op.f('ix_account_email'), table_name='account')
    op.drop_table('account')
    # ### end Alembic commands ###
