import sys


class color:
    PURPLE = '\033[95m'
    CYAN = '\033[96m'
    DARKCYAN = '\033[36m'
    BLUE = '\033[94m'
    GREEN = '\033[92m'
    YELLOW = '\033[93m'
    RED = '\033[91m'
    BOLD = '\033[1m'
    UNDERLINE = '\033[4m'
    END = '\033[0m'


class logger:
    def __init__(self, verbose: bool):
        self.verbose = verbose

    def status_msg(self, message: str):
        if self.verbose:
            print(color.BOLD + color.BLUE + "[STATUS]" + color.END, message)

    def error_msg(self, message: str):
        print(color.BOLD + color.RED + "[ERROR]" +
              color.END, message, file=sys.stderr)

    def custom_msg(self, label: str, message: str):
        if self.verbose:
            print(color.BOLD + color.GREEN +
                  "[" + label + "]" + color.END, message)
