# The Open Autonomy framework

<figure markdown>
![](images/open-autonomy-framework-logo.png)
</figure>

{{open_autonomy}} is a framework for the creation of [agent services](./get_started/what_is_an_agent_service.md): off-chain
autonomous services which run as a multi-agent-system (MAS) and offer **enhanced functionalities
on-chain**. Agent services expand the range of operations that traditional
smart contracts offer, making it possible to execute arbitrarily complex operations
(such as machine-learning algorithms). Most importantly, agent services are
**decentralized**, **trust-minimized**, **transparent**, and **robust**.

The framework provides:

* A collection of **command line tools** to build, deploy, publish and test agent services.
* A collection of base **packages** to provide agents the functionalities to become part of an agent service.

!!! abstract "Read the Whitepaper"

    The [Autonolas Whitepaper](https://autonolas.network/whitepaper/autonolas-whitepaper.pdf), presents a comprehensive discussion on the architecture of the Autonolas Ecosystem. The Open Autonomy framework connects with the **Technical Architecture** section therein as a facilitator to build autonomous services.

## Building with Open Autonomy

The framework is designed to speed up the development life cycle of autonomous services, helping you to bring your services from an idea to production as quick as possible. Overall, this is the general path that you should have in mind when working with {{open_autonomy}}:

<figure markdown>
![Simplified Development Process](./images/development-process-simplified.svg)
</figure>

Find a more comprehensive description in the [overview of the development process](guides/overview_of_the_development_process.md) section.

## Browse the docs

Get started with {{open_autonomy}}, **learn the main concepts** and get some context on how agent services fit in the wider crypto ecosystem.

[Get started](./get_started/what_is_an_agent_service.md){ .md-button .md-button--primary}

------

Follow the guides to learn how to use the framework to **create and deploy agent services**.

[Guides](./guides/index.md){ .md-button }

------

A tour to **existing agent services** that you can explore and use them as a reference
for your implementations.

[Demos](./demos/index.md){ .md-button }

------

Detailed topics on how the **internal components** of an agent service work with the
framework.

[Key concepts](./key_concepts/index.md){ .md-button }

------

Browse through the CLI and API reference documentation.

[Advanced reference](./advanced_reference/index.md){ .md-button }

------

Browse our FAQ where you can find commonly asked questions about the framework.

[FAQ](./questions-and-answers.md){ .md-button }
