/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import java.util.Arrays;
import java.util.stream.IntStream;
import vcf.GTRec;
import vcf.Marker;
import vcf.Samples;
import vcf.VcfRecGTParser;

public final class LowMafDiallelicGTRec
implements GTRec {
    private final Marker marker;
    private final Samples samples;
    private final int nHaps;
    private final int majorAllele;
    private final int minorAllele;
    private final int[] missingSamples;
    private final int[] minorAlleles;
    private final boolean isPhased;

    public LowMafDiallelicGTRec(VcfRecGTParser.HapListRep hapListRep) {
        if (hapListRep.marker().nAlleles() != 2) {
            throw new IllegalArgumentException(String.valueOf(hapListRep.marker().nAlleles()));
        }
        this.marker = hapListRep.marker();
        this.samples = hapListRep.samples();
        this.nHaps = this.samples.size() << 1;
        this.majorAllele = hapListRep.majorAllele();
        this.minorAllele = 1 - hapListRep.majorAllele();
        this.minorAlleles = hapListRep.hapLists(true)[this.minorAllele];
        this.missingSamples = hapListRep.missingSamples();
        this.isPhased = hapListRep.isPhased();
    }

    @Override
    public boolean isPhased(int n) {
        if (n < 0 || n >= this.samples().size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.isPhased;
    }

    @Override
    public boolean isPhased() {
        return this.isPhased;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int size() {
        return this.nHaps;
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public int allele1(int n) {
        return this.get(n << 1);
    }

    @Override
    public int allele2(int n) {
        return this.get(n << 1 | 1);
    }

    @Override
    public int get(int n) {
        if (n < 0 || n >= this.nHaps) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (Arrays.binarySearch(this.minorAlleles, n) >= 0) {
            return this.minorAllele;
        }
        if (Arrays.binarySearch(this.missingSamples, n >> 1) >= 0) {
            return -1;
        }
        return this.majorAllele;
    }

    @Override
    public int[] alleles() {
        int[] nArray = IntStream.range(0, this.nHaps).map(n -> this.majorAllele).toArray();
        for (int n2 : this.minorAlleles) {
            nArray[n2] = this.minorAllele;
        }
        for (int n2 : this.missingSamples) {
            int n3 = n2 << 1;
            int n4 = n3 | 1;
            nArray[n3] = -1;
            nArray[n4] = -1;
        }
        return nArray;
    }

    public int majorAllele() {
        return this.majorAllele;
    }

    public int alleleCount(int n) {
        if (n == this.majorAllele) {
            return this.nHaps - this.minorAlleles.length - (this.missingSamples.length << 1);
        }
        return this.minorAlleles.length;
    }

    public String toString() {
        return GTRec.toVcfRec(this);
    }
}

