# AUTOGENERATED! DO NOT EDIT! File to edit: ../18_CarveMix.ipynb.

# %% auto 0
__all__ = ['CarveMix']

# %% ../18_CarveMix.ipynb 2
from .holemakertechnique import *
from .holemakerroi import *
from .holesfilling import *
from .cutmixrandom import CutMixRandom
import numpy as np
import random
import cv2
from fastai.basics import *

# %% ../18_CarveMix.ipynb 4
class CarveMix(HolesFilling):
    "Defines the amount of holes, the technique used to make them and the probability of apply the technique."
    def __init__(self,
                 holes_num: int = 1, # The amount of holes to make.
                 ROI_class: int = -1, # The class to be used to select the ROI.
                 ROI_area: int = 25, # The minimum area to be selected as a ROI.
                 delta_ratio: float = None, # The ratio of pixels of the ROI that are going to be used. A ratio of 1 takes all the ROI pixels, a ratio < 1 crops the ROI and a ratio > 1 adds more pixels to the ROI. A None ratio takes a random value [0.9, 1.1) in each usage.
                 p: float = 0.5): # The probability of applying this technique.
        hole_maker = HoleMakerROI(ROI_class, ROI_area, delta_ratio)
        super().__init__(hole_maker)
        self.holes_num = holes_num
        self.p = p

    def before_batch(self):
        "Applies the CutMix technique."
        for index, (image, mask) in enumerate(zip(self.x, self.y)):
            if random.random() < self.p:
                for _ in range(self.holes_num):
                    rand = random.randint(0, self.x.shape[0] - 1)
                    other_image, other_mask = self.x[rand], self.y[rand]
                    xhole, yhole = self.make_hole(other_mask)
                    sub_image, sub_mask = other_image[:, yhole, xhole], other_mask[yhole, xhole]
                    self.fill_hole(image, mask, xhole, yhole, [sub_image, sub_mask])
