"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
/*
 * Stack verification steps:
 * * `aws cognito-idp sign-up --client-id <cfnoutput-client-id> --username user-1 --password pass1234 \
 *   --user-attributes Name="phone_number",Value="<valid-phone-number-with-intl-extension>"
 * * `aws cognito-idp sign-up --client-id <cfnoutput-client-id> --username user-2 --password pass1234 \
 *   --user-attributes Name="email",Value="<valid-email-address>"
 * * An email with the message 'integ-test: Verify by clicking on <link>' should be received.
 * * An SMS with the message 'integ-test: Account verification code is <code>' should be received.
 */
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool-signup-link');
const userpool = new lib_1.UserPool(stack, 'myuserpool', {
    userPoolName: 'MyUserPool',
    autoVerify: {
        email: true,
        phone: true,
    },
    selfSignUpEnabled: true,
    userVerification: {
        emailStyle: lib_1.VerificationEmailStyle.LINK,
        emailSubject: 'integ-test: Verify your account',
        emailBody: 'integ-test: Verify by clicking on {##Verify Email##}',
        smsMessage: 'integ-test: Account verification code is {####}',
    },
    passwordPolicy: {
        requireUppercase: false,
        requireLowercase: false,
        requireDigits: false,
        requireSymbols: false,
    },
});
const client = new lib_1.UserPoolClient(stack, 'myuserpoolclient', {
    userPool: userpool,
    userPoolClientName: 'signup-test',
    generateSecret: false,
});
// replace with L2 once Domain support is available
new lib_1.CfnUserPoolDomain(stack, 'myuserpooldomain', {
    userPoolId: userpool.userPoolId,
    domain: userpool.node.uniqueId,
});
new core_1.CfnOutput(stack, 'user-pool-id', {
    value: userpool.userPoolId,
});
new core_1.CfnOutput(stack, 'client-id', {
    value: client.userPoolClientId,
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcudXNlci1wb29sLXNpZ251cC1saW5rLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcudXNlci1wb29sLXNpZ251cC1saW5rLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQXNEO0FBQ3RELGdDQUE2RjtBQUU3Rjs7Ozs7Ozs7R0FRRztBQUVILE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7QUFDdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLENBQUMsR0FBRyxFQUFFLDZCQUE2QixDQUFDLENBQUM7QUFFNUQsTUFBTSxRQUFRLEdBQUcsSUFBSSxjQUFRLENBQUMsS0FBSyxFQUFFLFlBQVksRUFBRTtJQUNqRCxZQUFZLEVBQUUsWUFBWTtJQUMxQixVQUFVLEVBQUU7UUFDVixLQUFLLEVBQUUsSUFBSTtRQUNYLEtBQUssRUFBRSxJQUFJO0tBQ1o7SUFDRCxpQkFBaUIsRUFBRSxJQUFJO0lBQ3ZCLGdCQUFnQixFQUFFO1FBQ2hCLFVBQVUsRUFBRSw0QkFBc0IsQ0FBQyxJQUFJO1FBQ3ZDLFlBQVksRUFBRSxpQ0FBaUM7UUFDL0MsU0FBUyxFQUFFLHNEQUFzRDtRQUNqRSxVQUFVLEVBQUUsaURBQWlEO0tBQzlEO0lBQ0QsY0FBYyxFQUFFO1FBQ2QsZ0JBQWdCLEVBQUUsS0FBSztRQUN2QixnQkFBZ0IsRUFBRSxLQUFLO1FBQ3ZCLGFBQWEsRUFBRSxLQUFLO1FBQ3BCLGNBQWMsRUFBRSxLQUFLO0tBQ3RCO0NBQ0YsQ0FBQyxDQUFDO0FBRUgsTUFBTSxNQUFNLEdBQUcsSUFBSSxvQkFBYyxDQUFDLEtBQUssRUFBRSxrQkFBa0IsRUFBRTtJQUMzRCxRQUFRLEVBQUUsUUFBUTtJQUNsQixrQkFBa0IsRUFBRSxhQUFhO0lBQ2pDLGNBQWMsRUFBRSxLQUFLO0NBQ3RCLENBQUMsQ0FBQztBQUVILG1EQUFtRDtBQUNuRCxJQUFJLHVCQUFpQixDQUFDLEtBQUssRUFBRSxrQkFBa0IsRUFBRTtJQUMvQyxVQUFVLEVBQUUsUUFBUSxDQUFDLFVBQVU7SUFDL0IsTUFBTSxFQUFFLFFBQVEsQ0FBQyxJQUFJLENBQUMsUUFBUTtDQUMvQixDQUFDLENBQUM7QUFFSCxJQUFJLGdCQUFTLENBQUMsS0FBSyxFQUFFLGNBQWMsRUFBRTtJQUNuQyxLQUFLLEVBQUUsUUFBUSxDQUFDLFVBQVU7Q0FDM0IsQ0FBQyxDQUFDO0FBRUgsSUFBSSxnQkFBUyxDQUFDLEtBQUssRUFBRSxXQUFXLEVBQUU7SUFDaEMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxnQkFBZ0I7Q0FDL0IsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXBwLCBDZm5PdXRwdXQsIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBDZm5Vc2VyUG9vbERvbWFpbiwgVXNlclBvb2wsIFVzZXJQb29sQ2xpZW50LCBWZXJpZmljYXRpb25FbWFpbFN0eWxlIH0gZnJvbSAnLi4vbGliJztcblxuLypcbiAqIFN0YWNrIHZlcmlmaWNhdGlvbiBzdGVwczpcbiAqICogYGF3cyBjb2duaXRvLWlkcCBzaWduLXVwIC0tY2xpZW50LWlkIDxjZm5vdXRwdXQtY2xpZW50LWlkPiAtLXVzZXJuYW1lIHVzZXItMSAtLXBhc3N3b3JkIHBhc3MxMjM0IFxcXG4gKiAgIC0tdXNlci1hdHRyaWJ1dGVzIE5hbWU9XCJwaG9uZV9udW1iZXJcIixWYWx1ZT1cIjx2YWxpZC1waG9uZS1udW1iZXItd2l0aC1pbnRsLWV4dGVuc2lvbj5cIlxuICogKiBgYXdzIGNvZ25pdG8taWRwIHNpZ24tdXAgLS1jbGllbnQtaWQgPGNmbm91dHB1dC1jbGllbnQtaWQ+IC0tdXNlcm5hbWUgdXNlci0yIC0tcGFzc3dvcmQgcGFzczEyMzQgXFxcbiAqICAgLS11c2VyLWF0dHJpYnV0ZXMgTmFtZT1cImVtYWlsXCIsVmFsdWU9XCI8dmFsaWQtZW1haWwtYWRkcmVzcz5cIlxuICogKiBBbiBlbWFpbCB3aXRoIHRoZSBtZXNzYWdlICdpbnRlZy10ZXN0OiBWZXJpZnkgYnkgY2xpY2tpbmcgb24gPGxpbms+JyBzaG91bGQgYmUgcmVjZWl2ZWQuXG4gKiAqIEFuIFNNUyB3aXRoIHRoZSBtZXNzYWdlICdpbnRlZy10ZXN0OiBBY2NvdW50IHZlcmlmaWNhdGlvbiBjb2RlIGlzIDxjb2RlPicgc2hvdWxkIGJlIHJlY2VpdmVkLlxuICovXG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcbmNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKGFwcCwgJ2ludGVnLXVzZXItcG9vbC1zaWdudXAtbGluaycpO1xuXG5jb25zdCB1c2VycG9vbCA9IG5ldyBVc2VyUG9vbChzdGFjaywgJ215dXNlcnBvb2wnLCB7XG4gIHVzZXJQb29sTmFtZTogJ015VXNlclBvb2wnLFxuICBhdXRvVmVyaWZ5OiB7XG4gICAgZW1haWw6IHRydWUsXG4gICAgcGhvbmU6IHRydWUsXG4gIH0sXG4gIHNlbGZTaWduVXBFbmFibGVkOiB0cnVlLFxuICB1c2VyVmVyaWZpY2F0aW9uOiB7XG4gICAgZW1haWxTdHlsZTogVmVyaWZpY2F0aW9uRW1haWxTdHlsZS5MSU5LLFxuICAgIGVtYWlsU3ViamVjdDogJ2ludGVnLXRlc3Q6IFZlcmlmeSB5b3VyIGFjY291bnQnLFxuICAgIGVtYWlsQm9keTogJ2ludGVnLXRlc3Q6IFZlcmlmeSBieSBjbGlja2luZyBvbiB7IyNWZXJpZnkgRW1haWwjI30nLFxuICAgIHNtc01lc3NhZ2U6ICdpbnRlZy10ZXN0OiBBY2NvdW50IHZlcmlmaWNhdGlvbiBjb2RlIGlzIHsjIyMjfScsXG4gIH0sXG4gIHBhc3N3b3JkUG9saWN5OiB7XG4gICAgcmVxdWlyZVVwcGVyY2FzZTogZmFsc2UsXG4gICAgcmVxdWlyZUxvd2VyY2FzZTogZmFsc2UsXG4gICAgcmVxdWlyZURpZ2l0czogZmFsc2UsXG4gICAgcmVxdWlyZVN5bWJvbHM6IGZhbHNlLFxuICB9LFxufSk7XG5cbmNvbnN0IGNsaWVudCA9IG5ldyBVc2VyUG9vbENsaWVudChzdGFjaywgJ215dXNlcnBvb2xjbGllbnQnLCB7XG4gIHVzZXJQb29sOiB1c2VycG9vbCxcbiAgdXNlclBvb2xDbGllbnROYW1lOiAnc2lnbnVwLXRlc3QnLFxuICBnZW5lcmF0ZVNlY3JldDogZmFsc2UsXG59KTtcblxuLy8gcmVwbGFjZSB3aXRoIEwyIG9uY2UgRG9tYWluIHN1cHBvcnQgaXMgYXZhaWxhYmxlXG5uZXcgQ2ZuVXNlclBvb2xEb21haW4oc3RhY2ssICdteXVzZXJwb29sZG9tYWluJywge1xuICB1c2VyUG9vbElkOiB1c2VycG9vbC51c2VyUG9vbElkLFxuICBkb21haW46IHVzZXJwb29sLm5vZGUudW5pcXVlSWQsXG59KTtcblxubmV3IENmbk91dHB1dChzdGFjaywgJ3VzZXItcG9vbC1pZCcsIHtcbiAgdmFsdWU6IHVzZXJwb29sLnVzZXJQb29sSWQsXG59KTtcblxubmV3IENmbk91dHB1dChzdGFjaywgJ2NsaWVudC1pZCcsIHtcbiAgdmFsdWU6IGNsaWVudC51c2VyUG9vbENsaWVudElkLFxufSk7Il19