"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceSlack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack gitlab_service_slack}
*/
class ServiceSlack extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack gitlab_service_slack} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceSlackConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_service_slack',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.16.1',
                providerVersionConstraint: '~> 3.14'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._branchesToBeNotified = config.branchesToBeNotified;
        this._confidentialIssueChannel = config.confidentialIssueChannel;
        this._confidentialIssuesEvents = config.confidentialIssuesEvents;
        this._confidentialNoteEvents = config.confidentialNoteEvents;
        this._id = config.id;
        this._issueChannel = config.issueChannel;
        this._issuesEvents = config.issuesEvents;
        this._mergeRequestChannel = config.mergeRequestChannel;
        this._mergeRequestsEvents = config.mergeRequestsEvents;
        this._noteChannel = config.noteChannel;
        this._noteEvents = config.noteEvents;
        this._notifyOnlyBrokenPipelines = config.notifyOnlyBrokenPipelines;
        this._notifyOnlyDefaultBranch = config.notifyOnlyDefaultBranch;
        this._pipelineChannel = config.pipelineChannel;
        this._pipelineEvents = config.pipelineEvents;
        this._project = config.project;
        this._pushChannel = config.pushChannel;
        this._pushEvents = config.pushEvents;
        this._tagPushChannel = config.tagPushChannel;
        this._tagPushEvents = config.tagPushEvents;
        this._username = config.username;
        this._webhook = config.webhook;
        this._wikiPageChannel = config.wikiPageChannel;
        this._wikiPageEvents = config.wikiPageEvents;
    }
    get branchesToBeNotified() {
        return this.getStringAttribute('branches_to_be_notified');
    }
    set branchesToBeNotified(value) {
        this._branchesToBeNotified = value;
    }
    resetBranchesToBeNotified() {
        this._branchesToBeNotified = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get branchesToBeNotifiedInput() {
        return this._branchesToBeNotified;
    }
    get confidentialIssueChannel() {
        return this.getStringAttribute('confidential_issue_channel');
    }
    set confidentialIssueChannel(value) {
        this._confidentialIssueChannel = value;
    }
    resetConfidentialIssueChannel() {
        this._confidentialIssueChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get confidentialIssueChannelInput() {
        return this._confidentialIssueChannel;
    }
    get confidentialIssuesEvents() {
        return this.getBooleanAttribute('confidential_issues_events');
    }
    set confidentialIssuesEvents(value) {
        this._confidentialIssuesEvents = value;
    }
    resetConfidentialIssuesEvents() {
        this._confidentialIssuesEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get confidentialIssuesEventsInput() {
        return this._confidentialIssuesEvents;
    }
    get confidentialNoteEvents() {
        return this.getBooleanAttribute('confidential_note_events');
    }
    set confidentialNoteEvents(value) {
        this._confidentialNoteEvents = value;
    }
    resetConfidentialNoteEvents() {
        this._confidentialNoteEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get confidentialNoteEventsInput() {
        return this._confidentialNoteEvents;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get issueChannel() {
        return this.getStringAttribute('issue_channel');
    }
    set issueChannel(value) {
        this._issueChannel = value;
    }
    resetIssueChannel() {
        this._issueChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issueChannelInput() {
        return this._issueChannel;
    }
    get issuesEvents() {
        return this.getBooleanAttribute('issues_events');
    }
    set issuesEvents(value) {
        this._issuesEvents = value;
    }
    resetIssuesEvents() {
        this._issuesEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesEventsInput() {
        return this._issuesEvents;
    }
    // job_events - computed: true, optional: false, required: false
    get jobEvents() {
        return this.getBooleanAttribute('job_events');
    }
    get mergeRequestChannel() {
        return this.getStringAttribute('merge_request_channel');
    }
    set mergeRequestChannel(value) {
        this._mergeRequestChannel = value;
    }
    resetMergeRequestChannel() {
        this._mergeRequestChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestChannelInput() {
        return this._mergeRequestChannel;
    }
    get mergeRequestsEvents() {
        return this.getBooleanAttribute('merge_requests_events');
    }
    set mergeRequestsEvents(value) {
        this._mergeRequestsEvents = value;
    }
    resetMergeRequestsEvents() {
        this._mergeRequestsEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsEventsInput() {
        return this._mergeRequestsEvents;
    }
    get noteChannel() {
        return this.getStringAttribute('note_channel');
    }
    set noteChannel(value) {
        this._noteChannel = value;
    }
    resetNoteChannel() {
        this._noteChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get noteChannelInput() {
        return this._noteChannel;
    }
    get noteEvents() {
        return this.getBooleanAttribute('note_events');
    }
    set noteEvents(value) {
        this._noteEvents = value;
    }
    resetNoteEvents() {
        this._noteEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get noteEventsInput() {
        return this._noteEvents;
    }
    get notifyOnlyBrokenPipelines() {
        return this.getBooleanAttribute('notify_only_broken_pipelines');
    }
    set notifyOnlyBrokenPipelines(value) {
        this._notifyOnlyBrokenPipelines = value;
    }
    resetNotifyOnlyBrokenPipelines() {
        this._notifyOnlyBrokenPipelines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifyOnlyBrokenPipelinesInput() {
        return this._notifyOnlyBrokenPipelines;
    }
    get notifyOnlyDefaultBranch() {
        return this.getBooleanAttribute('notify_only_default_branch');
    }
    set notifyOnlyDefaultBranch(value) {
        this._notifyOnlyDefaultBranch = value;
    }
    resetNotifyOnlyDefaultBranch() {
        this._notifyOnlyDefaultBranch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifyOnlyDefaultBranchInput() {
        return this._notifyOnlyDefaultBranch;
    }
    get pipelineChannel() {
        return this.getStringAttribute('pipeline_channel');
    }
    set pipelineChannel(value) {
        this._pipelineChannel = value;
    }
    resetPipelineChannel() {
        this._pipelineChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipelineChannelInput() {
        return this._pipelineChannel;
    }
    get pipelineEvents() {
        return this.getBooleanAttribute('pipeline_events');
    }
    set pipelineEvents(value) {
        this._pipelineEvents = value;
    }
    resetPipelineEvents() {
        this._pipelineEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipelineEventsInput() {
        return this._pipelineEvents;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get pushChannel() {
        return this.getStringAttribute('push_channel');
    }
    set pushChannel(value) {
        this._pushChannel = value;
    }
    resetPushChannel() {
        this._pushChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushChannelInput() {
        return this._pushChannel;
    }
    get pushEvents() {
        return this.getBooleanAttribute('push_events');
    }
    set pushEvents(value) {
        this._pushEvents = value;
    }
    resetPushEvents() {
        this._pushEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushEventsInput() {
        return this._pushEvents;
    }
    get tagPushChannel() {
        return this.getStringAttribute('tag_push_channel');
    }
    set tagPushChannel(value) {
        this._tagPushChannel = value;
    }
    resetTagPushChannel() {
        this._tagPushChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagPushChannelInput() {
        return this._tagPushChannel;
    }
    get tagPushEvents() {
        return this.getBooleanAttribute('tag_push_events');
    }
    set tagPushEvents(value) {
        this._tagPushEvents = value;
    }
    resetTagPushEvents() {
        this._tagPushEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagPushEventsInput() {
        return this._tagPushEvents;
    }
    get username() {
        return this.getStringAttribute('username');
    }
    set username(value) {
        this._username = value;
    }
    resetUsername() {
        this._username = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
    get webhook() {
        return this.getStringAttribute('webhook');
    }
    set webhook(value) {
        this._webhook = value;
    }
    // Temporarily expose input value. Use with caution.
    get webhookInput() {
        return this._webhook;
    }
    get wikiPageChannel() {
        return this.getStringAttribute('wiki_page_channel');
    }
    set wikiPageChannel(value) {
        this._wikiPageChannel = value;
    }
    resetWikiPageChannel() {
        this._wikiPageChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiPageChannelInput() {
        return this._wikiPageChannel;
    }
    get wikiPageEvents() {
        return this.getBooleanAttribute('wiki_page_events');
    }
    set wikiPageEvents(value) {
        this._wikiPageEvents = value;
    }
    resetWikiPageEvents() {
        this._wikiPageEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiPageEventsInput() {
        return this._wikiPageEvents;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            branches_to_be_notified: cdktf.stringToTerraform(this._branchesToBeNotified),
            confidential_issue_channel: cdktf.stringToTerraform(this._confidentialIssueChannel),
            confidential_issues_events: cdktf.booleanToTerraform(this._confidentialIssuesEvents),
            confidential_note_events: cdktf.booleanToTerraform(this._confidentialNoteEvents),
            id: cdktf.stringToTerraform(this._id),
            issue_channel: cdktf.stringToTerraform(this._issueChannel),
            issues_events: cdktf.booleanToTerraform(this._issuesEvents),
            merge_request_channel: cdktf.stringToTerraform(this._mergeRequestChannel),
            merge_requests_events: cdktf.booleanToTerraform(this._mergeRequestsEvents),
            note_channel: cdktf.stringToTerraform(this._noteChannel),
            note_events: cdktf.booleanToTerraform(this._noteEvents),
            notify_only_broken_pipelines: cdktf.booleanToTerraform(this._notifyOnlyBrokenPipelines),
            notify_only_default_branch: cdktf.booleanToTerraform(this._notifyOnlyDefaultBranch),
            pipeline_channel: cdktf.stringToTerraform(this._pipelineChannel),
            pipeline_events: cdktf.booleanToTerraform(this._pipelineEvents),
            project: cdktf.stringToTerraform(this._project),
            push_channel: cdktf.stringToTerraform(this._pushChannel),
            push_events: cdktf.booleanToTerraform(this._pushEvents),
            tag_push_channel: cdktf.stringToTerraform(this._tagPushChannel),
            tag_push_events: cdktf.booleanToTerraform(this._tagPushEvents),
            username: cdktf.stringToTerraform(this._username),
            webhook: cdktf.stringToTerraform(this._webhook),
            wiki_page_channel: cdktf.stringToTerraform(this._wikiPageChannel),
            wiki_page_events: cdktf.booleanToTerraform(this._wikiPageEvents),
        };
    }
}
exports.ServiceSlack = ServiceSlack;
_a = JSII_RTTI_SYMBOL_1;
ServiceSlack[_a] = { fqn: "@cdktf/provider-gitlab.ServiceSlack", version: "2.0.3" };
// =================
// STATIC PROPERTIES
// =================
ServiceSlack.tfResourceType = "gitlab_service_slack";
//# sourceMappingURL=data:application/json;base64,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