LaPros
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Install

`pip install -U lapros`

## How to use

LaPros works with classifiers. It ranks the suspicious labels given
probabilies by some classification model. You can use normal Python
lists, Numpy arrays or Pandas data. Return values are in a Numpy array
or a Pandas series, the larger the value, the more suspicious are the
coresponding labels.

``` python
from lapros import suspect
```

``` python
labels = [1, 0, 0, 1, 1];
```

``` python
probas = [
    #
    [0.5, 0.6, 0.7, 0.8, 0.9],
    [0.5, 0.4, 0.3, 0.2, 0.1],
];
```

``` python
suspect(
    probas,
    labels=labels,
)
```

<div>
<style scoped>
    .dataframe tbody tr th:only-of-type {
        vertical-align: middle;
    }

    .dataframe tbody tr th {
        vertical-align: top;
    }

    .dataframe thead th {
        text-align: right;
    }
</style>
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>err</th>
      <th>suspected</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>0</th>
      <td>0.4</td>
      <td>False</td>
    </tr>
    <tr>
      <th>1</th>
      <td>0.3</td>
      <td>False</td>
    </tr>
    <tr>
      <th>2</th>
      <td>0.1</td>
      <td>False</td>
    </tr>
    <tr>
      <th>3</th>
      <td>0.7</td>
      <td>False</td>
    </tr>
    <tr>
      <th>4</th>
      <td>0.9</td>
      <td>True</td>
    </tr>
  </tbody>
</table>
</div>

## docstring

------------------------------------------------------------------------

### suspect

Rank the suspicious labels given probas from a classifier. Accept Numpy
arrays, Pandas dataframes and series, and normal Python lists. We can
use interger, string or even float labels, given that the probability
matrix’s columns are indexed by the same label set.

Args:

- probas (n x m matrix): probabilites for possible classes.

KwArgs:

- labels (n x 1 vector): observed class labels

Returns: a Pandas DataFrame including 1 index and 2 columns:

- id (int): the index which is the same to the original data row index
- err (float): the magnitude of suspiciousness, valued between \[0, 1\]
- suspected (bool): whether the data row is suspected as having a label
  error.

``` python
help(suspect)
```

    Help on Function in module lapros.api:

    suspect(...)
        Rank the suspicious labels given probas from a classifier.
        Accept Numpy arrays, Pandas dataframes and series, and normal Python lists.
        We can use interger, string or even float labels, given that
        the probability matrix's columns are indexed by the same label set.
        
        Args:
        - probas (n x m matrix): probabilites for possible classes.
        
        KwArgs:
        - labels (n x 1 vector): observed class labels
        
        Returns: a Pandas DataFrame including 1 index and 2 columns:
        
        - id (int): the index which is the same to the original data row index
        - err (float): the magnitude of suspiciousness, valued between [0, 1]
        - suspected (bool):  whether the data row is suspected as having a label error.
