from typing import Union, List, Optional

from pyspark.sql.types import (
    StructType,
    StructField,
    StringType,
    ArrayType,
    IntegerType,
    DataType,
)


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class VisionPrescription_DispenseSchema:
    """
    An authorization for the supply of glasses and/or contact lenses to a patient.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueUrl",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        An authorization for the supply of glasses and/or contact lenses to a patient.


        id: unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. In order to make the use of extensions safe and
            manageable, there is a strict set of governance  applied to the definition and
            use of extensions. Though any implementer is allowed to define an extension,
            there is a set of requirements that SHALL be met as part of the definition of
            the extension.

        product: Identifies the type of vision correction product which is required for the
            patient.

        eye: The eye for which the lens applies.

        sphere: Lens power measured in diopters (0.25 units).

        cylinder: Power adjustment for astigmatism measured in diopters (0.25 units).

        axis: Adjustment for astigmatism measured in integer degrees.

        prism: Amount of prism to compensate for eye alignment in fractional units.

        base: The relative base, or reference lens edge, for the prism.

        add: Power adjustment for multifocal lenses measured in diopters (0.25 units).

        power: Contact lens power measured in diopters (0.25 units).

        backCurve: Back curvature measured in millimeters.

        diameter: Contact lens diameter measured in millimeters.

        duration: The recommended maximum wear period for the lens.

        color: Special color or pattern.

        brand: Brand recommendations or restrictions.

        note: Notes for special requirements such as coatings and lens materials.

        """
        from spark_fhir_schemas.stu3.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.quantity import QuantitySchema
        from spark_fhir_schemas.stu3.complex_types.annotation import AnnotationSchema

        if (
            max_recursion_limit
            and nesting_list.count("VisionPrescription_Dispense") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["VisionPrescription_Dispense"]
        schema = StructType(
            [
                # unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # Identifies the type of vision correction product which is required for the
                # patient.
                StructField(
                    "product",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The eye for which the lens applies.
                StructField("eye", StringType(), True),
                # Lens power measured in diopters (0.25 units).
                StructField("sphere", IntegerType(), True),
                # Power adjustment for astigmatism measured in diopters (0.25 units).
                StructField("cylinder", IntegerType(), True),
                # Adjustment for astigmatism measured in integer degrees.
                StructField("axis", IntegerType(), True),
                # Amount of prism to compensate for eye alignment in fractional units.
                StructField("prism", IntegerType(), True),
                # The relative base, or reference lens edge, for the prism.
                StructField("base", StringType(), True),
                # Power adjustment for multifocal lenses measured in diopters (0.25 units).
                StructField("add", IntegerType(), True),
                # Contact lens power measured in diopters (0.25 units).
                StructField("power", IntegerType(), True),
                # Back curvature measured in millimeters.
                StructField("backCurve", IntegerType(), True),
                # Contact lens diameter measured in millimeters.
                StructField("diameter", IntegerType(), True),
                # The recommended maximum wear period for the lens.
                StructField(
                    "duration",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Special color or pattern.
                StructField("color", StringType(), True),
                # Brand recommendations or restrictions.
                StructField("brand", StringType(), True),
                # Notes for special requirements such as coatings and lens materials.
                StructField(
                    "note",
                    ArrayType(
                        AnnotationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
