# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_biobertApi.ipynb.

# %% auto 0
__all__ = ['text', 'text1', 'text2', 'text3', 'texts', 'coms', 'blocks', 'create_com_with_idx', 'make_5k_sections',
           'create_one_large_text_block', 'create_all_text_blocks', 'get_comment_spans_textblock', 'query_plain']

# %% ../nbs/00_biobertApi.ipynb 2
import requests
import re
import pandas as pd
from nbdev.showdoc import *

# %% ../nbs/00_biobertApi.ipynb 4
text = "Autophagy maintains tumour growth through circulating the great arginine."
text1 = "X-rays were negative and physical assessment determined soft tissue damage to the lateral aspect of her ankle. She was initially treated with ice, an ace wrap, crutches and mild pain medications (Tylenol with codeine)"
text2 = "It is a skin disease causing much itchiness. Scratching leads to redness, swelling, cracking, weeping clear fluid, crusting, and scaling."
text3 = "Maybe its a tumour. Maybe take some tylenol. Don't worry I'm not a doctor. I'm Dave"
texts = [text,text1,text2,text3]

# %% ../nbs/00_biobertApi.ipynb 6
coms = pd.DataFrame({'comments':texts}) #create comments df

# %% ../nbs/00_biobertApi.ipynb 7
def create_com_with_idx(df, #pandas DataFrame containg a column, titled "comments," of text elements.  In this case these are Youtube comments.
                     ):
    '''This function takes a pandas DataFrame with a column titled "comments" that is filled with text strings, ie. from comments.  It adds an index number to each text string and adds '::' at the end for later parsing.  Finally, it returns all text elements combined into a single text block'''
    df.reset_index(inplace=True)
    df.rename(columns = {"index":"idx"},inplace=True)
    df.idx = df.idx.astype(str)
    df['comidx'] = df.idx +':: '+df.comments+' ::'
    df.comidx = df.comidx.str.lower().str.replace(r'\(|\)',',',regex=True)
    return df

# %% ../nbs/00_biobertApi.ipynb 8
coms = create_com_with_idx(df=coms)

# %% ../nbs/00_biobertApi.ipynb 10
def make_5k_sections(df):
    '''This Function gives section numbers to rows in order to group them later so that each text block is less than 5k characters.'''
    counter = 1 # use this to start with section 1
    df['textLen'] = df.comidx.apply(lambda row: len(row))
    df['cumTxtLen'] = df.textLen.cumsum()
    if df.cumTxtLen.max() < 5000:
        df['section'] = counter
        df1 = df
        print('Less than 5k characters. Only 1 block necessary.')
    else:

        df1 = pd.DataFrame()
        while 1:
            dffk = df.loc[df.cumTxtLen <5000] # df first five k
            dffk['section'] = counter
            counter += 1
            if df.cumTxtLen.max()> 5000:
                df = df.loc[df.cumTxtLen >5000]
                df['cumTxtLen'] = df.textLen.cumsum()
                df1 = pd.concat([df1,dffk])
            else:  
                df['cumTxtLen'] = df.textLen.cumsum()
                df1 = pd.concat([df1,dffk])
                break
    return df1

# %% ../nbs/00_biobertApi.ipynb 11
def create_one_large_text_block(df):
        text_block = ' '.join(df.comidx.tolist()) 
        return text_block

# %% ../nbs/00_biobertApi.ipynb 12
def create_all_text_blocks(df):
    '''This function creates multiple text blocks all less than 5k char.'''
    
    df = make_5k_sections(df)
    
    blocks = []

    for o in df.section.unique():
        dfbl = df.loc[df.section == o]
        
        text_block = ' '.join(dfbl.comidx.tolist())
        blocks.append(text_block)
    return blocks

blocks =  create_all_text_blocks(df=coms)

# %% ../nbs/00_biobertApi.ipynb 17
def get_comment_spans_textblock(text_block:str # single block of text in this structure: `'07 textt ext text. ::'`
                               ):
    '''This function returns a dataframe full of the start, end and span of each text comment/doc in the text_block'''    
    string = text_block
    pattern = r'(\d+:.*?)::'
    dfi = pd.DataFrame()
    for o in re.findall(pattern,string):
            stridx = re.findall(r'(\d+)?::',o) #find the index of the comment from inside the textblock
            stridx = stridx[0]
            pattern2 = fr'({stridx}::.*?)::'  #use this pattern to find the specific text of 'o'
            match=(re.search(pattern2, string))
            #Getting the start and end index in tuple format using match.span()
            text = o
            start = match.start()
            end = match.end()
            span = match.span()
            dfi = dfi.append({'text':text,'start':start,'end':end,'span':span},ignore_index=True)
    return dfi

# %% ../nbs/00_biobertApi.ipynb 23
def query_plain(text:str, #single block of bioMedical text
                url="http://bern2.korea.ac.kr/plain"): # the api address
    '''This function sends your `text_block` to the bern2 API and returns a json of labled biomedical terms from `text_block` with thier indecies.'''
    return requests.post(url, json={'text': text}).json()

# if __name__ == '__main__':
#     text = "Autophagy maintains tumour growth through circulating arginine"
#     print(query_plain(text))
