# -*- coding: utf-8 -*-
# Generated by Django 1.11.25 on 2019-10-24 05:25
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('inputflow', '0003_auto_20191011_0015'),
        ('oauth_clients', '0006_accesstoken_scope'),
    ]

    operations = [
        migrations.CreateModel(
            name='Settings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oauth_client', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='google_sheets_clients', to='oauth_clients.Client', verbose_name='Oauth client')),
            ],
            options={
                'verbose_name': 'Settings',
                'verbose_name_plural': 'Settings',
            },
        ),
        migrations.CreateModel(
            name='Spreadsheet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(max_length=500, verbose_name='URL')),
                ('name', models.CharField(max_length=250, verbose_name='Name')),
                ('spreadsheet_name', models.CharField(max_length=250, verbose_name='Spreadsheet name')),
                ('uid', models.CharField(max_length=250, verbose_name='UID')),
                ('sheet_index', models.PositiveIntegerField(blank=True, default=0, verbose_name='Sheet index')),
                ('sheet_name', models.CharField(blank=True, default='', max_length=250, verbose_name='Sheet name')),
                ('omit_first_row', models.BooleanField(default=True, verbose_name='Omit first row')),
                ('last_imported_row', models.PositiveIntegerField(blank=True, default=None, null=True, verbose_name='Last imported row')),
                ('last_imported_date', models.DateTimeField(blank=True, default=None, null=True, verbose_name='Last imported date')),
            ],
            options={
                'verbose_name': 'Spredsheet',
                'verbose_name_plural': 'Spreadsheets',
            },
        ),
        migrations.CreateModel(
            name='AccessToken',
            fields=[
            ],
            options={
                'verbose_name': 'Access token',
                'proxy': True,
                'verbose_name_plural': 'Access tokens',
                'indexes': [],
            },
            bases=('oauth_clients.accesstoken',),
        ),
        migrations.AddField(
            model_name='spreadsheet',
            name='access_token',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='available_google_sheets', to='inputgooglesheets.AccessToken', verbose_name='Access token'),
        ),
        migrations.AddField(
            model_name='spreadsheet',
            name='input_settings',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='google_spreadsheets', to='inputflow.InputSettings', verbose_name='Input settings'),
        ),
        migrations.AlterUniqueTogether(
            name='spreadsheet',
            unique_together=set([('access_token', 'url')]),
        ),
    ]
