"""Operator Module."""


class Operator:
    """A series of quantum gate operations \
        provide a simple and convenient way to construct a quantum algorithm."""
    pass


class OperatorContext:
    """Operator Context.

    The quantum gate generated by Operator will not make an operation statement.

    Args:
        circuit: Mark the circuit in(out) OperatorContext.
    """

    def __init__(self, circuit):
        self.circuit = circuit

    def __enter__(self):
        self.circuit.enter_op()

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.circuit.exit_op()
