"""
    Sifflet Backend API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from client.api_client import ApiClient, Endpoint as _Endpoint
from client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from client.model.asset_dto import AssetDto
from client.model.assets_catalog_dto import AssetsCatalogDto
from client.model.field_dto import FieldDto
from client.model.get_asset_overview_by_urn200_response import GetAssetOverviewByUrn200Response
from client.model.problem import Problem
from client.model.schema_version_dto import SchemaVersionDto


class AssetApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_asset_by_urn_endpoint = _Endpoint(
            settings={
                'response_type': (AssetDto,),
                'auth': [
                    'JWT'
                ],
                'endpoint_path': '/api/v1/assets/{urn}',
                'operation_id': 'get_asset_by_urn',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'urn',
                ],
                'required': [
                    'urn',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'urn':
                        (str,),
                },
                'attribute_map': {
                    'urn': 'urn',
                },
                'location_map': {
                    'urn': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_asset_fields_with_type_option_endpoint = _Endpoint(
            settings={
                'response_type': ([FieldDto],),
                'auth': [
                    'JWT'
                ],
                'endpoint_path': '/api/v1/assets/{urn}/_get-fields',
                'operation_id': 'get_asset_fields_with_type_option',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'urn',
                    'type',
                ],
                'required': [
                    'urn',
                    'type',
                ],
                'nullable': [
                ],
                'enum': [
                    'type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('type',): {

                        "ANY": "any",
                        "DATE": "date",
                        "TIME": "time",
                        "TEMPORAL": "temporal"
                    },
                },
                'openapi_types': {
                    'urn':
                        (str,),
                    'type':
                        (str,),
                },
                'attribute_map': {
                    'urn': 'urn',
                    'type': 'type',
                },
                'location_map': {
                    'urn': 'path',
                    'type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_asset_overview_by_urn_endpoint = _Endpoint(
            settings={
                'response_type': (GetAssetOverviewByUrn200Response,),
                'auth': [
                    'JWT'
                ],
                'endpoint_path': '/api/v1/assets/{urn}/overview',
                'operation_id': 'get_asset_overview_by_urn',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'urn',
                ],
                'required': [
                    'urn',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'urn':
                        (str,),
                },
                'attribute_map': {
                    'urn': 'urn',
                },
                'location_map': {
                    'urn': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_asset_preview_by_urn_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},)}],),
                'auth': [
                    'JWT'
                ],
                'endpoint_path': '/api/v1/assets/{urn}/preview',
                'operation_id': 'get_asset_preview_by_urn',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'urn',
                    'limit',
                    'fields',
                ],
                'required': [
                    'urn',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'urn':
                        (str,),
                    'limit':
                        (int,),
                    'fields':
                        ([str],),
                },
                'attribute_map': {
                    'urn': 'urn',
                    'limit': 'limit',
                    'fields': 'fields',
                },
                'location_map': {
                    'urn': 'path',
                    'limit': 'query',
                    'fields': 'query',
                },
                'collection_format_map': {
                    'fields': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_asset_schema_by_urn_and_version_endpoint = _Endpoint(
            settings={
                'response_type': ([FieldDto],),
                'auth': [
                    'JWT'
                ],
                'endpoint_path': '/api/v1/assets/{urn}/schema/{version}',
                'operation_id': 'get_asset_schema_by_urn_and_version',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'urn',
                    'version',
                ],
                'required': [
                    'urn',
                    'version',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'urn':
                        (str,),
                    'version':
                        (str,),
                },
                'attribute_map': {
                    'urn': 'urn',
                    'version': 'version',
                },
                'location_map': {
                    'urn': 'path',
                    'version': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_asset_schema_versions_by_urn_endpoint = _Endpoint(
            settings={
                'response_type': ([SchemaVersionDto],),
                'auth': [
                    'JWT'
                ],
                'endpoint_path': '/api/v1/assets/{urn}/schema-versions',
                'operation_id': 'get_asset_schema_versions_by_urn',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'urn',
                ],
                'required': [
                    'urn',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'urn':
                        (str,),
                },
                'attribute_map': {
                    'urn': 'urn',
                },
                'location_map': {
                    'urn': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_search_results_and_filter_endpoint = _Endpoint(
            settings={
                'response_type': (AssetsCatalogDto,),
                'auth': [
                    'JWT'
                ],
                'endpoint_path': '/api/v1/assets/_search-assets',
                'operation_id': 'get_search_results_and_filter',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_num',
                    'page_size',
                    'search',
                    'sort_by',
                    'sort_desc',
                    'datasources',
                    'tags',
                    'health',
                    'asset_type',
                ],
                'required': [
                    'page_num',
                    'page_size',
                ],
                'nullable': [
                ],
                'enum': [
                    'health',
                    'asset_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('health',): {

                        "CRITICAL": "CRITICAL",
                        "AT_RISK": "AT_RISK",
                        "HEALTHY": "HEALTHY",
                        "UNMONITORED": "UNMONITORED",
                        "NOT_SUPPORTED": "NOT_SUPPORTED"
                    },
                    ('asset_type',): {

                        "TABLES": "TABLES",
                        "DASHBOARDS": "DASHBOARDS",
                        "METRICS": "METRICS",
                        "MODELS": "MODELS",
                        "DAGS": "DAGS"
                    },
                },
                'openapi_types': {
                    'page_num':
                        (int,),
                    'page_size':
                        (int,),
                    'search':
                        (str,),
                    'sort_by':
                        ([str],),
                    'sort_desc':
                        ([bool],),
                    'datasources':
                        ([str],),
                    'tags':
                        ([str],),
                    'health':
                        ([str],),
                    'asset_type':
                        ([str],),
                },
                'attribute_map': {
                    'page_num': 'pageNum',
                    'page_size': 'pageSize',
                    'search': 'search',
                    'sort_by': 'sortBy',
                    'sort_desc': 'sortDesc',
                    'datasources': 'datasources',
                    'tags': 'tags',
                    'health': 'health',
                    'asset_type': 'assetType',
                },
                'location_map': {
                    'page_num': 'query',
                    'page_size': 'query',
                    'search': 'query',
                    'sort_by': 'query',
                    'sort_desc': 'query',
                    'datasources': 'query',
                    'tags': 'query',
                    'health': 'query',
                    'asset_type': 'query',
                },
                'collection_format_map': {
                    'sort_by': 'multi',
                    'sort_desc': 'multi',
                    'datasources': 'multi',
                    'tags': 'multi',
                    'health': 'multi',
                    'asset_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.patch_asset_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'JWT'
                ],
                'endpoint_path': '/api/v1/assets/{urn}',
                'operation_id': 'patch_asset',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'urn',
                    'body',
                ],
                'required': [
                    'urn',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'urn':
                        (str,),
                    'body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                    'urn': 'urn',
                },
                'location_map': {
                    'urn': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def get_asset_by_urn(
        self,
        urn,
        **kwargs
    ):
        """Get a single asset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_asset_by_urn(urn, async_req=True)
        >>> result = thread.get()

        Args:
            urn (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AssetDto
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['urn'] = \
            urn
        return self.get_asset_by_urn_endpoint.call_with_http_info(**kwargs)

    def get_asset_fields_with_type_option(
        self,
        urn,
        type,
        **kwargs
    ):
        """Get fields with type option  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_asset_fields_with_type_option(urn, type, async_req=True)
        >>> result = thread.get()

        Args:
            urn (str):
            type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [FieldDto]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['urn'] = \
            urn
        kwargs['type'] = \
            type
        return self.get_asset_fields_with_type_option_endpoint.call_with_http_info(**kwargs)

    def get_asset_overview_by_urn(
        self,
        urn,
        **kwargs
    ):
        """Get a single asset overview params  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_asset_overview_by_urn(urn, async_req=True)
        >>> result = thread.get()

        Args:
            urn (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAssetOverviewByUrn200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['urn'] = \
            urn
        return self.get_asset_overview_by_urn_endpoint.call_with_http_info(**kwargs)

    def get_asset_preview_by_urn(
        self,
        urn,
        **kwargs
    ):
        """Get a single asset preview data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_asset_preview_by_urn(urn, async_req=True)
        >>> result = thread.get()

        Args:
            urn (str):

        Keyword Args:
            limit (int): Number of rows. [optional] if omitted the server will use the default value of 25
            fields ([str]): Columns requested. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['urn'] = \
            urn
        return self.get_asset_preview_by_urn_endpoint.call_with_http_info(**kwargs)

    def get_asset_schema_by_urn_and_version(
        self,
        urn,
        version,
        **kwargs
    ):
        """Get a single asset schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_asset_schema_by_urn_and_version(urn, version, async_req=True)
        >>> result = thread.get()

        Args:
            urn (str):
            version (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [FieldDto]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['urn'] = \
            urn
        kwargs['version'] = \
            version
        return self.get_asset_schema_by_urn_and_version_endpoint.call_with_http_info(**kwargs)

    def get_asset_schema_versions_by_urn(
        self,
        urn,
        **kwargs
    ):
        """Get a single asset schema versions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_asset_schema_versions_by_urn(urn, async_req=True)
        >>> result = thread.get()

        Args:
            urn (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [SchemaVersionDto]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['urn'] = \
            urn
        return self.get_asset_schema_versions_by_urn_endpoint.call_with_http_info(**kwargs)

    def get_search_results_and_filter(
        self,
        page_num,
        page_size,
        **kwargs
    ):
        """Get search results and search filters for asset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_search_results_and_filter(page_num, page_size, async_req=True)
        >>> result = thread.get()

        Args:
            page_num (int):
            page_size (int):

        Keyword Args:
            search (str): [optional]
            sort_by ([str]): [optional]
            sort_desc ([bool]): [optional]
            datasources ([str]): [optional]
            tags ([str]): [optional]
            health ([str]): [optional]
            asset_type ([str]): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AssetsCatalogDto
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['page_num'] = \
            page_num
        kwargs['page_size'] = \
            page_size
        return self.get_search_results_and_filter_endpoint.call_with_http_info(**kwargs)

    def patch_asset(
        self,
        urn,
        body,
        **kwargs
    ):
        """Patch Asset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_asset(urn, body, async_req=True)
        >>> result = thread.get()

        Args:
            urn (str):
            body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['urn'] = \
            urn
        kwargs['body'] = \
            body
        return self.patch_asset_endpoint.call_with_http_info(**kwargs)

