import copy
import shapely
from shapely.geometry import Point
from datetime import datetime
import pandas as pd
import pytz
import numpy as np
import requests

from old_package.errors import ParameterTypeError, DataValidationError
from old_package.url_constructor import AlertURLConstructor
import old_package.utils as utils


class StubError(utils.ErrorObject):
    """An Error object for the stub endpoint.

    Attributes
    ----------
    type: str
        A URI reference (RFC3986) that identifies the problem type.
    title: str
        A short, human-readable summary of the problem type.
    status: int
        The HTTP status code (RFC7231, Section 6) generated by the origin server for this occurrence of the problem.
        Minimum: 100, Max 999
    detail: str
        A human-readable explanation specific to this occurrence of the problem.
    instance: string
        A URI reference that identifies the specific occurrence of the problem.
    correlationId: str
        A unique identifier for the request, used for NWS debugging purposes.
        Please include this identifier with any correspondence to help the API maintainers investigate your issue.
    """
    def __init__(self, response):
        super().__init__(response)


class BaseStub(utils.ObjectIterator):

    n_errors = 0  # count the number of errors in the alert object.
    has_any_request_errors = False
    url_constructor = AlertURLConstructor()

    def __init__(self, response):

        if not response.ok:
            self.alerts = StubError(response)
            self.n_errors += 1
            self.has_any_request_errors = True
        else:
            pass # fill this in

        # TODO: If the object is iterable, set it to self._iterable
        self._iterable = None
        self.response_headers = response.headers

    def to_dataframe(self) -> pd.DataFrame:
        r"""Converts all of all retrieved alerts into a Pandas dataframe.

        Returns
        -------
        pandas.DataFrame
            A dataframe that contains the information (attributes) of all of the alerts requested.
        """
        df = pd.DataFrame()
        for alert in self._iterable:
            df = df.append(alert.series, ignore_index=True)  # append the series.

        df = df.fillna(value=np.nan)  # in case there is missing data
        return df

    def to_dict(self) -> dict:
        r"""Converts all of the attributes to a dictionary.

        Returns
        -------
        dict
            A dictionary containing all of the attributes of the object.
        """

        return self.__dict__


