# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyscreenshot',
 'pyscreenshot.cli',
 'pyscreenshot.examples',
 'pyscreenshot.plugins']

package_data = \
{'': ['*']}

install_requires = \
['pillow>=7.0.0,<8.0.0', 'robotframework>=3.1.2,<4.0.0']

setup_kwargs = {
    'name': 'rpaframework-screenshot',
    'version': '0.3.0',
    'description': 'Fork of pyscreenshot for RPA use',
    'long_description': "The ``pyscreenshot`` module can be used to copy\nthe contents of the screen to a PIL_ or Pillow_ image memory using various back-ends.\nReplacement for the ImageGrab_ Module, which works on Windows only,\nso Windows users don't need this library.\nFor handling image memory (e.g. saving to file, converting,..) please read PIL_ or Pillow_ documentation.\n\nLinks:\n * home: https://github.com/ponty/pyscreenshot\n * documentation: http://pyscreenshot.readthedocs.org\n * PYPI: https://pypi.python.org/pypi/pyscreenshot\n\n|Travis| |Coveralls| |Latest Version| |Supported Python versions| |License| |Documentation|\n\nGoal:\n  Pyscreenshot tries to allow to take screenshots without installing 3rd party libraries.\n  It is cross-platform but useful for Linux based distributions.\n  It is only a pure Python wrapper, a thin layer over existing back-ends.\n  Its strategy should work on most Linux distributions:\n  a lot of back-ends are wrapped, if at least one exists then it works,\n  if not then one back-end should be installed.\n\nFeatures:\n * Cross-platform wrapper\n * Capturing the whole desktop\n * Capturing an area\n * saving to PIL_ or Pillow_ image memory\n * some back-ends are based on this discussion: http://stackoverflow.com/questions/69645/take-a-screenshot-via-a-python-script-linux\n * pure Python library\n * supported Python versions: 2.7, 3.6, 3.7, 3.8\n * It has wrappers for various back-ends:\n     * scrot_\n     * maim_\n     * ImageMagick_\n     * PyGTK_\n     * PIL_ or Pillow_ (only on Windows)\n     * PyQt4_\n     * PyQt5_\n     * PySide_\n     * PySide2_\n     * QtPy_\n     * wxPython_\n     * Quartz (Mac)\n     * screencapture (Mac)\n     * gnome-screenshot_\n     * Python MSS_\n * time taken: 0.1s - 2.0s\n * Performance is not a target for this library, but you can benchmark the back-ends and choose the fastest one.\n * Interactivity is not supported.\n * Mouse pointer is not visible.\n\nKnown problems:\n * ImageMagick_ creates blackbox_ on some systems\n * gnome-screenshot_ back-end does not check $DISPLAY -> not working with Xvfb\n\nSimilar projects:\n - http://sourceforge.net/projects/gtkshots/\n - http://pypi.python.org/pypi/autopy\n - https://github.com/asweigart/pyscreeze\n - https://github.com/BoboTiG/python-mss\n\nExamples\n========\n\ngrab and show the whole screen::\n\n  #-- include('examples/showgrabfullscreen.py') --#\n  import pyscreenshot as ImageGrab\n\n  if __name__ == '__main__':\n\n      # grab fullscreen\n      im = ImageGrab.grab()\n\n      # save image file\n      im.save('screenshot.png')\n\n      # show image in a window\n      im.show()\n  #-#\n\nto start the example::\n\n    python3 -m pyscreenshot.examples.showgrabfullscreen\n\ngrab and show the part of the screen::\n\n  #-- include('examples/showgrabbox.py')--#\n  import pyscreenshot as ImageGrab\n\n  if __name__ == '__main__':\n      # part of the screen\n      im = ImageGrab.grab(bbox=(10, 10, 510, 510))  # X1,Y1,X2,Y2\n      im.show()\n  #-#\n\nto start the example::\n\n    python3 -m pyscreenshot.examples.showgrabbox\n\nInstallation\n============\n\n * install Pillow_ (Ubuntu: ``sudo apt-get install python3-pil``)\n * install at least one back-end\n * install the program::\n\n    pip3 install pyscreenshot\n\n\n\nCommand line interface\n======================\n\nBack-end performance::\n\n  The performance can be checked with pyscreenshot.check.speedtest.\n\n  Example:\n\n  #-- sh('python3 -m pyscreenshot.check.speedtest --virtual-display 2>/dev/null') --#\n\n  n=10\n  ------------------------------------------------------\n  scrot               \t6.1  sec\t(  608 ms per call)\n  imagemagick         \t9.7  sec\t(  969 ms per call)\n  wx                  \t4.1  sec\t(  408 ms per call)\n  pygdk3              \t3.3  sec\t(  328 ms per call)\n  qtpy                \t6.9  sec\t(  687 ms per call)\n  pyqt5               \t6.9  sec\t(  687 ms per call)\n  pyqt                \t6.4  sec\t(  644 ms per call)\n  pyside2             \t6.7  sec\t(  671 ms per call)\n  pyside              \t6.5  sec\t(  652 ms per call)\n  gnome-screenshot    \t12   sec\t( 1209 ms per call)\n  #-#\n\n\nPrint versions::\n\n  #-- sh('python3 -m pyscreenshot.check.versions 2> /dev/null ')--#\n  python               3.7.3\n  pyscreenshot         0.7\n  scrot                1.1.1\n  imagemagick          6.9.10\n  wx                   4.0.4\n  pygdk3               3.32.0\n  qtpy                 1.3.1\n  pyqt5                5.12.1\n  pyqt                 4.12.1\n  pyside2              5.11.2\n  pyside               1.2.2\n  pygtk                missing\n  gnome-screenshot     3.30.0\n  #-#\n\n\nWayland\n=======\n\nOn Wayland only the `gnome-screenshot` back-end works::\n\n im = ImageGrab.grab(backend='gnome-screenshot')\n\n\n\n.. _ImageGrab: http://pillow.readthedocs.org/en/latest/reference/ImageGrab.html\n.. _PIL: http://www.pythonware.com/library/pil/\n.. _Pillow: https://pypi.org/project/Pillow/\n.. _ImageMagick: http://www.imagemagick.org/\n.. _PyGTK: https://pypi.org/project/PyGTK/\n.. _blackbox: http://www.imagemagick.org/discourse-server/viewtopic.php?f=3&t=13658\n.. _scrot: http://en.wikipedia.org/wiki/Scrot\n.. _maim: https://github.com/naelstrof/maim\n.. _PyQt4: https://pypi.org/project/PyQt4/\n.. _PyQt5: https://pypi.org/project/PyQt5/\n.. _PySide: https://pypi.org/project/PySide/\n.. _PySide2: https://pypi.org/project/PySide2/\n.. _QtPy: https://github.com/spyder-ide/qtpy\n.. _wxPython: http://www.wxpython.org/\n.. _gnome-screenshot: https://git.gnome.org/browse/gnome-screenshot/\n.. _MSS: https://github.com/BoboTiG/python-mss\n\n.. |Travis| image:: https://travis-ci.org/ponty/pyscreenshot.svg?branch=master\n   :target: https://travis-ci.org/ponty/pyscreenshot/\n.. |Coveralls| image:: http://img.shields.io/coveralls/ponty/pyscreenshot/master.svg\n   :target: https://coveralls.io/r/ponty/pyscreenshot/\n.. |Latest Version| image:: https://img.shields.io/pypi/v/pyscreenshot.svg\n   :target: https://pypi.python.org/pypi/pyscreenshot/\n.. |Supported Python versions| image:: https://img.shields.io/pypi/pyversions/pyscreenshot.svg\n   :target: https://pypi.python.org/pypi/pyscreenshot/\n.. |License| image:: https://img.shields.io/pypi/l/pyscreenshot.svg\n   :target: https://pypi.python.org/pypi/pyscreenshot/\n.. |Documentation| image:: https://readthedocs.org/projects/pyscreenshot/badge/?version=latest\n   :target: http://pyscreenshot.readthedocs.org\n",
    'author': 'RPA Framework',
    'author_email': 'rpafw@robocorp.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://rpaframework.org/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
