# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Mar 30 15:41:12 2021
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .corr_type_key import tCorrTypeKey

class tCorrType(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 id: str = '',
                 descr: str = '',
                 status: str = '',
                 templ_schema: dict = None,
                 modified_by: str = ''):
        """
        Constructor.

        :param id: str
        :param descr: str
        :param status: str
        :param templ_schema: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.id = id
        self.descr = descr
        self.status = status
        self.templ_schema = templ_schema
        self.modified_by = modified_by
        self.tm_stamp = None

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.id = ''
        self.descr = ''
        self.status = ''
        self.templ_schema = None
        self.modified_by = ''
        self.tm_stamp = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tCorrType'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_string("id", self.id)
        _w.write_string("descr", self.descr)
        _w.write_char("status", self.status)
        _w.write_json("templ_schema", self.templ_schema)
        _w.write_string("modified_by", self.modified_by)
        _w.write_datetime("tm_stamp", self.tm_stamp)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.id = _r.read_string("id")
        self.descr = _r.read_string("descr")
        self.status = _r.read_char("status")
        self.templ_schema = _r.read_json("templ_schema")
        self.modified_by = _r.read_string("modified_by")
        self.tm_stamp = _r.read_datetime("tm_stamp")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tCorrType"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.id = rec.id
        self.descr = rec.descr
        self.status = rec.status
        self.templ_schema = rec.templ_schema
        self.modified_by = rec.modified_by
        self.tm_stamp = rec.tm_stamp

    def _write_pk(self, _key: "tCorrType"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tCorrType"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tCorrTypeKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tCorrTypeKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 16))
        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['sms','email']))
        if key_only:
            return dvc

        dvc.add_targ("descr", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['A','D','F']))
        dvc.add_targ("templ_schema", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tCorrType._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tCorrTypeKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.id = self.id

    def _read_key(self, _key: tCorrTypeKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.id = _key.id

    class Id_Couplet(dict):
        key_s_m_s = "sms"
        key_e_mail = "email"

        value_s_m_s = "SMS"
        value_e_mail = "E-Mail"

        def __init__(self):
            self[self.key_s_m_s] = self.value_s_m_s
            self[self.key_e_mail] = self.value_e_mail

        @staticmethod
        def get_value(key):
            if key == tCorrType.Id_Couplet.key_s_m_s:
                return tCorrType.Id_Couplet.value_s_m_s

            if key == tCorrType.Id_Couplet.key_e_mail:
                return tCorrType.Id_Couplet.value_e_mail

            return ""

    class Status_Couplet(dict):
        key_active = "A"
        key_disabled = "D"
        key_future = "F"

        value_active = "Active"
        value_disabled = "Disabled"
        value_future = "Future"

        def __init__(self):
            self[self.key_active] = self.value_active
            self[self.key_disabled] = self.value_disabled
            self[self.key_future] = self.value_future

        @staticmethod
        def get_value(key):
            if key == tCorrType.Status_Couplet.key_active:
                return tCorrType.Status_Couplet.value_active

            if key == tCorrType.Status_Couplet.key_disabled:
                return tCorrType.Status_Couplet.value_disabled

            if key == tCorrType.Status_Couplet.key_future:
                return tCorrType.Status_Couplet.value_future

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        return (x.id > y.id) - (x.id < y.id)

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<CorrType [id:%.32s, descr:%.32s, status:%.32s, templ_schema:%.32s, modified_by:%.32s, tm_stamp:%s]>' % (
            self.id, self.descr, self.status, self.templ_schema, self.modified_by, self.tm_stamp)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tCorrType.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tCorrType()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tCorrType.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tCorrType._cache_davs(dvc, for_ins, key_only)

