# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class V2ConversationMessageTypingEventForUserTopicConversationMessageContent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        V2ConversationMessageTypingEventForUserTopicConversationMessageContent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'content_type': 'str',
            'location': 'V2ConversationMessageTypingEventForUserTopicConversationContentLocation',
            'story': 'V2ConversationMessageTypingEventForUserTopicConversationContentStory',
            'attachment': 'V2ConversationMessageTypingEventForUserTopicConversationContentAttachment',
            'quick_reply': 'V2ConversationMessageTypingEventForUserTopicConversationContentQuickReply',
            'template': 'V2ConversationMessageTypingEventForUserTopicConversationContentNotificationTemplate',
            'button_response': 'V2ConversationMessageTypingEventForUserTopicConversationContentButtonResponse',
            'generic': 'V2ConversationMessageTypingEventForUserTopicConversationContentGeneric'
        }

        self.attribute_map = {
            'content_type': 'contentType',
            'location': 'location',
            'story': 'story',
            'attachment': 'attachment',
            'quick_reply': 'quickReply',
            'template': 'template',
            'button_response': 'buttonResponse',
            'generic': 'generic'
        }

        self._content_type = None
        self._location = None
        self._story = None
        self._attachment = None
        self._quick_reply = None
        self._template = None
        self._button_response = None
        self._generic = None

    @property
    def content_type(self):
        """
        Gets the content_type of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :return: The content_type of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :param content_type: The content_type of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :type: str
        """
        allowed_values = ["Attachment", "Location", "Story", "QuickReply", "Notification", "ButtonResponse", "GenericTemplate"]
        if content_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for content_type -> " + content_type)
            self._content_type = "outdated_sdk_version"
        else:
            self._content_type = content_type

    @property
    def location(self):
        """
        Gets the location of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :return: The location of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForUserTopicConversationContentLocation
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :param location: The location of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForUserTopicConversationContentLocation
        """
        
        self._location = location

    @property
    def story(self):
        """
        Gets the story of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :return: The story of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForUserTopicConversationContentStory
        """
        return self._story

    @story.setter
    def story(self, story):
        """
        Sets the story of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :param story: The story of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForUserTopicConversationContentStory
        """
        
        self._story = story

    @property
    def attachment(self):
        """
        Gets the attachment of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :return: The attachment of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForUserTopicConversationContentAttachment
        """
        return self._attachment

    @attachment.setter
    def attachment(self, attachment):
        """
        Sets the attachment of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :param attachment: The attachment of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForUserTopicConversationContentAttachment
        """
        
        self._attachment = attachment

    @property
    def quick_reply(self):
        """
        Gets the quick_reply of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :return: The quick_reply of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForUserTopicConversationContentQuickReply
        """
        return self._quick_reply

    @quick_reply.setter
    def quick_reply(self, quick_reply):
        """
        Sets the quick_reply of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :param quick_reply: The quick_reply of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForUserTopicConversationContentQuickReply
        """
        
        self._quick_reply = quick_reply

    @property
    def template(self):
        """
        Gets the template of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :return: The template of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForUserTopicConversationContentNotificationTemplate
        """
        return self._template

    @template.setter
    def template(self, template):
        """
        Sets the template of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :param template: The template of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForUserTopicConversationContentNotificationTemplate
        """
        
        self._template = template

    @property
    def button_response(self):
        """
        Gets the button_response of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :return: The button_response of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForUserTopicConversationContentButtonResponse
        """
        return self._button_response

    @button_response.setter
    def button_response(self, button_response):
        """
        Sets the button_response of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :param button_response: The button_response of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForUserTopicConversationContentButtonResponse
        """
        
        self._button_response = button_response

    @property
    def generic(self):
        """
        Gets the generic of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :return: The generic of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForUserTopicConversationContentGeneric
        """
        return self._generic

    @generic.setter
    def generic(self, generic):
        """
        Sets the generic of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.


        :param generic: The generic of this V2ConversationMessageTypingEventForUserTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForUserTopicConversationContentGeneric
        """
        
        self._generic = generic

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

