# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['perceptor',
 'perceptor.drawers',
 'perceptor.drawers.diffusion',
 'perceptor.drawers.jpeg',
 'perceptor.drawers.raw',
 'perceptor.drawers.raw.init',
 'perceptor.drawers.rudalle',
 'perceptor.losses',
 'perceptor.losses.clip',
 'perceptor.losses.super_resolution',
 'perceptor.models',
 'perceptor.models.adabins_depth',
 'perceptor.models.adabins_depth.models',
 'perceptor.models.blip',
 'perceptor.models.cloob',
 'perceptor.models.deep_image_prior',
 'perceptor.models.glide_clip',
 'perceptor.models.guided_diffusion',
 'perceptor.models.latent_diffusion',
 'perceptor.models.latent_diffusion.finetuned',
 'perceptor.models.latent_diffusion.finetuned.encoders',
 'perceptor.models.latent_diffusion.ldm',
 'perceptor.models.latent_diffusion.ldm.models',
 'perceptor.models.latent_diffusion.ldm.models.diffusion',
 'perceptor.models.latent_diffusion.ldm.modules',
 'perceptor.models.latent_diffusion.ldm.modules.diffusionmodules',
 'perceptor.models.latent_diffusion.ldm.modules.distributions',
 'perceptor.models.latent_diffusion.ldm.modules.encoders',
 'perceptor.models.midas_depth',
 'perceptor.models.monster_diffusion',
 'perceptor.models.monster_diffusion.base',
 'perceptor.models.owlvit',
 'perceptor.models.ruclip',
 'perceptor.models.simulacra_aesthetic',
 'perceptor.models.slip',
 'perceptor.models.stable_diffusion',
 'perceptor.models.stylegan_xl',
 'perceptor.models.stylegan_xl.torch_utils',
 'perceptor.models.stylegan_xl.torch_utils.ops',
 'perceptor.models.super_resolution',
 'perceptor.models.velocity_diffusion',
 'perceptor.transforms',
 'perceptor.transforms.resize',
 'perceptor.utils']

package_data = \
{'': ['*'],
 'perceptor.losses.clip': ['vectors/*'],
 'perceptor.models.blip': ['configs/*'],
 'perceptor.models.cloob': ['pretrained_configs/*'],
 'perceptor.models.latent_diffusion': ['configs/autoencoder/*',
                                       'configs/latent-diffusion/*',
                                       'models/first_stage_models/kl-f16/*',
                                       'models/first_stage_models/kl-f32/*',
                                       'models/first_stage_models/kl-f4/*',
                                       'models/first_stage_models/kl-f8/*',
                                       'models/first_stage_models/vq-f16/*',
                                       'models/first_stage_models/vq-f4-noattn/*',
                                       'models/first_stage_models/vq-f4/*',
                                       'models/first_stage_models/vq-f8-n256/*',
                                       'models/first_stage_models/vq-f8/*',
                                       'models/ldm/bsr_sr/*',
                                       'models/ldm/celeba256/*',
                                       'models/ldm/cin256/*',
                                       'models/ldm/ffhq256/*',
                                       'models/ldm/inpainting_big/*',
                                       'models/ldm/layout2img-openimages256/*',
                                       'models/ldm/lsun_beds256/*',
                                       'models/ldm/lsun_churches256/*',
                                       'models/ldm/semantic_synthesis256/*',
                                       'models/ldm/semantic_synthesis512/*',
                                       'models/ldm/text2img256/*'],
 'perceptor.models.simulacra_aesthetic': ['weights/*']}

install_requires = \
['Pillow>=9.0.1,<10.0.0',
 'basicsr>=1.4.2,<2.0.0',
 'diffusers>=0.2.4,<0.3.0',
 'dill>=0.3.4,<0.4.0',
 'einops>=0.4.0,<0.5.0',
 'ftfy>=6.0.3,<7.0.0',
 'imageio>=2.14.1,<3.0.0',
 'kornia>=0.6.3,<0.7.0',
 'lpips>=0.1.4,<0.2.0',
 'more-itertools>=8.12.0,<9.0.0',
 'ninja>=1.10.2,<2.0.0',
 'numpy>=1.22.2,<2.0.0',
 'omegaconf>=2.1.1,<3.0.0',
 'open-clip-torch>=2.0.2,<3.0.0',
 'opencv-python>=4.5.4,<5.0.0,!=4.6.0.66',
 'pytorch-lantern>=0.12.0,<0.13.0',
 'pytorch-zero-lit>=0.2.1,<0.3.0',
 'resmem>=1.1.4,<2.0.0',
 'taming-transformers-rom1504>=0.0.6,<0.0.7',
 'timm>=0.5.4,<0.6.0',
 'torch>=1.11.0,<2.0.0',
 'torchvision>=0.12.0,<0.13.0',
 'tqdm>=4.62.3,<5.0.0',
 'transformers>=4.21.1,<5.0.0',
 'youtokentome>=1.0.6,<2.0.0']

setup_kwargs = {
    'name': 'perceptor',
    'version': '0.5.14',
    'description': 'Modular image generation library',
    'long_description': '# perceptor\n\nModular image generation library.\n\n## Install\n\n```\npoetry add perceptor\n```\n\nOr, for the old timers:\n\n```\npip install perceptor\n```\n\n## API\n\nShortlist of available features.\n\n```python\nperceptor\n  .drawers\n    .BruteDiffusion\n    .DeepImagePrior\n    .JPEG\n    .Raw\n    .RuDALLE\n    .StyleGANXL\n  .models\n    .AdaBinsDepth\n    .DeepImagePrior\n    .VelocityDiffusion (yfcc_2, yfcc_1, cc12m_1_cfg, wikiart)\n    .latent_diffusion\n      .Text2Image\n      .Face\n      .SuperResolution\n    .GuidedDiffusion (openai, pixelart)\n    .MidasDepth\n    .MonsterDiffusion (all, tinyhero)\n    .StyleGANXL\n    .RuDALLE\n    .StableDiffusion\n    .SuperResolution\n  .losses\n    # Text-image similarity\n    .BLIP\n    .CLIP\n    .CLOOB\n    .LiT\n    .GlideCLIP\n    .OpenCLIP\n    .OWLViT\n    .RuCLIP\n    .SLIP\n    # Other\n    .AestheticVisualAssessment\n    .LPIPS\n    .Memorability\n    .MidasDepth\n    .SimulacraAesthetic\n    .Smoothness\n    .StyleTransfer\n  .transforms\n    .clamp_with_grad\n    .resize\n    .SuperResolution\n  .utils\n    .gradient_checkpoint\n```\n',
    'author': 'Richard Löwenström',
    'author_email': 'samedii@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/samedii/perceptor',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
