
from flask import current_app, g

import sqlite3
import click

import os.path as op


def get_db():
    if 'db' not in g:
        g.db = sqlite3.connect(
            current_app.config_object['POOL_DATABASE'],
            detect_types=sqlite3.PARSE_DECLTYPES
        )
        g.db.row_factory = sqlite3.Row

    return g.db


def close_db(e=None):
    db = g.pop('db', None)

    if db is not None:
        db.close()


def init_db():
    db = get_db()
    dbpath = op.join(op.abspath(op.dirname(__file__)), 'schema.sql')

    with current_app.open_resource(dbpath) as f:
        db.executescript(f.read().decode('utf8'))


@click.command('init-db')
def init_db_command():
    """Clear the existing data and create new tables."""
    init_db()
    click.echo('Initialized the database.')


def init_app(app):
    app.teardown_appcontext(close_db)
    app.cli.add_command(init_db_command)
