# CoralNet-Toolbox 🪸🧰

<div align="center">
  <p>
    <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/CoralNet_Toolbox.png" alt="CoralNet-Toolbox" width="400">
  </p>
  
  <h3>🌊 <em>Empowering Coral Reef Research with AI-Powered Annotation Tools</em> 🌊</h3>
  
  <p><strong>An unofficial toolkit to supercharge your <a href="https://coralnet.ucsd.edu/">CoralNet</a> workflows with cutting-edge computer vision</strong></p>
</div>

---

## 📊 Project Stats

<div align="center">

[![Python Version](https://img.shields.io/pypi/pyversions/CoralNet-Toolbox.svg?style=for-the-badge&logo=python&logoColor=white)](https://pypi.org/project/CoralNet-Toolbox)
[![Version](https://img.shields.io/pypi/v/CoralNet-Toolbox.svg?style=for-the-badge&color=blue)](https://pypi.python.org/pypi/CoralNet-Toolbox)
[![Downloads](https://img.shields.io/pepy/dt/coralnet-toolbox.svg?style=for-the-badge&color=brightgreen)](https://pepy.tech/project/coralnet-toolbox)

[![PyPI Passing](https://img.shields.io/github/actions/workflow/status/Jordan-Pierce/CoralNet-Toolbox/pypi.yml?style=for-the-badge&label=PyPI%20Build&logo=github)](https://pypi.org/project/CoralNet-Toolbox)
[![Windows](https://img.shields.io/github/actions/workflow/status/Jordan-Pierce/CoralNet-Toolbox/windows.yml?style=for-the-badge&label=Windows&logo=windows&logoColor=white)](https://pypi.org/project/CoralNet-Toolbox)
[![macOS](https://img.shields.io/github/actions/workflow/status/Jordan-Pierce/CoralNet-Toolbox/macos.yml?style=for-the-badge&label=macOS&logo=apple&logoColor=white)](https://pypi.org/project/CoralNet-Toolbox)
[![Ubuntu](https://img.shields.io/github/actions/workflow/status/Jordan-Pierce/CoralNet-Toolbox/ubuntu.yml?style=for-the-badge&label=Ubuntu&logo=ubuntu&logoColor=white)](https://pypi.org/project/CoralNet-Toolbox)

</div>

---

## ✨ Why CoralNet-Toolbox?

<div align="center">
  
| 🎯 **Smart Annotation** | 🤖 **AI-Powered** | 🚀 **Complete Pipeline** |
|:---:|:---:|:---:|
| Create patches, rectangles, and polygons with intelligent assistance | Leverage SAM, YOLO, and foundation models | From data collection to deployment |
| *Precision meets efficiency* | *Cutting-edge AI at your fingertips* | *End-to-end workflow automation* |

</div>

---

## ⚡ Quick Start ⚡ 

Get up and running in seconds:

```bash
# 💻 Installation
pip install coralnet-toolbox

# 🚀 Launch
coralnet-toolbox
```

> **🎉 That's it!** The toolbox will open and you're ready to start annotating! 

For a complete installation guide (including CUDA setup), see the [Installation Documentation](https://jordan-pierce.github.io/CoralNet-Toolbox/installation).

---

## 📚 Documentation Hub

<div align="center">

| 📖 Guide | 🎯 Purpose | 🔗 Link |
|:---:|:---:|:---:|
| **Overview** | Get the big picture | [📋 Read More](https://jordan-pierce.github.io/CoralNet-Toolbox/overview) |
| **Installation** | Detailed setup instructions | [⚙️ Setup Guide](https://jordan-pierce.github.io/CoralNet-Toolbox/installation) |
| **Usage** | Learn the tools | [🛠️ User Manual](https://jordan-pierce.github.io/CoralNet-Toolbox/usage) |
| **Hot Keys** | Keyboard shortcuts | [⌨️ Shortcuts](https://jordan-pierce.github.io/CoralNet-Toolbox/hot-keys) |
| **Classification** | Community tutorial | [🧠 AI Tutorial](https://jordan-pierce.github.io/CoralNet-Toolbox/classify) |

</div>

---

## 🎥 Video Demonstrations

<details open>
<summary><h3>📺 <strong>Watch the Complete Tutorial Series</strong></h3></summary>

<div align="center">
  <a href="https://youtube.com/playlist?list=PLG5z9IbwhS5NQT3B2jrg3hxQgilDeZak9&feature=shared">
    <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/toolbox_qt.PNG" alt="Video Tutorial Series" width="80%" style="border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
  </a>
  
  <p><strong>🎬 Complete playlist covering all major features and workflows</strong></p>
</div>

</details>

---

## 🤖 AI Model Arsenal

The toolbox integrates state-of-the-art models for efficient annotation workflows:

<div align="center">

### 🏋️ **Trainable Models**

| **YOLO Family** | **Versions Available** |
|:---:|:---:|
| 🦾 **Legacy** | YOLOv3 • YOLOv4 • YOLOv5 |
| 🚀 **Modern** | YOLOv6 • YOLOv7 • YOLOv8 |
| ⚡ **Latest** | YOLOv9 • YOLOv10 • YOLO11 • YOLO12 |

*Powered by the [Ultralytics](https://ultralytics.com/) ecosystem*

</div>

<div align="center">

### 🎯 **Segment Anything Models**

| **Model** | **Specialty** | **Use Case** |
|:---:|:---:|:---:|
| 🪸 **SAM** | General segmentation | High-quality masks |
| 🌊 **CoralSCOP** | Coral-specific | Marine biology focus |
| ⚡ **FastSAM** | Speed optimized | Real-time annotation |
| 📱 **MobileSAM** | Mobile-friendly | Edge deployment |
| ✂️ **EdgeSAM** | Efficient | Resource-constrained |
| 🔍 **RepViT-SAM** | Vision transformers | Advanced features |

*Powered by our [xSAM](https://Github.com/Jordan-Pierce/xSAM) integration*

</div>

<div align="center">

### 👁️ **Visual Prompting & Foundation Models**

| **Framework** | **Models** | **Capability** |
|:---:|:---:|:---:|
| **YOLOE** | See Anything | Visual prompt detection |
| **Transformers** | Grounding DINO • OWLViT • OmDetTurbo | Zero-shot detection |

</div>

---

## 🛠️ Feature Showcase

<div align="center">

### 📝 **Core Annotation Tools**

| <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Patches.gif" alt="Patch Annotation" width="250" style="border-radius: 8px;"/><br>**🎯 Patch Annotation** | <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Rectangles.gif" alt="Rectangle Annotation" width="250" style="border-radius: 8px;"/><br>**📐 Rectangle Annotation** | <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Polygons.gif" alt="Polygon Annotation" width="250" style="border-radius: 8px;"/><br>**🔷 Multi-Polygon Annotation** |
|:---:|:---:|:---:|

### 🤖 **AI-Powered Analysis**

| <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Classification.gif" alt="Classification" width="250" style="border-radius: 8px;"/><br>**🧠 Image Classification** | <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Object_Detection.gif" alt="Object Detection" width="250" style="border-radius: 8px;"/><br>**🎯 Object Detection** | <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Instance_Segmentation.gif" alt="Instance Segmentation" width="250" style="border-radius: 8px;"/><br>**🎭 Instance Segmentation** |
|:---:|:---:|:---:|

### 🔬 **Advanced Capabilities**

| <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Segment_Anything.gif" alt="SAM" width="250" style="border-radius: 8px;"/><br>**🪸 Segment Anything (SAM)** | <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Classifying_Polygons.gif" alt="Polygon Classification" width="250" style="border-radius: 8px;"/><br>**🔍 Polygon Classification** | <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Work_Areas.gif" alt="Work Areas" width="250" style="border-radius: 8px;"/><br>**📍 Region-based Detection** |
|:---:|:---:|:---:|

### ✂️ **Editing & Processing Tools**

| <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Cut.gif" alt="Cut Tool" width="250" style="border-radius: 8px;"/><br>**✂️ Cut** | <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Combine.gif" alt="Combine Tool" width="250" style="border-radius: 8px;"/><br>**🔗 Combine** | <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Simplify.gif" alt="Simplify Tool" width="250" style="border-radius: 8px;"/><br>**🎨 Simplify** |
|:---:|:---:|:---:|

### 🌟 **Specialized Features**

| <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/See_Anything.gif" alt="YOLOE" width="400" style="border-radius: 8px;"/><br>**👁️ See Anything (YOLOE)** | <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Classifying_Orthomosaics.gif" alt="LAI Classification" width="400" style="border-radius: 8px;"/><br>**🗺️ LAI Classification** |
|:---:|:---:|

### 📊 **Analysis & Exploration**

| <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Analytics.gif" alt="Video Analysis" width="400" style="border-radius: 8px;"/><br>**🎬 Video Inference & Analytics** | <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/figures/tools/Explorer.gif" alt="Data Explorer" width="400" style="border-radius: 8px;"/><br>**🔍 Data Explorer & Clustering** |
|:---:|:---:|

</div>

---

## 🔧 Complete Workflow Pipeline

### 📥 **Data Input**
- **🔥 CoralNet Download**: Retrieve source data and annotations
- **🎬 Video Processing**: Extract frames from video files
- **📸 Image Import**: Support for various image formats

### ✏️ **Annotation & Labeling**
- **👆 Manual Annotation**: Intuitive point, rectangle, and polygon tools
- **🤖 AI-Assisted**: SAM, YOLO, and visual prompting models
- **📐 Precision Editing**: Cut, combine, subtract, and simplify shapes

### 🧠 **Machine Learning**
- **🔬 Hyperparameter Tuning**: Optimize training conditions
- **🚀 Model Training**: Build custom classifiers and detectors
- **⚡ Model Optimization**: Production-ready deployment

### 📊 **Analysis & Export**
- **📈 Performance Evaluation**: Comprehensive model metrics
- **🎯 Batch Inference**: Process multiple images automatically
- **🎥 Video Analysis**: Real-time processing with analytics
- **📋 Multi-format Export**: CoralNet, Viscore, TagLab, GeoJSON

---

## 📋 Roadmap

*See the current tickets and planned features on the [GitHub Issues Page](https://github.com/Jordan-Pierce/CoralNet-Toolbox/issues)*

---

## 💻 Installation Guide

### 🐍 **Step 1: Environment Setup**
```bash
# Create a dedicated environment (recommended)
conda create --name coralnet10 python=3.10 -y
conda activate coralnet10
```

### ⚡ **Step 2: Fast Installation with UV**
```bash
# Install UV for faster package management
pip install uv

# Install CoralNet-Toolbox
uv pip install coralnet-toolbox
```

> **Fallback**: If UV fails, use regular pip: `pip install coralnet-toolbox`

### 🚀 **Step 3: GPU Acceleration (Optional)**
For CUDA-enabled systems:
```bash
# Example for CUDA 12.9
# Install PyTorch with CUDA support
uv pip install torch torchvision --index-url https://download.pytorch.org/whl/cu129 --upgrade
```

### 🏃‍♂️ **Step 4: Launch**
```bash
coralnet-toolbox
```

### 🎯 **GPU Status Indicators**
- **🐢** CPU only
- **🐇** Single GPU
- **🚀** Multiple GPUs  
- **🍎** Mac Metal (Apple Silicon)

*Click the icon in the bottom-left to see available devices*

### 🔄 **Upgrading**
```bash
# When updates are available
uv pip install -U coralnet-toolbox==[latest_version]
```

---

### 🏗️ **Repository Structure**

<div align="center">
  <a href="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/diagram.svg">
    <img src="https://raw.githubusercontent.com/Jordan-Pierce/CoralNet-Toolbox/refs/heads/main/diagram.svg" alt="Visualization of the codebase" width="80%">
  </a>
</div>

---

## 🌊 Success Stories

> **Using CoralNet-Toolbox in your research?** 
> 
> We'd love to feature your work! Share your success stories to help others learn and get inspired.

---

## 🌍 About CoralNet

<div align="center">
  <p><em>🪸 Protecting our oceans, one annotation at a time 🪸</em></p>
</div>

Coral reefs are among Earth's most biodiverse ecosystems, supporting marine life and coastal communities worldwide. However, they face unprecedented threats from climate change, pollution, and human activities.

**[CoralNet](https://coralnet.ucsd.edu/)** is a revolutionary platform enabling researchers to:
- Upload and analyze coral reef photographs
- Create detailed species annotations
- Build AI-powered classification models
- Collaborate with the global research community

The **CoralNet-Toolbox** extends this mission by providing advanced AI tools that accelerate research and improve annotation quality.

---

## 📄 Citation

If you use CoralNet-Toolbox in your research, please cite:

```bibtex
@misc{CoralNet-Toolbox,
  author = {Pierce, Jordan and Battista, Tim and Kuester, Falko},
  title = {CoralNet-Toolbox: Tools for Annotating and Developing Machine Learning Models for Benthic Imagery},
  year = {2025},
  howpublished = {\url{https://github.com/Jordan-Pierce/CoralNet-Toolbox}},
  note = {GitHub repository}
}
```

---

## ⚖️ Legal & Licensing

<div align="center">

### ⚠️ **Disclaimer**
*This is a scientific product and not official communication of NOAA or the US Department of Commerce. All code is provided 'as is' - users assume responsibility for its use.*

### 📋 **License**
*Software created by US Government employees is not subject to copyright in the United States (17 U.S.C. §105). The Department of Commerce reserves rights to seek copyright protection in other countries.*

</div>

---

<div align="center">
  <p><strong>🌊 Built with ❤️ for coral reef conservation 🌊</strong></p>
  <p><em>Empowering researchers • Protecting ecosystems • Advancing science</em></p>
</div>