# AUTOGENERATED! DO NOT EDIT! File to edit: ../../notebooks/api/02c_pds.apps.ipynb.

# %% auto 0
__all__ = ['find_indexes', 'get_index', 'find_instruments', 'refresh_index']

# %% ../../notebooks/api/02c_pds.apps.ipynb 3
import pandas as pd
from ..config import config
from .indexes import Index

# %% ../../notebooks/api/02c_pds.apps.ipynb 4
def find_indexes(
    instrument: str,  # Dotted mission.instrument key, e.g. cassini.iss
) -> list:            # List of configured index names
    "Find existing indexes for an instrument."
    return config.list_indexes(instrument)

# %% ../../notebooks/api/02c_pds.apps.ipynb 6
def get_index(
    instr: str,  # Dotted instrument index, e.g. cassini.iss
    index_name: str='',  # Index name, for exmample 'moon_summary. Optional'
    refresh: bool=False,  # switch to force a refresh of an index
) -> pd.DataFrame:  # The PDS index convert to pandas DataFrame
    """Example: get_index("cassini.iss", "index")"""
    if not index_name:
        index = Index(instr)
    else:
        index = Index(instr + ".indexes." + index_name)
    if index.needs_download or refresh is True:
        print("Index is outdated or not existing or asked to be refreshed.\nDownloading...")
        index.download(force_update=refresh)
        index.convert_to_parquet()
    try:
        return index.parquet
    except FileNotFoundError:
        index.convert_to_parquet()
        return index.parquet

# %% ../../notebooks/api/02c_pds.apps.ipynb 14
def find_instruments(
    mission: str,  # Mission string, e.g. "cassini"
) -> list:  # List of configured instrument names
    "Find existing instruments for a mission."
    return config.list_instruments(mission)

# %% ../../notebooks/api/02c_pds.apps.ipynb 17
def refresh_index(
    instr: str,  # Dotted instrument index, e.g. cassini.iss
    index_name: str,  # Index name, for exmample 'moon_summary'
    download: bool = False,  # also refresh dowload, not only local parquet conversion
):
    """Example: refresh_index("cassini.iss", "index")"""
    index = Index(instr + ".indexes." + index_name)
    if download:
        index.download(force_update=True)
    else:
        index.convert_to_parquet()
    return index.parquet
