PlanetaryPy
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

Potential
logo:![image.png](images/epilup_with_python_logo_with_axis.png)

## Install

``` bash
pip install planetarypy
```

This will pull in these other dependencies and their dependencies:

`tomlkit pandas pvl numpy python-dateutil tqdm lxml yarl hirise-tools kalasiris`

## Suggested standard abbreviations:

- Inside these docs the package will be called `PLPY` for brevity.
- A standard Python import could be: `plp` or `plpy`
  - because the last `p` in `plp` can be pronounced out, we consider
    these equivalent for human conversation and pronounce these
    “plippy”.

## General scope

First and foremost this package should provide support in working with
planetary science data.

With `working` we mean:

- locating
- retrieving
- reading
- further processing

of data.

### Locating

This library manages, via its `PDS tools`, multiple PDS3 index files per
instrument that can be used for identifying data of interest. These
index files are automatically downloaded and converted to the very
performant (and cloud-ready)
[parquet](https://pandas.pydata.org/pandas-docs/stable/reference/api/pandas.read_parquet.html)
file format. \> Parquet is able to store advanced datatypes like
nan-capable integer and full datetime objects, as opposed to HDF5.

### Retrieving

The interface to getting data is via a path-retrieving function based on
a PDS product-id. If that product-id is available locally, the path will
be returned. If it is not, it will previously be downloaded, stored in a
systematic fashion organized by mission and instrument, and then the
local path will be returned.

### Reading

For now, the library only returns the path to the object and the user
needs to sort out the reading process. A recently funded NASA project
`Planetary Data Reader` will be integrated here, so that basic reading
into memory can be provided.

As such, we anticipate two classes of reading support: 1. basic reading
into numpy and/or xarray 1. added reader functionality like basic plots
and basic geospatial processing, as supported by interested parties

There will exist larger other packages that focus on working with a
given instrument’s data, in which case that package could become an
affiliated package with the `planetarypy` GitHub organization, if so
desired.

### Further processing

In the future, additional frequently used procedures will be added to
this library, e.g. \* frequently used GDAL/rasterio procedures \*
frequently used SPICE operations \* like surface illumination on a given
body

## PDS tools

Look at the `Apps` docs to see what `pds.apps` exist for easily getting
PDS indexes. The `find_index` app is specifically useful when you don’t
know what index files exist.

So far, the following indexes are supported (but not necessarily all
tested within PLPY):

- Cassini
  - ISS (all)
  - UVIS (all)
- MRO
  - CTX EDR
  - HiRISE
    - EDR, RDR, DTM
      - EDR index has a bug (as delivered by the team, reported), where
        I need to activate an existing fix for it.
- LRO
  - Diviner (DLRE)
    - EDR, RDR
  - LOLA
    - EDR, RDR

### More indexes

More indexes of other instruments can be easily added by following the
existing structure of what has been copied into your config at
`~/.planetarypy_config.toml`.

Please consider submitting a pull request for adding further PDS index
files into the config file at its source:
https://github.com/michaelaye/nbplanetary/blob/master/planetarypy/data/planetarypy_config.toml

## Utils

Find something in `Utils` for working with NASA timestamps and a well
working URL download function
[`url_retrieve`](https://michaelaye.github.io/planetarypy/api/utils.html#url_retrieve),
among other stuff.

## Experiment/Instrument Specific

So far, `planetarypy` supports CTX EDR and HiRISE RGB.NOMAP data. Look
at the
[`CTX`](https://michaelaye.github.io/planetarypy/api/ctx.html#ctx) and
`HiRISE` pages for descriptions of classes for working with these data.

## Bug reports

Please submit bug reports at
https://github.com/michaelaye/nbplanetary/issues

## How to use

### Indexes

See [PDS apps](02c_pds.apps.ipynb) for more details.

``` python
from planetarypy.pds.apps import get_index
```

``` python
ctrindex = get_index("mro.ctx", "edr")
ctrindex.sample(5, random_state=42)  # setting random_state to always get same files for docs
```

<div>
<style scoped>
    .dataframe tbody tr th:only-of-type {
        vertical-align: middle;
    }

    .dataframe tbody tr th {
        vertical-align: top;
    }

    .dataframe thead th {
        text-align: right;
    }
</style>
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>VOLUME_ID</th>
      <th>FILE_SPECIFICATION_NAME</th>
      <th>ORIGINAL_PRODUCT_ID</th>
      <th>PRODUCT_ID</th>
      <th>IMAGE_TIME</th>
      <th>INSTRUMENT_ID</th>
      <th>INSTRUMENT_MODE_ID</th>
      <th>LINE_SAMPLES</th>
      <th>LINES</th>
      <th>SPATIAL_SUMMING</th>
      <th>...</th>
      <th>SUB_SOLAR_LATITUDE</th>
      <th>SUB_SPACECRAFT_LONGITUDE</th>
      <th>SUB_SPACECRAFT_LATITUDE</th>
      <th>SOLAR_DISTANCE</th>
      <th>SOLAR_LONGITUDE</th>
      <th>LOCAL_TIME</th>
      <th>IMAGE_SKEW_ANGLE</th>
      <th>RATIONALE_DESC</th>
      <th>DATA_QUALITY_DESC</th>
      <th>ORBIT_NUMBER</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>102927</th>
      <td>MROX_3290</td>
      <td>DATA/K09_056855_1472_XN_32S152W.IMG</td>
      <td>4A_04_112001B600</td>
      <td>K09_056855_1472_XN_32S152W</td>
      <td>2018-09-12 15:27:23.819</td>
      <td>CTX</td>
      <td>NIFL</td>
      <td>5056</td>
      <td>7168</td>
      <td>1</td>
      <td>...</td>
      <td>-23.61</td>
      <td>152.16</td>
      <td>-32.84</td>
      <td>206674590.7</td>
      <td>248.70</td>
      <td>15.12</td>
      <td>90.1</td>
      <td>Ride-along with HiRISE</td>
      <td>OK</td>
      <td>56855</td>
    </tr>
    <tr>
      <th>116952</th>
      <td>MROX_3714</td>
      <td>DATA/N08_065442_0965_XN_83S191W.IMG</td>
      <td>4A_04_114C019800</td>
      <td>N08_065442_0965_XN_83S191W</td>
      <td>2020-07-12 17:31:23.962</td>
      <td>CTX</td>
      <td>NIFL</td>
      <td>5056</td>
      <td>33792</td>
      <td>1</td>
      <td>...</td>
      <td>-21.24</td>
      <td>190.23</td>
      <td>-83.51</td>
      <td>207154930.4</td>
      <td>237.37</td>
      <td>17.12</td>
      <td>91.4</td>
      <td>Planum Australe</td>
      <td>OK</td>
      <td>65442</td>
    </tr>
    <tr>
      <th>16386</th>
      <td>MROX_0690</td>
      <td>DATA/B01_010083_2567_XI_76N181W.IMG</td>
      <td>4A_04_103101E100</td>
      <td>B01_010083_2567_XI_76N181W</td>
      <td>2008-09-20 04:33:05.584</td>
      <td>CTX</td>
      <td>ITL</td>
      <td>5056</td>
      <td>52224</td>
      <td>1</td>
      <td>...</td>
      <td>19.30</td>
      <td>180.80</td>
      <td>76.84</td>
      <td>237461101.1</td>
      <td>129.80</td>
      <td>14.76</td>
      <td>89.7</td>
      <td>North polar outlier</td>
      <td>OK</td>
      <td>10083</td>
    </tr>
    <tr>
      <th>107515</th>
      <td>MROX_3450</td>
      <td>DATA/K15_059059_1434_XN_36S196W.IMG</td>
      <td>4A_04_112C004300</td>
      <td>K15_059059_1434_XN_36S196W</td>
      <td>2019-03-03 08:44:14.027</td>
      <td>CTX</td>
      <td>NIFL</td>
      <td>2528</td>
      <td>9216</td>
      <td>1</td>
      <td>...</td>
      <td>-4.38</td>
      <td>196.66</td>
      <td>-36.69</td>
      <td>229158765.3</td>
      <td>349.79</td>
      <td>14.21</td>
      <td>90.1</td>
      <td>Craters in Terra Cimmeria</td>
      <td>OK</td>
      <td>59059</td>
    </tr>
    <tr>
      <th>57288</th>
      <td>MROX_1890</td>
      <td>DATA/D16_033513_1653_XI_14S108W.IMG</td>
      <td>4A_04_10A9016F00</td>
      <td>D16_033513_1653_XI_14S108W</td>
      <td>2013-09-19 20:45:34.363</td>
      <td>CTX</td>
      <td>ITL</td>
      <td>5056</td>
      <td>15360</td>
      <td>1</td>
      <td>...</td>
      <td>10.17</td>
      <td>108.53</td>
      <td>-14.83</td>
      <td>241359283.4</td>
      <td>24.21</td>
      <td>14.66</td>
      <td>90.2</td>
      <td>Syria/Claritas dust-raising event monitoring site</td>
      <td>OK</td>
      <td>33513</td>
    </tr>
  </tbody>
</table>
<p>5 rows × 51 columns</p>
</div>

``` python
hirise_rdr = get_index("mro.hirise", "rdr")
hirise_rdr.sample(5, random_state=42)
```

    TypeError: 'NoneType' object is not iterable

## Instrument tools

### CTX

``` python
from planetarypy.ctx import CTX
```

    Unable to display output for mime type(s): application/javascript, application/vnd.holoviews_load.v0+json

    Unable to display output for mime type(s): application/javascript, application/vnd.holoviews_load.v0+json

<style>.bk-root, .bk-root .bk:before, .bk-root .bk:after {
  font-family: var(--jp-ui-font-size1);
  font-size: var(--jp-ui-font-size1);
  color: var(--jp-ui-font-color1);
}
</style>

``` python
pid = ctrindex.sample(random_state=42).squeeze().PRODUCT_ID
pid
```

    'K09_056855_1472_XN_32S152W'

``` python
ctx = CTX(pid)
ctx
```

    PRODUCT_ID: K09_056855_1472_XN_32S152W
    URL: https://pds-imaging.jpl.nasa.gov/data/mro/mars_reconnaissance_orbiter/ctx/mrox_3290/data/K09_056855_1472_XN_32S152W.IMG
    Local EDR path: /home/ayek72/mnt/slowdata/planetarypy/missions/mro/ctx/edr/K09_056855_1472_XN_32S152W/K09_056855_1472_XN_32S152W.IMG
    Not downloaded yet.

``` python
ctx.source_path
```

    Path('/home/ayek72/mnt/slowdata/planetarypy/missions/mro/ctx/edr/K09_056855_1472_XN_32S152W/K09_056855_1472_XN_32S152W.IMG')

``` python
ctx.download()
```

    K09_056855_1472_XN_32S152W.IMG
    :   0%|          | 0/36246464 [00:00<?, ?it/s]

## Acknowledgements

The creation of this library was in part supported by:

- NASA Cassini UVIS mission
- NASA SSW grant NNX15AH36G
- NASA PDART grant 80NSSC20K0875
- NASA SSW grant 80NSSC20K0748
