from typing import ClassVar, List, Union, Sequence, Tuple, Callable

from pyonear.account import AccessKey
from pyonear.crypto import PublicKey, Signature, Signer
from pyonear.account_id import AccountId
from pyonear.crypto_hash import CryptoHash
from pyonear.error.core import TxExecutionError
from pyonear.config import ExtCosts, ActionCosts
from pyonear.merkle import MerklePathItem

class AddKeyAction:
    __hash__: ClassVar[None]  # type: ignore
    access_key: AccessKey
    public_key: PublicKey
    def __init__(self, public_key: PublicKey, access_key: AccessKey) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "AddKeyAction": ...
    @staticmethod
    def from_json(raw: str) -> "AddKeyAction": ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class CreateAccountAction:
    __hash__: ClassVar[None]  # type: ignore
    def __init__(self) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "CreateAccountAction": ...
    @staticmethod
    def from_json(raw: str) -> "CreateAccountAction": ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class DeleteAccountAction:
    __hash__: ClassVar[None]  # type: ignore
    beneficiary_id: AccountId
    def __init__(self, beneficiary_id: AccountId) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "DeleteAccountAction": ...
    @staticmethod
    def from_json(raw: str) -> "DeleteAccountAction": ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class DeleteKeyAction:
    __hash__: ClassVar[None]  # type: ignore
    public_key: PublicKey
    def __init__(self, public_key: PublicKey) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "DeleteKeyAction": ...
    @staticmethod
    def from_json(raw: str) -> "DeleteKeyAction": ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class DeployContractAction:
    __hash__: ClassVar[None]  # type: ignore
    code: List[int]
    def __init__(self, code: Union[Sequence[int], bytes]) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "DeployContractAction": ...
    @staticmethod
    def from_json(raw: str) -> "DeployContractAction": ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class ExecutionMetadataFieldless:
    V1: ClassVar["ExecutionMetadataFieldless"]
    def __eq__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __int__(self) -> int: ...

class ExecutionOutcome:
    __hash__: ClassVar[None]  # type: ignore
    executor_id: AccountId
    gas_burnt: int
    logs: List[str]
    metadata: ExecutionMetadata
    receipt_ids: List[CryptoHash]
    status: ExecutionStatus
    tokens_burnt: int
    def __init__(
        self,
        logs: Sequence[str],
        receipt_ids: Sequence[CryptoHash],
        gas_burnt: int,
        tokens_burnt: int,
        executor_id: AccountId,
        status: ExecutionStatus,
        metadata: ExecutionMetadata,
    ) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "ExecutionOutcome": ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...
    def to_hashes(self) -> List[CryptoHash]: ...

class ExecutionOutcomeWithId:
    __hash__: ClassVar[None]  # type: ignore
    id: CryptoHash
    outcome: ExecutionOutcome
    def __init__(self, id: CryptoHash, outcome: ExecutionOutcome) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "ExecutionOutcomeWithId": ...
    def to_hashes(self) -> List[CryptoHash]: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class ExecutionOutcomeWithIdAndProof:
    __hash__: ClassVar[None]  # type: ignore
    block_hash: CryptoHash
    outcome_with_id: ExecutionOutcomeWithId
    proof: List[MerklePathItem]
    def __init__(
        self,
        proof: Sequence[MerklePathItem],
        block_hash: CryptoHash,
        outcome_with_id: ExecutionOutcomeWithId,
    ) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "ExecutionOutcomeWithIdAndProof": ...
    def id(self) -> CryptoHash: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class ExecutionStatusFieldless:
    Unknown: ClassVar["ExecutionStatusFieldless"]
    def __eq__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __int__(self) -> int: ...

class FunctionCallAction:
    __hash__: ClassVar[None]  # type: ignore
    args: List[int]
    deposit: int
    gas: int
    method_name: str
    def __init__(
        self, method_name: str, args: Union[Sequence[int], bytes], gas: int, deposit: int
    ) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "FunctionCallAction": ...
    @staticmethod
    def from_json(raw: str) -> "FunctionCallAction": ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class PartialExecutionStatusFieldless:
    Failure: ClassVar["PartialExecutionStatusFieldless"]
    Unknown: ClassVar["PartialExecutionStatusFieldless"]
    def __eq__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __int__(self) -> int: ...

class ProfileData:
    __hash__: ClassVar[None]  # type: ignore
    def __init__(self) -> None: ...
    def action_gas(self) -> int: ...
    def add_action_cost(self, action: ActionCosts, value: int) -> None: ...
    def add_ext_cost(self, ext: ExtCosts, value: int) -> None: ...
    def compute_wasm_instruction_cost(self, total_gas_burnt: int) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "ProfileData": ...
    def get_action_cost(self, action: ActionCosts) -> int: ...
    def get_ext_cost(self, ext: ExtCosts) -> int: ...
    def host_gas(self) -> None: ...
    def merge(self, other: "ProfileData") -> None: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class SignedTransaction:
    __hash__: ClassVar[None]  # type: ignore
    hash: CryptoHash
    signature: Signature
    size: int
    transaction: Transaction
    def __init__(self, signature: Signature, transaction: Transaction) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "SignedTransaction": ...
    @staticmethod
    def from_json(raw: str) -> "SignedTransaction": ...
    def init(self) -> None: ...
    def to_json(self) -> str: ...
    def to_base64(self) -> str: ...
    @staticmethod
    def from_base64(s: str) -> "SignedTransaction": ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class StakeAction:
    __hash__: ClassVar[None]  # type: ignore
    public_key: PublicKey
    stake: int
    def __init__(self, stake: int, public_key: PublicKey) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "StakeAction": ...
    @staticmethod
    def from_json(raw: str) -> "StakeAction": ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class Transaction:
    __hash__: ClassVar[None]  # type: ignore
    actions: List[Action]
    block_hash: CryptoHash
    nonce: int
    public_key: PublicKey
    receiver_id: AccountId
    signer_id: AccountId
    def __init__(
        self,
        signer_id: AccountId,
        public_key: PublicKey,
        nonce: int,
        receiver_id: AccountId,
        block_hash: CryptoHash,
        actions: Sequence[Action],
    ) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "Transaction": ...
    @staticmethod
    def from_json(raw: str) -> "Transaction": ...
    def get_hash_and_size(self) -> Tuple[CryptoHash, int]: ...
    def sign(self, signer: Signer) -> SignedTransaction: ...
    def add_key(
        self, public_key: PublicKey, access_key: AccessKey
    ) -> "Transaction": ...
    def create_account(self) -> "Transaction": ...
    def delete_account(self, beneficiary_id: AccountId) -> "Transaction": ...
    def delete_key(self, public_key: PublicKey) -> "Transaction": ...
    def deploy_contract(self, code: Union[Sequence[int], bytes]) -> "Transaction": ...
    def function_call(
        self,
        method_name: str,
        args: Union[Sequence[int], bytes],
        gas: int,
        deposit: int,
    ) -> "Transaction": ...
    def stake(self, stake: int, public_key: PublicKey) -> "Transaction": ...
    def transfer(self, deposit: int) -> "Transaction": ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

class TransferAction:
    __hash__: ClassVar[None]  # type: ignore
    deposit: int
    def __init__(self, deposit: int) -> None: ...
    @staticmethod
    def from_bytes(data: bytes) -> "TransferAction": ...
    @staticmethod
    def from_json(raw: str) -> "TransferAction": ...
    def to_json(self) -> str: ...
    def __bytes__(self) -> bytes: ...
    def __eq__(self, other) -> bool: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[bytes]]: ...

def verify_transaction_signature(
    transaction: SignedTransaction,
    public_keys: Sequence[PublicKey],
) -> bool: ...

Action = Union[
    CreateAccountAction,
    DeployContractAction,
    FunctionCallAction,
    TransferAction,
    StakeAction,
    AddKeyAction,
    DeleteKeyAction,
    DeleteAccountAction,
]

ExecutionMetadata = Union[ExecutionMetadataFieldless, ProfileData]

ExecutionStatus = Union[
    ExecutionStatusFieldless, TxExecutionError, List[int], CryptoHash
]

PartialExecutionStatus = Union[PartialExecutionStatusFieldless, List[int], CryptoHash]
